/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.ironbookshelves.init;

import com.jahirtrap.ironbookshelves.block.AmethystBookshelfBlock;
import com.jahirtrap.ironbookshelves.block.BaseBookshelfBlock;
import com.jahirtrap.ironbookshelves.block.CryingObsidianBookshelfBlock;
import com.jahirtrap.ironbookshelves.init.ModConfig;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModContent {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ironbookshelves");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ironbookshelves");
    public static final DeferredBlock<Block> IRON_BOOKSHELF = ModContent.registerBlock("iron_bookshelf", () -> new BaseBookshelfBlock(ModConfig.ironEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.IRON_BLOCK)), new Item.Properties());
    public static final DeferredBlock<Block> GOLDEN_BOOKSHELF = ModContent.registerBlock("golden_bookshelf", () -> new BaseBookshelfBlock(ModConfig.goldenEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.GOLD_BLOCK)), new Item.Properties());
    public static final DeferredBlock<Block> DIAMOND_BOOKSHELF = ModContent.registerBlock("diamond_bookshelf", () -> new BaseBookshelfBlock(ModConfig.diamondEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK)), new Item.Properties());
    public static final DeferredBlock<Block> EMERALD_BOOKSHELF = ModContent.registerBlock("emerald_bookshelf", () -> new BaseBookshelfBlock(ModConfig.emeraldEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.EMERALD_BLOCK)), new Item.Properties());
    public static final DeferredBlock<Block> OBSIDIAN_BOOKSHELF = ModContent.registerBlock("obsidian_bookshelf", () -> new BaseBookshelfBlock(ModConfig.obsidianEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OBSIDIAN)), new Item.Properties());
    public static final DeferredBlock<Block> NETHERITE_BOOKSHELF = ModContent.registerBlock("netherite_bookshelf", () -> new BaseBookshelfBlock(ModConfig.netheriteEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK)), new Item.Properties().fireResistant());
    public static final DeferredBlock<Block> COPPER_BOOKSHELF = ModContent.registerBlock("copper_bookshelf", () -> new BaseBookshelfBlock(ModConfig.copperEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.COPPER_BLOCK)), new Item.Properties());
    public static final DeferredBlock<Block> AMETHYST_BOOKSHELF = ModContent.registerBlock("amethyst_bookshelf", () -> new AmethystBookshelfBlock(ModConfig.amethystEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK)), new Item.Properties());
    public static final DeferredBlock<Block> CRYING_OBSIDIAN_BOOKSHELF = ModContent.registerBlock("crying_obsidian_bookshelf", () -> new CryingObsidianBookshelfBlock(ModConfig.cryingObsidianEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.CRYING_OBSIDIAN)), new Item.Properties());
    public static final DeferredBlock<Block> ENDERITE_BOOKSHELF = ModContent.registerBlock("enderite_bookshelf", () -> new BaseBookshelfBlock(ModConfig.enderiteEnchantPower, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).sound(SoundType.NETHERITE_BLOCK).strength(66.0f, 1200.0f).requiresCorrectToolForDrops()), new Item.Properties().fireResistant());
    public static final DeferredBlock<Block> STEEL_BOOKSHELF = ModContent.registerBlock("steel_bookshelf", () -> new BaseBookshelfBlock(ModConfig.steelEnchantPower, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops()), new Item.Properties());
    public static final DeferredBlock<Block> BRONZE_BOOKSHELF = ModContent.registerBlock("bronze_bookshelf", () -> new BaseBookshelfBlock(ModConfig.bronzeEnchantPower, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops()), new Item.Properties());
    public static final DeferredBlock<Block> ZURITE_BOOKSHELF = ModContent.registerBlock("zurite_bookshelf", () -> new BaseBookshelfBlock(ModConfig.zuriteEnchantPower, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK).mapColor(MapColor.COLOR_GRAY)), new Item.Properties().fireResistant());

    private static DeferredBlock<Block> registerBlock(String name, Supplier<Block> supplier, Item.Properties itemProp) {
        DeferredBlock<Block> blockReg = ModContent.registerBlock(name, supplier);
        ModContent.registerItem(name, () -> new BlockItem((Block)blockReg.get(), itemProp));
        return blockReg;
    }

    private static DeferredBlock<Block> registerBlock(String name, Supplier<Block> supplier) {
        return BLOCKS.register(name, supplier);
    }

    private static DeferredItem<Item> registerItem(String name, Supplier<Item> supplier) {
        return ITEMS.register(name, supplier);
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }
}

