/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.ancientreforging.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingScreen;
import dev.shadowsoffire.apotheosis.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.client.GhostVertexBuilder;
import ianm1647.ancientreforging.screen.AncientReforgingMenu;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AncientReforgingScreen
extends AdventureContainerScreen<AncientReforgingMenu> {
    public static final ResourceLocation TEXTURE = Apotheosis.loc((String)"textures/gui/reforge.png");
    public static final ResourceLocation ANIMATED_TEXTURE = Apotheosis.loc((String)"textures/gui/reforge_animation.png");
    public static final int MAX_ANIMATION_TIME = 8;
    protected boolean hasMainItem = false;
    protected int animationTick = 0;
    protected int maxSlot = -1;
    protected int opacityTick = 0;
    protected int availableOpacity = 170;

    public AncientReforgingScreen(AncientReforgingMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.imageHeight = 266;
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float pPartialTick) {
        super.render(gfx, mouseX, mouseY, pPartialTick);
        RenderSystem.disableBlend();
        this.renderTooltip(gfx, mouseX, mouseY);
        int sigils = ((AncientReforgingMenu)this.menu).getSigilCount();
        int mats = ((AncientReforgingMenu)this.menu).getMatCount();
        int levels = ((AncientReforgingMenu)this.menu).player.experienceLevel;
        for (int idx = 0; idx < 3; ++idx) {
            ItemStack choice;
            Slot slot = ((AncientReforgingMenu)this.getMenu()).getSlot(3 + idx);
            if (!this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY) || (choice = slot.getItem()).isEmpty()) continue;
            ArrayList<Object> tooltips = new ArrayList<Object>();
            int sigilCost = ((AncientReforgingMenu)this.menu).getSigilCost(idx);
            int matCost = ((AncientReforgingMenu)this.menu).getMatCost(idx);
            int levelCost = ((AncientReforgingMenu)this.menu).getLevelCost(idx);
            boolean creative = this.minecraft.player.isCreative();
            tooltips.add(Component.translatable((String)"text.apotheosis.reforge_cost").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
            tooltips.add(CommonComponents.EMPTY);
            if (sigilCost > 0) {
                tooltips.add(Component.translatable((String)"%s %s", (Object[])new Object[]{sigilCost, ((Item)Apoth.Items.SIGIL_OF_REBIRTH.value()).getName(ItemStack.EMPTY)}).withStyle(creative || sigils >= sigilCost ? ChatFormatting.GRAY : ChatFormatting.RED));
            }
            if (matCost > 0) {
                tooltips.add(Component.translatable((String)"%s %s", (Object[])new Object[]{matCost, ((AncientReforgingMenu)this.menu).getSlot(1).getItem().getHoverName().getString()}).withStyle(creative || mats >= matCost ? ChatFormatting.GRAY : ChatFormatting.RED));
            }
            String key = idx == 0 ? "container.enchant.level.one" : "container.enchant.level.many";
            tooltips.add(Component.translatable((String)key, (Object[])new Object[]{idx + 1}).withStyle(creative || levels >= levelCost ? ChatFormatting.GRAY : ChatFormatting.RED));
            tooltips.add(Component.literal((String)" "));
            tooltips.add(Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{levelCost}).withStyle(creative || levels >= levelCost ? ChatFormatting.GRAY : ChatFormatting.RED));
            this.drawOnLeft(gfx, tooltips, this.getGuiTop() + 45);
            break;
        }
    }

    protected void renderBg(GuiGraphics gfx, float partials, int x, int y) {
        Slot slot;
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int xCenter = (this.width - this.imageWidth) / 2;
        int yCenter = (this.height - this.imageHeight) / 2;
        gfx.blit(TEXTURE, xCenter, yCenter, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 384);
        for (int idx = 0; idx < 3; ++idx) {
            if (this.maxSlot < idx || this.animationTick != 0) continue;
            gfx.blit(TEXTURE, left + 20 + 46 * idx, top + 129, (float)(20 + 46 * idx), 273.0f, 46, 35, 256, 384);
        }
        boolean hadItem = this.hasMainItem;
        this.hasMainItem = ((AncientReforgingMenu)this.menu).getSlot(0).hasItem();
        if (!hadItem && this.hasMainItem) {
            this.animationTick = 8;
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)Apoth.Sounds.REFORGE.value()), (float)1.0f, (float)2.0f));
        }
        if (this.hasMainItem) {
            float delta = Mth.clamp((float)((8.0f - (float)this.animationTick) / 8.0f), (float)0.0f, (float)1.0f);
            int frame = Mth.lerpInt((float)delta, (int)0, (int)19);
            gfx.blit(ANIMATED_TEXTURE, left + 26, top + 15, 127, 112, 0.0f, (float)(frame * 112), 127, 112, 127, 2240);
        }
        int sigils = ((AncientReforgingMenu)this.menu).getSigilCount();
        int mats = ((AncientReforgingMenu)this.menu).getMatCount();
        int levels = ((AncientReforgingMenu)this.menu).player.experienceLevel;
        this.maxSlot = -1;
        for (int idx = 0; idx < 3 && (slot = ((AncientReforgingMenu)this.getMenu()).getSlot(3 + idx)).hasItem(); ++idx) {
            int sigilCost = ((AncientReforgingMenu)this.menu).getSigilCost(idx);
            int matCost = ((AncientReforgingMenu)this.menu).getMatCost(idx);
            int levelCost = ((AncientReforgingMenu)this.menu).getLevelCost(idx);
            if ((sigils < sigilCost || levels < levelCost || mats < matCost) && !this.minecraft.player.getAbilities().instabuild) continue;
            ++this.maxSlot;
        }
    }

    protected int darken(int rColor, int factor) {
        int r = rColor >> 16 & 0xFF;
        int g = rColor >> 8 & 0xFF;
        int b = rColor & 0xFF;
        return (r /= factor) << 16 | (g /= factor) << 8 | (b /= factor);
    }

    protected void drawBorderedString(GuiGraphics gfx, String str, int x, int y, int color, int shadowColor) {
        MutableComponent comp = Component.literal((String)str);
        gfx.drawString(this.font, (Component)comp, x, y - 1, shadowColor, false);
        gfx.drawString(this.font, (Component)comp, x - 1, y, shadowColor, false);
        gfx.drawString(this.font, (Component)comp, x, y + 1, shadowColor, false);
        gfx.drawString(this.font, (Component)comp, x + 1, y, shadowColor, false);
        gfx.drawString(this.font, (Component)comp, x, y, color, false);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        for (int k = 0; k < 3; ++k) {
            double d0 = pMouseX - (double)(i + 60);
            double d1 = pMouseY - (double)(j + 14 + 19 * k);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 108.0) || !(d1 < 19.0) || !((AncientReforgingMenu)this.menu).clickMenuButton((Player)this.minecraft.player, k)) continue;
            this.minecraft.gameMode.handleInventoryButtonClick(((AncientReforgingMenu)this.menu).containerId, k);
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    protected void containerTick() {
        ++this.opacityTick;
        if (this.animationTick > 0) {
            --this.animationTick;
            if (this.animationTick == 0) {
                this.opacityTick = 0;
            }
        }
        float sin = Mth.sin((float)((float)this.opacityTick / 60.0f * (float)Math.PI));
        float delta = sin * sin;
        this.availableOpacity = Mth.lerpInt((float)delta, (int)136, (int)221);
    }

    public void renderSlot(GuiGraphics gfx, Slot slot) {
        if (slot instanceof AncientReforgingMenu.ReforgingResultSlot) {
            if (this.animationTick == 0) {
                int opacity = this.maxSlot >= slot.getContainerSlot() ? this.availableOpacity : 64;
                PoseStack pose = gfx.pose();
                pose.pushPose();
                pose.translate(0.0f, 0.0f, 100.0f);
                SalvagingScreen.renderGuiItem((GuiGraphics)gfx, (ItemStack)slot.getItem(), (int)slot.x, (int)slot.y, (Function)GhostVertexBuilder.makeGhostBuffer((int)opacity));
                pose.popPose();
            }
        } else {
            super.renderSlot(gfx, slot);
        }
    }
}

