/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.ancientreforging.screen;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.reforging.ReforgingRecipe;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import ianm1647.ancientreforging.Reforge;
import ianm1647.ancientreforging.block.AncientReforgingTableTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class AncientReforgingMenu
extends BlockEntityMenu<AncientReforgingTableTile> {
    public static final String REFORGE_SEED = "apoth_reforge_seed";
    protected final Player player;
    protected InternalItemHandler itemInv = new InternalItemHandler(1);
    protected InternalItemHandler choicesInv = new InternalItemHandler(3);
    protected final RandomSource random = new XoroshiroRandomSource(0L);
    protected final int[] costs = new int[3];
    protected int seed = -1;

    public AncientReforgingMenu(int id, Inventory inv, BlockPos pos) {
        super(Reforge.Menus.ANCIENT_REFORGING, id, inv, pos);
        this.player = inv.player;
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot(this, this.itemInv, 0, 81, 62, stack -> !LootCategory.forItem((ItemStack)stack).isNone()){

            public int getMaxStackSize() {
                return 1;
            }

            public int getMaxStackSize(ItemStack pStack) {
                return 1;
            }
        });
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, ((AncientReforgingTableTile)this.tile).inv, 0, 39, 40, ((AncientReforgingTableTile)this.tile)::isValidRarityMat));
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, ((AncientReforgingTableTile)this.tile).inv, 1, 123, 86, stack -> stack.is(Apoth.Items.SIGIL_OF_REBIRTH)));
        this.addSlot((Slot)new ReforgingResultSlot((IItemHandler)this.choicesInv, 0, 27, 135));
        this.addSlot((Slot)new ReforgingResultSlot((IItemHandler)this.choicesInv, 1, 81, 135));
        this.addSlot((Slot)new ReforgingResultSlot((IItemHandler)this.choicesInv, 2, 135, 135));
        this.addPlayerSlots(inv, 8, 184);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && !LootCategory.forItem((ItemStack)stack).isNone(), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && ((AncientReforgingTableTile)this.tile).isValidRarityMat((ItemStack)stack), 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.is(Apoth.Items.SIGIL_OF_REBIRTH), 2, 3);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
        this.updateSeed();
        this.addDataSlot(DataSlot.shared((int[])this.costs, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.costs, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.costs, (int)2));
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.clearContainer(pPlayer, (IItemHandler)this.itemInv);
    }

    protected void updateSeed() {
        int seed = this.player.getPersistentData().getInt(REFORGE_SEED);
        if (seed == 0) {
            seed = this.player.getRandom().nextInt();
            this.player.getPersistentData().putInt(REFORGE_SEED, seed);
        }
        this.seed = seed;
    }

    public int getMatCount() {
        return this.getSlot(1).getItem().getCount();
    }

    public int getSigilCount() {
        return this.getSlot(2).getItem().getCount();
    }

    @Nullable
    public LootRarity getRarity() {
        ItemStack s = this.getSlot(1).getItem();
        if (s.isEmpty()) {
            return null;
        }
        return RarityRegistry.getMaterialRarity((Item)s.getItem()).getOptional().orElse(null);
    }

    public int getSigilCost(int slot) {
        return this.costs[0] * ++slot;
    }

    public int getMatCost(int slot) {
        return this.costs[1] * ++slot;
    }

    public int getLevelCost(int slot) {
        return this.costs[2] * ++slot;
    }

    public void slotsChanged(Container pContainer) {
        ReforgingRecipe recipe;
        LootRarity rarity = this.getRarity();
        if (rarity != null && (recipe = ((AncientReforgingTableTile)this.tile).getRecipeFor(rarity)) != null) {
            this.costs[0] = recipe.sigilCost();
            this.costs[1] = recipe.matCost();
            this.costs[2] = recipe.levelCost();
        }
        ItemStack input = this.getSlot(0).getItem();
        for (int slot = 0; slot < 3; ++slot) {
            if (!input.isEmpty() && rarity != null) {
                RandomSource rand = this.random;
                rand.setSeed((long)(this.seed ^ BuiltInRegistries.ITEM.getKey((Object)input.getItem()).hashCode() + slot));
                GenContext ctx = GenContext.forPlayer((RandomSource)rand, (Player)this.player);
                ItemStack output = LootController.createLootItem((ItemStack)input.copy(), (LootRarity)rarity, (GenContext)ctx);
                this.choicesInv.setStackInSlot(slot, output);
                continue;
            }
            this.choicesInv.setStackInSlot(slot, ItemStack.EMPTY);
        }
        super.slotsChanged(pContainer);
        ((AncientReforgingTableTile)this.tile).setChanged();
    }

    public class ReforgingResultSlot
    extends SlotItemHandler {
        public ReforgingResultSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player playerIn) {
            ItemStack input = AncientReforgingMenu.this.getSlot(0).getItem();
            LootRarity rarity = AncientReforgingMenu.this.getRarity();
            ReforgingRecipe recipe = ((AncientReforgingTableTile)AncientReforgingMenu.this.tile).getRecipeFor(rarity);
            if (recipe == null || input.isEmpty()) {
                return false;
            }
            int sigils = AncientReforgingMenu.this.getSigilCount();
            int sigilCost = AncientReforgingMenu.this.getSigilCost(this.getSlotIndex());
            int mats = AncientReforgingMenu.this.getMatCount();
            int matCost = AncientReforgingMenu.this.getMatCost(this.getSlotIndex());
            int levels = AncientReforgingMenu.this.player.experienceLevel;
            int levelCost = AncientReforgingMenu.this.getLevelCost(this.getSlotIndex());
            if (!(sigils >= sigilCost && mats >= matCost && levels >= levelCost || AncientReforgingMenu.this.player.isCreative())) {
                return false;
            }
            return super.mayPickup(playerIn);
        }

        public void onTake(Player player, ItemStack stack) {
            if (!player.level().isClientSide) {
                AncientReforgingMenu.this.getSlot(0).set(ItemStack.EMPTY);
                if (!player.isCreative()) {
                    int sigilCost = AncientReforgingMenu.this.getSigilCost(this.getSlotIndex());
                    int matCost = AncientReforgingMenu.this.getMatCost(this.getSlotIndex());
                    int levelCost = AncientReforgingMenu.this.getLevelCost(this.getSlotIndex());
                    AncientReforgingMenu.this.getSlot(1).getItem().shrink(matCost);
                    AncientReforgingMenu.this.getSlot(2).getItem().shrink(sigilCost);
                    EnchantmentUtils.chargeExperience((Player)player, (int)ApothMiscUtil.getExpCostForSlot((int)levelCost, (int)this.getSlotIndex()));
                }
                player.getPersistentData().putInt(AncientReforgingMenu.REFORGE_SEED, player.getRandom().nextInt());
                AncientReforgingMenu.this.updateSeed();
            }
            player.playSound(SoundEvents.EVOKER_CAST_SPELL, 0.99f, player.level().random.nextFloat() * 0.25f + 1.0f);
            player.playSound(SoundEvents.AMETHYST_CLUSTER_STEP, 0.34f, player.level().random.nextFloat() * 0.2f + 0.8f);
            player.playSound(SoundEvents.SMITHING_TABLE_USE, 0.45f, player.level().random.nextFloat() * 0.5f + 0.75f);
        }
    }
}

