/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.ancientreforging.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.data.InvaderProvider;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.mobs.util.BasicBossData;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.ancientreforging.AncientReforging;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class ARInvaderProvider
extends InvaderProvider {
    public static final int DEFAULT_WEIGHT = 100;
    public static final int DEFAULT_QUALITY = 0;

    public ARInvaderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "Ancient Apothic Invaders";
    }

    public void generate() {
        HolderLookup.Provider registries = (HolderLookup.Provider)this.lookupProvider.join();
        HolderLookup.RegistryLookup biomes = (HolderLookup.RegistryLookup)registries.lookup(Registries.BIOME).get();
        LootRarity rare = ARInvaderProvider.rarity((String)"rare");
        LootRarity epic = ARInvaderProvider.rarity((String)"epic");
        LootRarity mythic = ARInvaderProvider.rarity((String)"mythic");
        LootRarity ancient = ARInvaderProvider.ancientRarity("ancient");
        this.addAncientBoss("the_end/enderman", b -> this.ancientMeleeStats((Invader.Builder)b).entity(EntityType.ENDERMAN).size(0.75, 3.7).basicData(c -> ARInvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)100, (float)0.0f)).constraints(Constraints.forDimension((ResourceKey)Level.END)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS})));
        this.addAncientBoss("the_end/shulker", b -> this.ancientRangedStats((Invader.Builder)b).entity(EntityType.SHULKER).size(1.25, 1.25).basicData(c -> ARInvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)20, (float)2.0f)).constraints(Constraints.forDimension((ResourceKey)Level.END)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS})));
        this.addAncientBoss("the_end/evoker", b -> this.ancientRangedStats((Invader.Builder)b).entity(EntityType.EVOKER).size(0.75, 2.45).basicData(c -> ARInvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)150, (float)5.0f)).constraints(Constraints.forDimension((ResourceKey)Level.END)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
    }

    private Invader.Builder ancientMeleeStats(Invader.Builder builder) {
        LootRarity ancient = ARInvaderProvider.ancientRarity("ancient");
        return builder.stats(ancient, c -> c.enchantChance(0.95f).enchLevels(40, 30).effect(1.0f, MobEffects.FIRE_RESISTANCE).modifier(Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 220.0f, 450.0f).modifier(Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f, 0.8f).modifier(Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.8f, 1.5f).modifier(Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.2f)).modifier(Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier(Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)25.0f)).modifier(Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    private Invader.Builder ancientRangedStats(Invader.Builder builder) {
        LootRarity ancient = ARInvaderProvider.ancientRarity("ancient");
        return builder.stats(ancient, c -> c.enchantChance(0.95f).enchLevels(40, 30).effect(1.0f, MobEffects.FIRE_RESISTANCE).modifier(Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 220.0f, 450.0f).modifier(Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f, 0.8f).modifier(ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.9f, 1.8f).modifier(Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.0f)).modifier(Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier(Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)25.0f)).modifier(Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    public static BasicBossData.Builder meleeGear(BasicBossData.Builder builder) {
        builder.gearSets(WorldTier.HAVEN, new String[]{"#haven_melee"});
        builder.gearSets(WorldTier.FRONTIER, new String[]{"#frontier_melee"});
        builder.gearSets(WorldTier.ASCENT, new String[]{"#ascent_melee"});
        builder.gearSets(WorldTier.SUMMIT, new String[]{"#summit_melee"});
        builder.gearSets(WorldTier.PINNACLE, new String[]{"#apotheosis_melee"});
        return builder;
    }

    public static BasicBossData.Builder rangedGear(BasicBossData.Builder builder) {
        builder.gearSets(WorldTier.HAVEN, new String[]{"#haven_ranged"});
        builder.gearSets(WorldTier.FRONTIER, new String[]{"#frontier_ranged"});
        builder.gearSets(WorldTier.ASCENT, new String[]{"#ascent_ranged"});
        builder.gearSets(WorldTier.SUMMIT, new String[]{"#summit_ranged"});
        builder.gearSets(WorldTier.PINNACLE, new String[]{"#apotheosis_ranged"});
        return builder;
    }

    private void addAncientBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.add(AncientReforging.loc(name), (CodecProvider)((Invader.Builder)builder.apply(Invader.builder())).build());
    }

    private static LootRarity ancientRarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(AncientReforging.loc(path))));
    }
}

