/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.item.component.CurrentCrestComponent;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.OrbitalTrailParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ESCrestUtil {
    public static final String TAG_CRESTS = "crests";
    public static final String TAG_OWNED_CRESTS = "owned_crests";

    public static Crest.Set getCrests(Player player) {
        return ESCrestUtil.getCrests(player, TAG_CRESTS);
    }

    public static Crest.Set getOwnedCrests(Player player) {
        return ESCrestUtil.getCrests(player, TAG_OWNED_CRESTS);
    }

    public static Crest.Set getCrests(Player player, String tagId) {
        CompoundTag tag = ESEntityUtil.getPersistentData((Entity)player).getCompound(tagId);
        return ESCrestUtil.getCrests((HolderLookup.Provider)player.registryAccess(), tag);
    }

    public static Crest.Set getCrests(HolderLookup.Provider provider, CompoundTag tag) {
        return Crest.Set.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial().orElse(new Crest.Set(new ArrayList<Crest.Instance>()));
    }

    public static boolean setCrests(Player player, List<Crest.Instance> crests) {
        return ESCrestUtil.setCrests(player, crests, TAG_CRESTS);
    }

    public static boolean setCrests(Player player, List<Crest.Instance> crests, String tagId) {
        Optional<Tag> optionalTag = ESCrestUtil.setCrests((HolderLookup.Provider)player.registryAccess(), crests);
        if (optionalTag.isEmpty()) {
            return false;
        }
        ESEntityUtil.getPersistentData((Entity)player).put(tagId, optionalTag.get());
        return true;
    }

    public static Optional<Tag> setCrests(HolderLookup.Provider provider, List<Crest.Instance> crests) {
        return Crest.Set.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)new Crest.Set(crests)).resultOrPartial();
    }

    public static boolean giveCrest(Player player, Crest.Instance crest) {
        Crest.Set set = ESCrestUtil.getCrests(player, TAG_OWNED_CRESTS);
        ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>(set.crests());
        for (Crest.Instance instance : crests) {
            if (!instance.crest().is(crest.crest()) || instance.level() < crest.level()) continue;
            return false;
        }
        crests.removeIf(c -> c.crest().is(crest.crest()));
        crests.add(crest);
        ESCrestUtil.setCrests(player, crests, TAG_OWNED_CRESTS);
        return true;
    }

    public static boolean upgradeCrest(Player player, ResourceKey<Crest> key) {
        Optional<Crest.Instance> instance = Crest.Instance.of(player.registryAccess(), key, ESCrestUtil.getCrestLevel(player, key) + 1);
        return instance.isPresent() && ESCrestUtil.giveCrest(player, instance.get());
    }

    public static boolean removeCrest(Player player, Holder<Crest> crest) {
        return ESCrestUtil.removeCrest(player, crest, TAG_OWNED_CRESTS) || ESCrestUtil.removeCrest(player, crest, TAG_CRESTS);
    }

    public static boolean removeCrest(Player player, Holder<Crest> crest, String tagId) {
        Crest.Set set = ESCrestUtil.getCrests(player, tagId);
        ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>(set.crests());
        if (crests.stream().noneMatch(c -> c.crest().is(crest))) {
            return false;
        }
        crests.removeIf(c -> c.crest().is(crest));
        ESCrestUtil.setCrests(player, crests, tagId);
        return true;
    }

    public static List<Crest.Instance> mergeCrests(List<Crest.Instance> first, List<Crest.Instance> second) {
        ArrayList<Crest.Instance> result = new ArrayList<Crest.Instance>(first);
        for (Crest.Instance instance : second) {
            boolean hasSame = false;
            int level = instance.level();
            for (int i = 0; i < result.size(); ++i) {
                if (!((Crest.Instance)result.get(i)).crest().is(instance.crest())) continue;
                level = Math.max(level, ((Crest.Instance)result.get(i)).level());
                result.set(i, new Crest.Instance(instance.crest(), level));
                hasSame = true;
            }
            if (hasSame) continue;
            result.add(instance);
        }
        return result;
    }

    public static int getCrestLevel(Player player, ResourceKey<Crest> key) {
        Optional crest = player.registryAccess().registryOrThrow(ESRegistries.CREST).getHolder(key);
        return crest.map(ref -> ESCrestUtil.getCrestLevel(player, (Holder<Crest>)ref)).orElse(0);
    }

    public static int getCrestLevel(Player player, Holder<Crest> crest) {
        Crest.Set set = ESCrestUtil.getCrests(player, TAG_OWNED_CRESTS);
        for (Crest.Instance instance : set.crests()) {
            if (!instance.crest().is(crest)) continue;
            return instance.level();
        }
        return 0;
    }

    public static void tickCrests(Player player) {
        Level level;
        CurrentCrestComponent component;
        Crest.Set ownedSet = ESCrestUtil.getCrests(player, TAG_OWNED_CRESTS);
        Crest.Set set = ESCrestUtil.getCrests(player);
        List<Crest.Instance> ownedCrestInstances = ownedSet.crests();
        List<Crest.Instance> crestInstances = set.crests();
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        if (mainHand.has(ESDataComponents.CURRENT_CREST.get())) {
            component = (CurrentCrestComponent)mainHand.get(ESDataComponents.CURRENT_CREST.get());
            if (component != null && component.crest().isBound() && ownedCrestInstances.stream().noneMatch(c -> c.crest().is(component.crest()))) {
                mainHand.remove(ESDataComponents.CURRENT_CREST.get());
            }
        } else if (offHand.has(ESDataComponents.CURRENT_CREST.get()) && (component = (CurrentCrestComponent)offHand.get(ESDataComponents.CURRENT_CREST.get())) != null && component.crest().isBound() && ownedCrestInstances.stream().noneMatch(c -> c.crest().is(component.crest()))) {
            offHand.remove(ESDataComponents.CURRENT_CREST.get());
        }
        crestInstances.forEach(crest -> {
            if (player.hasInfiniteMaterials()) {
                ESCrestUtil.applyCrestEffects(player, crest);
            } else {
                Inventory inventory = player.getInventory();
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    ItemStack stack = inventory.getItem(i);
                    if (!stack.is(((Crest)crest.crest().value()).type().getCrystalsTag())) continue;
                    ESCrestUtil.applyCrestEffects(player, crest);
                    if (player.tickCount % 60 != 0) break;
                    stack.hurtAndBreak(crest.level(), (LivingEntity)player, EquipmentSlot.MAINHAND);
                    break;
                }
            }
        });
        player.level().registryAccess().registryOrThrow(ESRegistries.CREST).forEach(c -> c.attributeModifiers().ifPresent(modifiers -> modifiers.forEach(modifier -> {
            AttributeInstance instance = player.getAttributes().getInstance(modifier.attribute());
            if (instance != null) {
                instance.getModifiers().forEach(m -> {
                    if (m.id().toString().startsWith(modifier.id().toString()) && crestInstances.stream().noneMatch(c1 -> ((Crest)c1.crest().value()).attributeModifiers().isPresent() && ((Crest)c1.crest().value()).attributeModifiers().get().stream().anyMatch(mod -> mod.getModifierId(c1.level()).equals((Object)m.id())))) {
                        instance.removeModifier(m.id());
                    }
                });
            }
        })));
        if (!crestInstances.isEmpty() && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.tickCount % 100 == 0) {
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(OrbitalTrailParticleOptions.magic(player), player.getX(), player.getY() - 1.0, player.getZ(), 0.0, 0.04, 0.0));
            }
        }
    }

    public static void applyCrestEffects(Player player, Crest.Instance crest) {
        ((Crest)crest.crest().value()).effects().ifPresent(effects -> effects.forEach(mobEffect -> player.addEffect(new MobEffectInstance(mobEffect.effect(), 20, mobEffect.level() + (crest.level() - 1) * mobEffect.levelAddition()))));
        ((Crest)crest.crest().value()).attributeModifiers().ifPresent(modifiers -> modifiers.forEach(modifier -> {
            AttributeInstance instance = player.getAttributes().getInstance(modifier.attribute());
            if (instance != null && !instance.hasModifier(modifier.getModifierId(crest.level()))) {
                instance.addPermanentModifier(modifier.getModifier(crest.level()));
            }
        }));
    }
}

