/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.spell;

import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESGlowParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class GuidanceOfStarsSpell
extends AbstractSpell {
    public GuidanceOfStarsSpell(AbstractSpell.Properties properties) {
        super(properties);
    }

    @Override
    public boolean checkExtraConditions(LivingEntity entity) {
        return entity.level().dimension() == ESDimensions.STARLIGHT_KEY;
    }

    @Override
    public boolean checkExtraConditionsToContinue(LivingEntity entity, int ticks) {
        return entity.level().dimension() == ESDimensions.STARLIGHT_KEY;
    }

    @Override
    public void onPreparationTick(LivingEntity entity, int ticks) {
    }

    @Override
    public void onSpellTick(LivingEntity entity, int ticks) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 4; ++i) {
                serverLevel.sendParticles((ParticleOptions)ESGlowParticleOptions.getSeek(entity.getRandom(), false, false), entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth() * 2.0, entity.getY() + (double)entity.getBbHeight() / 2.0 + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbHeight() * 2.0, entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth() * 2.0, 3, 0.2, 0.2, 0.2, 0.0);
            }
        }
    }

    @Override
    public void onStart(LivingEntity entity) {
    }

    @Override
    public void onStop(LivingEntity entity, int ticks) {
        TagKey<Structure> key;
        ServerLevel serverLevel;
        BlockPos blockPos;
        Level level;
        if (ticks >= this.spellProperties().spellTicks() && (level = entity.level()) instanceof ServerLevel && (blockPos = (serverLevel = (ServerLevel)level).findNearestMapStructure(key = ESTags.Structures.BOSS_STRUCTURES, entity.blockPosition(), 100, false)) != null) {
            Vec3 startPos = entity.getEyePosition();
            Vec3 endPos = startPos.add(blockPos.getCenter().subtract(startPos).normalize().scale(5.0));
            BlockHitResult result = entity.level().clip(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.of((Entity)entity)));
            if (result.getType() != HitResult.Type.MISS) {
                endPos = result.getLocation();
            }
            for (int i = 0; i < 18; ++i) {
                Vec3 delta = endPos.offsetRandom(entity.getRandom(), 0.5f).subtract(startPos).normalize().scale(0.5);
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ESGlowParticleOptions.getSeek(entity.getRandom(), true, true), startPos.x + ((double)entity.getRandom().nextFloat() - 0.5) * 0.8, startPos.y + ((double)entity.getRandom().nextFloat() - 0.5) * 0.8, startPos.z + ((double)entity.getRandom().nextFloat() - 0.5) * 0.8, delta.x, delta.y, delta.z));
            }
            serverLevel.playSound(null, entity.getX(), entity.getY(), entity.getZ(), ESSoundEvents.SEEKING_EYE_LAUNCH.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (serverLevel.getRandom().nextFloat() * 0.4f + 0.8f));
        }
    }
}

