/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.entity.interfaces.StarlightWitch;
import cn.leolezury.eternalstarlight.common.network.UpdateSpellDataPacket;
import cn.leolezury.eternalstarlight.common.network.UpdateWitchTypePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public abstract class ServerEntityMixin {
    @Shadow
    @Final
    private Entity entity;

    @Inject(method={"addPairing(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="TAIL")})
    private void startSeenByPlayer(ServerPlayer serverPlayer, CallbackInfo ci) {
        Entity entity = this.entity;
        if (entity instanceof SpellCaster) {
            SpellCaster caster = (SpellCaster)entity;
            if (!this.entity.level().isClientSide) {
                ESPlatform.INSTANCE.sendToClient(serverPlayer, new UpdateSpellDataPacket(this.entity.getId(), caster.getESSpellData()));
            }
        }
        if ((entity = this.entity) instanceof StarlightWitch) {
            StarlightWitch witch = (StarlightWitch)entity;
            if (!this.entity.level().isClientSide) {
                ESPlatform.INSTANCE.sendToClient(serverPlayer, new UpdateWitchTypePacket(this.entity.getId(), witch.getWitchType()));
            }
        }
    }
}

