/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.entity.interfaces.Grappling;
import cn.leolezury.eternalstarlight.common.entity.interfaces.GrapplingOwner;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.handler.CommonHandlers;
import cn.leolezury.eternalstarlight.common.network.UpdateSpellDataPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import cn.leolezury.eternalstarlight.common.spell.SpellCooldown;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements SpellCaster,
GrapplingOwner {
    @Unique
    private SpellCastData spellCastData = SpellCastData.getDefault();
    @Unique
    private SpellCastData.SpellSource spellSource = e -> false;
    @Unique
    private ArrayList<SpellCooldown> spellCooldowns = new ArrayList();
    @Unique
    private Entity grappling;
    @Unique
    private boolean originalEnoughAttackStrength;

    @Shadow
    @NotNull
    public abstract ItemStack getWeaponItem();

    @Inject(method={"hurtCurrentlyUsedShield(F)V"}, at={@At(value="HEAD")})
    private void damageShield(float amount, CallbackInfo callBackInfo) {
        Player player = (Player)this;
        ItemStack useItem = player.getUseItem();
        if (useItem.is(ESTags.Items.GREATSWORDS)) {
            useItem.hurtAndBreak(Math.max((int)(amount / 5.0f), 1), (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            player.stopUsingItem();
            player.getCooldowns().addCooldown(useItem.getItem(), 100);
        }
    }

    @Inject(method={"disableShield()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableShield(CallbackInfo ci) {
        Player player = (Player)this;
        ItemStack useItem = player.getUseItem();
        if (useItem.is(ESTags.Items.GREATSWORDS)) {
            ci.cancel();
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtEnemy(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/player/Player;)Z")})
    private void attackHurtEnemy(Entity entity, CallbackInfo ci) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            CommonHandlers.handleFlowglazeWeaponAttack((LivingEntity)((Player)this), living);
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSprinting()Z", ordinal=0)})
    private void attackCheckHammerStrength(Entity entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.getWeaponItem().is(ESTags.Items.HAMMERS)) {
            localRef.set(true);
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;walkDist:F", opcode=180)})
    private void attackBeforeScytheSweepCheck(Entity entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.getWeaponItem().is(ESTags.Items.SCYTHES)) {
            this.originalEnoughAttackStrength = localRef.get();
            localRef.set(true);
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;")})
    private void attackAfterScytheSweepCheck(Entity entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.getWeaponItem().is(ESTags.Items.SCYTHES)) {
            localRef.set(this.originalEnoughAttackStrength);
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="TAIL")})
    private void aiStep(CallbackInfo ci) {
        Grappling grappling1;
        Entity entity;
        Player player = (Player)this;
        if (this.grappling != null && (entity = this.grappling) instanceof Grappling && (grappling1 = (Grappling)entity).reachedTarget() && grappling1.shouldPull()) {
            player.resetFallDistance();
            if (!player.level().isClientSide) {
                float length = grappling1.length();
                double d = this.grappling.position().subtract(player.getEyePosition()).length();
                if (d > (double)length) {
                    double e = d / (double)length * 0.1;
                    boolean crouch = player.isCrouching();
                    player.addDeltaMovement(this.grappling.position().subtract(player.getEyePosition()).scale(1.0 / d).multiply(e, e * 1.1, e).scale(crouch ? 0.6 : (player.onGround() ? 1.8 : 1.0)));
                    player.hurtMarked = true;
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        Player player = (Player)this;
        Optional cooldowns = SpellCooldown.LIST_CODEC.encodeStart((DynamicOps)player.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.spellCooldowns).resultOrPartial();
        cooldowns.ifPresent(tag -> compoundTag.put("eternal_starlight:spell_cooldowns", tag));
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        Player player = (Player)this;
        Tag tag = compoundTag.get("eternal_starlight:spell_cooldowns");
        if (tag != null) {
            this.spellCooldowns = SpellCooldown.LIST_CODEC.parse((DynamicOps)player.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial().orElse(new ArrayList());
        }
    }

    @Override
    public SpellCastData getESSpellData() {
        return this.spellCastData;
    }

    @Override
    public void setESSpellData(SpellCastData data) {
        Level level;
        Player player = (Player)this;
        if (!player.level().isClientSide && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.spellCastData.spell() != data.spell() || this.spellCastData.hasSpell() != data.hasSpell() || this.spellCastData.strength() != data.strength()) {
                ESPlatform.INSTANCE.sendToTrackingClients(serverLevel, (Entity)player, new UpdateSpellDataPacket(player.getId(), data));
            }
        }
        this.spellCastData = data;
    }

    @Override
    public SpellCastData.SpellSource getESSpellSource() {
        return this.spellSource;
    }

    @Override
    public void setESSpellSource(SpellCastData.SpellSource spellSource) {
        this.spellSource = spellSource;
    }

    @Override
    public Entity getESGrappling() {
        return this.grappling;
    }

    @Override
    public void setESGrappling(Entity grappling) {
        this.grappling = grappling;
    }

    @Override
    public ArrayList<SpellCooldown> getESSpellCooldowns() {
        return this.spellCooldowns;
    }

    @Override
    public void setESSpellCooldowns(ArrayList<SpellCooldown> cooldowns) {
        this.spellCooldowns = cooldowns;
    }

    @Override
    public void addESSpellCooldown(AbstractSpell spell, int cooldown) {
        if (this.spellCooldowns.stream().noneMatch(c -> c.getSpell() == spell)) {
            this.spellCooldowns.add(new SpellCooldown(spell, cooldown));
        } else {
            this.spellCooldowns.stream().filter(c -> c.getSpell() == spell).findFirst().ifPresent(c -> c.setCooldown(cooldown));
        }
    }
}

