/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.magic;

import cn.leolezury.eternalstarlight.common.block.ESPortalBlock;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.item.component.CurrentCrestComponent;
import cn.leolezury.eternalstarlight.common.network.OpenCrestGuiPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class OrbOfProphecyItem
extends Item {
    public OrbOfProphecyItem(Item.Properties properties) {
        super(properties);
    }

    public static void recordCrests(RegistryAccess access, ItemStack stack, CompoundTag tag) {
        Tag tag2;
        List<Crest.Instance> itemCrests;
        List<Crest.Instance> crests = ESCrestUtil.getCrests((HolderLookup.Provider)access, tag).crests();
        Optional<Tag> crestsTag = ESCrestUtil.setCrests((HolderLookup.Provider)access, ESCrestUtil.mergeCrests(crests, itemCrests = ESCrestUtil.getCrests((HolderLookup.Provider)access, ((CustomData)stack.getComponents().getOrDefault(ESDataComponents.CRESTS.get(), (Object)CustomData.EMPTY)).copyTag()).crests()));
        if (crestsTag.isPresent() && (tag2 = crestsTag.get()) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag2;
            stack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.CRESTS.get(), (Object)CustomData.of((CompoundTag)compoundTag)).build());
        }
    }

    public static boolean hasCrests(RegistryAccess access, ItemStack stack) {
        return !OrbOfProphecyItem.getCrests(access, stack).isEmpty();
    }

    public static List<Crest.Instance> getCrests(RegistryAccess access, ItemStack stack) {
        return ESCrestUtil.getCrests((HolderLookup.Provider)access, ((CustomData)stack.getComponents().getOrDefault(ESDataComponents.CRESTS.get(), (Object)CustomData.EMPTY)).copyTag()).crests();
    }

    public static void setTemporary(ItemStack stack) {
        stack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.ORB_OF_PROPHECY_TEMPORARY.get(), (Object)true).build());
    }

    public static boolean isTemporary(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ESDataComponents.ORB_OF_PROPHECY_TEMPORARY.get(), (Object)false);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack itemStack, int i) {
        if (livingEntity.getPose() != Pose.STANDING) {
            livingEntity.stopUsingItem();
        }
        if (!level.isClientSide && !itemStack.has(ESDataComponents.CURRENT_CREST.get()) && livingEntity.getTicksUsingItem() >= 140 && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ESPlatform.INSTANCE.sendToClient(player, new OpenCrestGuiPacket(ESCrestUtil.getCrests((Player)player), ESCrestUtil.getOwnedCrests((Player)player)));
            player.stopUsingItem();
            player.getCooldowns().addCooldown((Item)this, 20);
        }
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (player.getPose() == Pose.STANDING) {
            if (OrbOfProphecyItem.hasCrests(level.registryAccess(), itemStack)) {
                int xpCost;
                int n = xpCost = OrbOfProphecyItem.isTemporary(itemStack) ? 2 : 1;
                if (player.experienceLevel >= xpCost) {
                    player.experienceLevel -= xpCost;
                    OrbOfProphecyItem.getCrests(level.registryAccess(), itemStack).forEach(crest -> ESCrestUtil.giveCrest(player, crest));
                    itemStack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.CRESTS.get(), (Object)CustomData.EMPTY).build());
                    if (OrbOfProphecyItem.isTemporary(itemStack)) {
                        itemStack.consume(1, (LivingEntity)player);
                    }
                    return InteractionResultHolder.success((Object)itemStack);
                }
            } else {
                Crest crest2;
                CurrentCrestComponent component;
                SpellCaster caster;
                if (!itemStack.has(ESDataComponents.CURRENT_CREST.get())) {
                    player.startUsingItem(interactionHand);
                    return InteractionResultHolder.consume((Object)itemStack);
                }
                if (!level.isClientSide && player instanceof SpellCaster && !(caster = (SpellCaster)player).getESSpellData().hasSpell() && (component = (CurrentCrestComponent)itemStack.get(ESDataComponents.CURRENT_CREST.get())) != null && component.crest().isBound() && (crest2 = (Crest)component.crest().value()).getSpell().isPresent() && crest2.getSpell().get().canCast((LivingEntity)player, true)) {
                    crest2.getSpell().get().start((LivingEntity)player, ESCrestUtil.getCrestLevel(player, component.crest()), true);
                    caster.setESSpellSource(new SpellCastData.ItemSpellSource(this, interactionHand));
                    return InteractionResultHolder.consume((Object)itemStack);
                }
            }
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        Player player = useOnContext.getPlayer();
        BlockPos pos = useOnContext.getClickedPos();
        if (level.getBlockState(pos).is(ESTags.Blocks.PORTAL_FRAME_BLOCKS) && (level.dimension() == ESDimensions.STARLIGHT_KEY || level.dimension() == Level.OVERWORLD) && ESPortalBlock.validateAndPlacePortal((LevelAccessor)level, pos)) {
            level.playSound(player, pos, SoundEvents.PORTAL_TRIGGER, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

