/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.attack.AttackEffect;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LunarThorn
extends AttackEffect {
    public float oldClientScale = 0.0f;
    public float clientScale = 0.0f;

    public LunarThorn(EntityType<? extends LunarThorn> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean shouldContinueToTick() {
        return true;
    }

    public void setDeltaMovement(Vec3 vec3) {
        super.setDeltaMovement(Vec3.ZERO);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getSpawnedTicks() >= 200) {
                this.discard();
            }
            if (this.getSpawnedTicks() > 40 && this.getOwner() != null) {
                if (this.getAttackMode() == 0) {
                    for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.5))) {
                        if (livingEntity == this.getOwner()) continue;
                        livingEntity.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.POISON, this, (Entity)this.getOwner()), this.getOwner() instanceof LunarMonstrosity ? 4.0f * (float)ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale() : 4.0f);
                    }
                }
                if (this.getAttackMode() == 1) {
                    for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.5))) {
                        if (livingEntity == this.getOwner()) continue;
                        if (!livingEntity.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                            livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10));
                        }
                        livingEntity.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.POISON, this, (Entity)this.getOwner()), this.getOwner() instanceof LunarMonstrosity ? 3.0f * (float)ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale() : 3.0f);
                    }
                }
            }
        } else {
            float scale;
            float f = scale = this.getSpawnedTicks() <= 40 ? (float)this.getSpawnedTicks() / 40.0f : 1.0f;
            if (this.getSpawnedTicks() >= 160) {
                scale = (float)(200 - this.getSpawnedTicks()) / 40.0f;
            }
            this.oldClientScale = this.clientScale;
            this.clientScale = scale;
            if (this.random.nextInt(20) == 0) {
                this.level().addParticle((ParticleOptions)ESSmokeParticleOptions.LUNAR_SHORT, this.getRandomX(1.5), this.getRandomY(), this.getRandomZ(1.5), 0.0, 0.0, 0.0);
            }
        }
    }
}

