/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.blockentity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.entity.StellarRackBlockEntity;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class StellarRackRenderer<T extends StellarRackBlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType STAR = ESRenderType.entityTranslucentGlow(EternalStarlight.id("textures/entity/stellar_rack_shine.png"));

    public StellarRackRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T rack, float f, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        VertexConsumer vertexConsumer = ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(STAR);
        stack.pushPose();
        stack.translate(0.5f, 0.9f, 0.5f);
        stack.pushPose();
        stack.mulPose(new Quaternionf((Quaternionfc)Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation()).rotateZ(((StellarRackBlockEntity)((Object)rack)).getStarRotation(f)));
        PoseStack.Pose pose = stack.last();
        float size = (float)(1.2 + Math.sin((double)((float)((StellarRackBlockEntity)((Object)rack)).getTickCount() + f) * 0.1 * Math.PI) * 0.4);
        vertexConsumer.addVertex(pose, -size, -size, 0.0f).setColor(((StellarRackBlockEntity)((Object)rack)).getColor(f)).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, -size, size, 0.0f).setColor(((StellarRackBlockEntity)((Object)rack)).getColor(f)).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, size, size, 0.0f).setColor(((StellarRackBlockEntity)((Object)rack)).getColor(f)).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, size, -size, 0.0f).setColor(((StellarRackBlockEntity)((Object)rack)).getColor(f)).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        stack.popPose();
        stack.translate(0.01f, 0.01f, 0.01f);
        stack.pushPose();
        stack.mulPose(new Quaternionf((Quaternionfc)Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation()).rotateZ(-((StellarRackBlockEntity)((Object)rack)).getStarRotation(f) / 2.0f));
        pose = stack.last();
        size = (float)(0.9 + Math.sin((double)((float)((StellarRackBlockEntity)((Object)rack)).getTickCount() + f) * 1.2 * Math.PI) * 0.2);
        vertexConsumer.addVertex(pose, -size, -size, 0.0f).setColor(((StellarRackBlockEntity)((Object)rack)).getColor(100.0f + f)).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, -size, size, 0.0f).setColor(((StellarRackBlockEntity)((Object)rack)).getColor(100.0f + f)).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, size, size, 0.0f).setColor(((StellarRackBlockEntity)((Object)rack)).getColor(100.0f + f)).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(pose, size, -size, 0.0f).setColor(((StellarRackBlockEntity)((Object)rack)).getColor(100.0f + f)).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        stack.popPose();
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        float angle = 360.0f / (float)((StellarRackBlockEntity)((Object)rack)).getItems().stream().filter(i -> !i.isEmpty()).count();
        float accumulatedAngle = ((StellarRackBlockEntity)((Object)rack)).getStarRotation(f) * 0.4f * 57.295776f;
        for (ItemStack itemStack : ((StellarRackBlockEntity)((Object)rack)).getItems()) {
            if (itemStack.isEmpty()) continue;
            stack.pushPose();
            Vec3 pos = ESMathUtil.rotationToPosition(0.9f, 0.0f, accumulatedAngle += angle);
            stack.translate(pos.x, 0.0, pos.z);
            stack.mulPose(new Quaternionf().rotateY(((StellarRackBlockEntity)((Object)rack)).getStarRotation(f) * 0.6f));
            renderer.render(itemStack, ItemDisplayContext.GROUND, false, stack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, renderer.getModel(itemStack, rack.getLevel(), null, 0));
            stack.popPose();
        }
        stack.popPose();
    }
}

