/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.environment;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FireflyParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private int ticksSinceMotionChange;

    protected FireflyParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.quadSize = 0.1f + this.random.nextFloat() * 0.1f;
        this.lifetime = 50 + this.random.nextInt(21);
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(spriteSet);
        this.setSpeed();
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.spriteSet);
        ++this.ticksSinceMotionChange;
        if (this.ticksSinceMotionChange > 40) {
            this.setSpeed();
            this.ticksSinceMotionChange = 0;
        }
    }

    private void setSpeed() {
        Vec3 movement = new Vec3((double)((this.random.nextBoolean() ? 1 : -1) * this.random.nextInt(1, 10)), (double)((this.random.nextBoolean() ? 1 : -1) * this.random.nextInt(1, 10)), (double)((this.random.nextBoolean() ? 1 : -1) * this.random.nextInt(1, 10))).normalize().scale(0.03);
        this.xd = movement.x;
        this.yd = movement.y;
        this.zd = movement.z;
    }

    public void move(double xd, double yd, double zd) {
        this.setBoundingBox(this.getBoundingBox().move(xd, yd, zd));
        this.setLocationFromBoundingbox();
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        super.render(vertexConsumer, camera, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float partialTicks) {
        float g = ((float)this.age + partialTicks) / (float)this.lifetime;
        g = Mth.clamp((float)g, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTicks);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(g * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel clientLevel, double x, double y, double z, double xs, double ys, double zs) {
            return new FireflyParticle(clientLevel, x, y, z, this.sprites);
        }
    }
}

