/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Stranghoul;
import cn.leolezury.eternalstarlight.common.item.combat.SeedsLauncherItem;
import cn.leolezury.eternalstarlight.common.item.combat.SpearItem;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StranghoulModel<T extends Stranghoul>
extends HumanoidModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("stranghoul"), "main");
    public static final ModelLayerLocation INNER_ARMOR_LOCATION = new ModelLayerLocation(EternalStarlight.id("stranghoul"), "inner_armor");
    public static final ModelLayerLocation OUTER_ARMOR_LOCATION = new ModelLayerLocation(EternalStarlight.id("stranghoul"), "outer_armor");

    public StranghoulModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.5f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -32.0f, -4.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(12, 28).addBox(-3.0f, 8.0f, -1.5f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 16).addBox(-4.0f, 0.0f, -2.5f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(36, 20).mirror().addBox(-2.0f, -2.0f, -2.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(36, 20).addBox(-1.0f, -2.0f, -2.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(-1.3f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.6f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 20).addBox(-1.7f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.6f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.getItem() instanceof SpearItem && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            }
        }
        if ((stack.getItem() instanceof SeedsLauncherItem || stack.is(Items.BOW)) && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.isAggressive() && entity.getWeaponItem().isEmpty()) {
            AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.attackTime, (float)ageInTicks);
        }
        if (((Stranghoul)((Object)entity)).isEating()) {
            boolean inverted = entity.getMainArm() == HumanoidArm.RIGHT;
            ModelPart eatingArm = this.getArm(entity.getMainArm().getOpposite());
            eatingArm.xRot = (Mth.sin((float)(ageInTicks * 1.5f)) + 1.0f) * 0.5f * (float)Math.PI * 0.12f - 1.5707964f;
            eatingArm.yRot = inverted ? 0.4f : -0.4f;
            eatingArm.zRot = 0.0f;
        }
        if (((Stranghoul)((Object)entity)).isBartering()) {
            this.head.xRot = 0.5f;
            this.head.yRot = 0.0f;
            if (entity.isLeftHanded()) {
                this.rightArm.yRot = -0.5f;
                this.rightArm.xRot = -0.9f;
            } else {
                this.leftArm.yRot = 0.5f;
                this.leftArm.xRot = -0.9f;
            }
        }
    }
}

