/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.ShadowSnailAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.ShadowSnail;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShadowSnailModel<T extends ShadowSnail>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("shadow_snail"), "main");
    private final ModelPart root;

    public ShadowSnailModel(ModelPart root) {
        this.root = root.getChild("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, -8.0f, -2.0f, 4.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(22, 7).addBox(-2.0f, -4.0f, -3.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -3.0125f, -4.0f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        body.addOrReplaceChild("left_feeler", CubeListBuilder.create().texOffs(1, 12).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-3.0125f, (float)-4.0f));
        body.addOrReplaceChild("right_feeler", CubeListBuilder.create().texOffs(1, 12).mirror().addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)-3.0125f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(ShadowSnailAnimation.WALK, limbSwing, limbSwingAmount, 3.0f, 1.25f);
        this.root.xRot = 0.0f;
        if (this.young) {
            this.root.xScale = 0.5f;
            this.root.yScale = 0.5f;
            this.root.zScale = 0.5f;
        }
        switch (((ShadowSnail)((Object)entity)).getHideState()) {
            case 1: {
                this.animate(((ShadowSnail)((Object)entity)).hideStartAnimationState, ShadowSnailAnimation.HIDE_START, ageInTicks);
                break;
            }
            case 2: {
                this.animate(((ShadowSnail)((Object)entity)).hideAnimationState, ShadowSnailAnimation.HIDE, ageInTicks);
                break;
            }
            case 3: {
                this.animate(((ShadowSnail)((Object)entity)).hideEndAnimationState, ShadowSnailAnimation.HIDE_END, ageInTicks);
            }
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

