/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.EntityBackpackAdditionHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModPayloads;
import net.p3pp3rf1y.sophisticatedbackpacks.network.AnotherPlayerBackpackOpenPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsPayload;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.infinity.InfinityUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class CommonEventHandler {
    private static final int BACKPACK_CHECK_COOLDOWN = 40;
    private final Map<ResourceLocation, Long> nextBackpackCheckTime = new HashMap<ResourceLocation, Long>();

    public void registerHandlers(IEventBus modBus) {
        ModItems.registerHandlers(modBus);
        ModBlocks.registerHandlers(modBus);
        modBus.addListener(ModPayloads::registerPayloads);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(this::onItemPickup);
        eventBus.addListener(this::onLivingSpecialSpawn);
        eventBus.addListener(this::onLivingDrops);
        eventBus.addListener(this::onEntityMobGriefing);
        eventBus.addListener(this::onEntityLeaveWorld);
        eventBus.addListener(this::onBlockClick);
        eventBus.addListener(this::onAttackEntity);
        eventBus.addListener(EntityBackpackAdditionHandler::onLivingUpdate);
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onPlayerRespawn);
        eventBus.addListener(this::onWorldTick);
        eventBus.addListener(this::interactWithEntity);
        eventBus.addListener(this::handleBreakBackpackWithInfinityUpgrade);
    }

    private void interactWithEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        boolean isPointingAtBack;
        Player targetPlayer;
        block6: {
            block5: {
                Entity entity = event.getTarget();
                if (!(entity instanceof Player)) break block5;
                targetPlayer = (Player)entity;
                if (!Boolean.FALSE.equals(Config.SERVER.allowOpeningOtherPlayerBackpacks.get())) break block6;
            }
            return;
        }
        Player sourcePlayer = event.getEntity();
        Vec3 targetPlayerViewVector = Vec3.directionFromRotation((Vec2)new Vec2(targetPlayer.getXRot(), targetPlayer.yBodyRot));
        Vec3 hitVector = event.getLocalPos();
        Vec3 vec31 = sourcePlayer.position().vectorTo(targetPlayer.position()).normalize();
        vec31 = new Vec3(vec31.x, 0.0, vec31.z);
        boolean isPointingAtBody = hitVector.y >= 0.9 && hitVector.y < 1.6;
        boolean bl = isPointingAtBack = vec31.dot(targetPlayerViewVector) > 0.0;
        if (!isPointingAtBody || !isPointingAtBack) {
            return;
        }
        if (targetPlayer.level().isClientSide) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            PacketDistributor.sendToServer((CustomPacketPayload)new AnotherPlayerBackpackOpenPayload(targetPlayer.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onWorldTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ResourceLocation dimensionKey = event.getLevel().dimension().location();
        boolean runSlownessLogic = Boolean.TRUE.equals(Config.SERVER.nerfsConfig.tooManyBackpacksSlowness.get());
        boolean runDedupeLogic = Boolean.FALSE.equals(Config.SERVER.tickDedupeLogicDisabled.get());
        if (!runSlownessLogic && !runDedupeLogic || this.nextBackpackCheckTime.getOrDefault(dimensionKey, 0L) > event.getLevel().getGameTime()) {
            return;
        }
        this.nextBackpackCheckTime.put(dimensionKey, event.getLevel().getGameTime() + 40L);
        HashSet backpackIds = new HashSet();
        event.getLevel().players().forEach(player -> {
            AtomicInteger numberOfBackpacks = new AtomicInteger(0);
            PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, handlerName, identifier, slot) -> {
                if (runSlownessLogic) {
                    numberOfBackpacks.incrementAndGet();
                }
                if (runDedupeLogic) {
                    CommonEventHandler.addBackpackIdIfUniqueOrDedupe(backpackIds, BackpackWrapper.fromStack(backpack));
                }
                return false;
            });
            if (runSlownessLogic) {
                int maxNumberOfBackpacks = (Integer)Config.SERVER.nerfsConfig.maxNumberOfBackpacks.get();
                if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                    int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * (Double)Config.SERVER.nerfsConfig.slownessLevelsPerAdditionalBackpack.get()));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, numberOfSlownessLevels - 1, false, false));
                }
            }
        });
    }

    private static void addBackpackIdIfUniqueOrDedupe(Set<UUID> backpackIds, IBackpackWrapper backpackWrapper) {
        backpackWrapper.getContentsUuid().ifPresent(backpackId -> {
            if (backpackIds.contains(backpackId)) {
                backpackWrapper.removeContentsUUIDTag();
                backpackWrapper.onContentsNbtUpdated();
            } else {
                backpackIds.add((UUID)backpackId);
            }
        });
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void sendPlayerSettingsToClient(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String playerTagName = "sophisticatedBackpackSettings";
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPlayerSettingsPayload(playerTagName, SettingsManager.getPlayerSettingsTag((Player)player, (String)playerTagName)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> {
            IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
            for (IBlockClickResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IBlockClickResponseUpgrade.class)) {
                if (!upgrade.onBlockClick(player, pos)) continue;
                return true;
            }
            return false;
        });
    }

    private void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> {
            IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
            for (IAttackEntityResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IAttackEntityResponseUpgrade.class)) {
                if (!upgrade.onAttackEntity(player)) continue;
                return true;
            }
            return false;
        });
    }

    private void onLivingSpecialSpawn(FinalizeSpawnEvent event) {
        Monster monster;
        Mob entity = event.getEntity();
        if (entity instanceof Monster && (monster = (Monster)entity).getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            EntityBackpackAdditionHandler.addBackpack(monster, (LevelAccessor)event.getLevel());
        }
    }

    private void onLivingDrops(LivingDropsEvent event) {
        EntityBackpackAdditionHandler.handleBackpackDrop(event);
    }

    private void onEntityMobGriefing(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            EntityBackpackAdditionHandler.removeBeneficialEffects(creeper);
        }
    }

    private void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        EntityBackpackAdditionHandler.removeBackpackUuid((Monster)event.getEntity(), event.getLevel());
    }

    private void onItemPickup(ItemEntityPickupEvent.Pre event) {
        ItemEntity itemEntity = event.getItemEntity();
        if (itemEntity.getItem().isEmpty() || itemEntity.pickupDelay > 0) {
            return;
        }
        AtomicReference<ItemStack> remainingStackSimulated = new AtomicReference<ItemStack>(itemEntity.getItem().copy());
        Player player = event.getPlayer();
        Level level = player.getCommandSenderWorld();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> {
            IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
            remainingStackSimulated.set(InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (UpgradeHandler)wrapper.getUpgradeHandler(), (ItemStack)((ItemStack)remainingStackSimulated.get()), (boolean)true));
            return ((ItemStack)remainingStackSimulated.get()).isEmpty();
        }, (Boolean)Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get());
        if (remainingStackSimulated.get().getCount() != itemEntity.getItem().getCount()) {
            AtomicReference<ItemStack> remainingStack = new AtomicReference<ItemStack>(itemEntity.getItem().copy());
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> {
                IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
                remainingStack.set(InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (Player)player, (UpgradeHandler)wrapper.getUpgradeHandler(), (ItemStack)((ItemStack)remainingStack.get()), (boolean)false));
                return ((ItemStack)remainingStack.get()).isEmpty();
            }, (Boolean)Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get());
            itemEntity.setItem(remainingStack.get());
            event.setCanPickup(TriState.FALSE);
        }
    }

    private void handleBreakBackpackWithInfinityUpgrade(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(event.getState().getBlock() instanceof BackpackBlock)) {
            return;
        }
        if (WorldHelper.getBlockEntity((BlockGetter)event.getLevel(), (BlockPos)event.getPos(), BackpackBlockEntity.class).map(backpackBlockEntity -> backpackBlockEntity.getStorageWrapper().getUpgradeHandler().getTypeWrappers(InfinityUpgradeItem.TYPE).stream().anyMatch(w -> !player.hasPermissions(w.getPermissionLevel()))).orElse(false).booleanValue()) {
            event.setCanceled(true);
            player.displayClientMessage((Component)SBPTranslationHelper.INSTANCE.translStatusMessage("infinity_upgrade_only_admin_break", new Object[0]).withStyle(ChatFormatting.RED), true);
        }
    }
}

