/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.AccessLogRecord;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackPlayerArgumentType;

public class ListCommand {
    private ListCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"list").executes(context -> ListCommand.printBackpackList(new ArrayList<AccessLogRecord>(BackpackAccessLogger.getAllBackpackLogs()), (CommandSourceStack)context.getSource()))).then(Commands.argument((String)"playerName", (ArgumentType)BackpackPlayerArgumentType.playerName()).executes(context -> ListCommand.printBackpackList(new ArrayList<AccessLogRecord>(BackpackAccessLogger.getBackpackLogsForPlayer((String)context.getArgument("playerName", String.class))), (CommandSourceStack)context.getSource())));
    }

    private static int printBackpackList(List<AccessLogRecord> allLogs, CommandSourceStack source) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        allLogs.sort(Comparator.comparing(AccessLogRecord::getAccessTime).reversed());
        source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.list.header"), false);
        allLogs.forEach(alr -> {
            MutableComponent message = Component.literal((String)"");
            message.append((Component)Component.literal((String)alr.getBackpackName()).withStyle(s -> s.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sophisticatedbackpacks give @p " + String.valueOf(alr.getBackpackUuid()))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.sophisticatedbackpacks.backpack_uuid.tooltip", (Object[])new Object[]{alr.getBackpackUuid().toString()})))));
            message.append((Component)Component.literal((String)", "));
            MutableComponent clothColor = Component.translatable((String)"commands.sophisticatedbackpacks.list.cloth_color");
            clothColor.withStyle(clothColor.getStyle().withColor(TextColor.fromRgb((int)alr.getClothColor())));
            message.append((Component)clothColor);
            message.append((Component)Component.literal((String)" "));
            MutableComponent trimColor = Component.translatable((String)"commands.sophisticatedbackpacks.list.trim_color");
            trimColor.withStyle(trimColor.getStyle().withColor(TextColor.fromRgb((int)alr.getTrimColor())));
            message.append((Component)trimColor);
            message.append((Component)Component.literal((String)", "));
            message.append((Component)Component.literal((String)alr.getPlayerName()));
            message.append((Component)Component.literal((String)", "));
            message.append((Component)Component.literal((String)dateFormat.format(new Date(alr.getAccessTime()))));
            source.sendSuccess(() -> message, false);
        });
        return 0;
    }
}

