/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.viewer;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.api.unification.UnificationSettings;
import com.almostreliable.unified.utils.Utils;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public final class ItemHider {
    public static final TagKey<Item> HIDE_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Utils.getRL("hide"));
    public static final TagKey<Item> EMI_STRICT_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Utils.getRL("emi_strict"));

    private ItemHider() {
    }

    public static void applyHideTags(VanillaTagWrapper<Item> tags, Collection<UnificationSettings> handlers, boolean emiHidingStrict) {
        for (UnificationSettings handler : handlers) {
            if (!handler.shouldHideVariantItems()) continue;
            ItemHider.applyHideTags(tags, handler);
        }
        if (emiHidingStrict) {
            tags.add(EMI_STRICT_TAG.location(), (Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.DEBUG_STICK));
        }
    }

    public static void applyHideTags(VanillaTagWrapper<Item> tags, UnificationSettings handler) {
        Set<Holder<Item>> holdersToHide = ItemHider.createHidingItems(handler);
        for (Holder<Item> holder : holdersToHide) {
            tags.add(HIDE_TAG.location(), holder);
        }
    }

    public static Set<Holder<Item>> createHidingItems(UnificationSettings handler) {
        HashSet<Holder<Item>> hidings = new HashSet<Holder<Item>>();
        for (TagKey<Item> tag : handler.getTags()) {
            Collection<UnificationEntry<Item>> entriesByTag = handler.getTagEntries(tag);
            if (Utils.allSameNamespace(entriesByTag)) continue;
            HashSet<UnificationEntry<Item>> replacements = new HashSet<UnificationEntry<Item>>();
            for (UnificationEntry<Item> holder : entriesByTag) {
                replacements.add(ItemHider.getReplacementForItem(handler, holder));
            }
            HashSet<Holder.Reference<Item>> toHide = new HashSet<Holder.Reference<Item>>();
            HashSet<String> toHideIds = new HashSet<String>();
            for (UnificationEntry<Item> entry : entriesByTag) {
                if (replacements.contains(entry)) continue;
                toHide.add(entry.asHolderOrThrow());
                toHideIds.add(entry.id().toString());
            }
            if (toHide.isEmpty()) continue;
            AlmostUnifiedCommon.LOGGER.info("[AutoHiding] Hiding {}/{} items for tag '#{}' -> {}", (Object)toHide.size(), (Object)entriesByTag.size(), (Object)tag.location(), toHideIds);
            hidings.addAll(toHide);
        }
        return hidings;
    }

    private static UnificationEntry<Item> getReplacementForItem(UnificationLookup repMap, UnificationEntry<Item> entry) {
        UnificationEntry<Item> replacement = repMap.getVariantItemTarget(entry);
        if (replacement == null) {
            return entry;
        }
        return replacement;
    }
}

