/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.platform.services;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.favouriteless.enchanted.platform.NeoPacketContext;
import net.favouriteless.enchanted.platform.PacketContext;
import net.favouriteless.enchanted.platform.services.NetworkHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoNetworkHelper
implements NetworkHelper {
    private static final List<PayloadRegisterable<?>> clientPackets = new ArrayList();
    private static final List<PayloadRegisterable<?>> serverPackets = new ArrayList();
    private static final List<PayloadRegisterable<?>> bidirectionalPackets = new ArrayList();

    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        clientPackets.forEach(r -> r.playClient(registrar));
        serverPackets.forEach(r -> r.playClient(registrar));
        bidirectionalPackets.forEach(r -> r.playClient(registrar));
    }

    @Override
    public <T extends CustomPacketPayload> void registerClient(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, BiConsumer<T, PacketContext> handler) {
        clientPackets.add(new PayloadRegisterable<T>(type, codec, handler));
    }

    @Override
    public <T extends CustomPacketPayload> void registerServer(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, BiConsumer<T, PacketContext> handler) {
        serverPackets.add(new PayloadRegisterable<T>(type, codec, handler));
    }

    @Override
    public <T extends CustomPacketPayload> void registerBidirectional(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, BiConsumer<T, PacketContext> handler) {
        bidirectionalPackets.add(new PayloadRegisterable<T>(type, codec, handler));
    }

    @Override
    public void sendToPlayer(CustomPacketPayload payload, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToAllPlayers(CustomPacketPayload payload, MinecraftServer server) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToServer(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private record PayloadRegisterable<T extends CustomPacketPayload>(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, BiConsumer<T, PacketContext> handler) {
        private void playClient(PayloadRegistrar registrar) {
            registrar.playToClient(this.type, this.codec, (payload, context) -> this.handler.accept(payload, new NeoPacketContext(context)));
        }

        private void playServer(PayloadRegistrar registrar) {
            registrar.playToServer(this.type, this.codec, (payload, context) -> this.handler.accept(payload, new NeoPacketContext(context)));
        }

        private void playBidirectional(PayloadRegistrar registrar) {
            registrar.playBidirectional(this.type, this.codec, (payload, context) -> this.handler.accept(payload, new NeoPacketContext(context)));
        }
    }
}

