/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.neoforge.datagen.providers.modopedia;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.FramedImageBuilder;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.page.ByproductPageBuilder;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.page.DistilleryPageBuilder;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.page.DoubleByproductPageBuilder;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.page.MutagenPageBuilder;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.page.RitePageBuilder;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.page.SpinningPageBuilder;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.recipe.KettleRecipeBuilder;
import net.favouriteless.enchanted.api.datagen.builders.modopedia.templates.recipe.WitchCauldronRecipeBuilder;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.DistilleryBlock;
import net.favouriteless.enchanted.common.blocks.FumeFunnelBlock;
import net.favouriteless.enchanted.common.blocks.WitchOvenBlock;
import net.favouriteless.enchanted.common.blocks.crops.CropBlockAgeFive;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.BookContentOutput;
import net.favouriteless.modopedia.api.datagen.BookOutput;
import net.favouriteless.modopedia.api.datagen.builders.CategoryBuilder;
import net.favouriteless.modopedia.api.datagen.builders.EntryBuilder;
import net.favouriteless.modopedia.api.datagen.builders.PageComponentBuilder;
import net.favouriteless.modopedia.api.datagen.builders.page_components.components.GalleryBuilder;
import net.favouriteless.modopedia.api.datagen.builders.page_components.components.HeaderBuilder;
import net.favouriteless.modopedia.api.datagen.builders.page_components.components.MultiblockBuilder;
import net.favouriteless.modopedia.api.datagen.builders.page_components.components.SeparatorBuilder;
import net.favouriteless.modopedia.api.datagen.builders.templates.page.BlockPageBuilder;
import net.favouriteless.modopedia.api.datagen.builders.templates.page.CookingPageBuilder;
import net.favouriteless.modopedia.api.datagen.builders.templates.page.CraftingPageBuilder;
import net.favouriteless.modopedia.api.datagen.builders.templates.page.EntityPageBuilder;
import net.favouriteless.modopedia.api.datagen.builders.templates.page.HeaderedTextBuilder;
import net.favouriteless.modopedia.api.datagen.builders.templates.page.MultiblockPageBuilder;
import net.favouriteless.modopedia.api.datagen.builders.templates.recipes.CookingRecipeBuilder;
import net.favouriteless.modopedia.api.datagen.builders.templates.recipes.CraftingRecipeBuilder;
import net.favouriteless.modopedia.api.datagen.providers.ContentSetProvider;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.favouriteless.modopedia.api.text.FormattedStringBuilder;
import net.favouriteless.modopedia.client.multiblock.DenseMultiblock;
import net.favouriteless.modopedia.client.multiblock.state_matchers.SimpleStateMatcher;
import net.favouriteless.modopedia.client.multiblock.state_matchers.TagStateMatcher;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.ArrayUtils;

public class EContentSetProvider
extends ContentSetProvider {
    public EContentSetProvider(CompletableFuture<HolderLookup.Provider> registries, PackOutput output) {
        super("enchanted", "art_of_witchcraft", "en_us", registries, output);
    }

    public void buildCategories(HolderLookup.Provider provider, BookContentOutput output) {
        CategoryBuilder.of((String)"Getting Started").landingText(FormattedStringBuilder.begin().then("To get started in witchcraft, first you must know about the basic tools and equipment used by witches.").paragraph("This chapter tells you everything you need to know about getting started as a Witch.").toString()).icon(EItems.ARTHANA.get().getDefaultInstance()).children(new String[]{"getting_started/altars"}).entries(this.itemPaths((Item)EItems.ARTHANA.get(), (Item)EItems.EARMUFFS.get(), EItems.BROOM.get(), EItems.TAGLOCK.get(), EItems.BONE_NEEDLE.get(), EItems.ATTUNED_STONE.get(), EItems.WAYSTONE.get(), EItems.WOOD_ASH.get(), EItems.QUICKLIME.get(), EItems.CIRCLE_TALISMAN.get())).sortNum(0).build("getting_started", output);
        CategoryBuilder.of((String)"Altars").landingText(FormattedStringBuilder.begin().then("An altar acts as a source of magical energy for chalk circles and most of a witch's tools.").paragraph("The amount of natural energy around an altar will determine how effective it is. Generally, a variety of plants is best.").toString()).icon(EItems.ALTAR.get().getDefaultInstance()).displayOnFrontPage(false).entries(new String[]{this.blockPath((Block)EBlocks.ALTAR.get()), this.gettingStartedPath("torch_upgrades"), this.gettingStartedPath("skull_upgrades"), this.gettingStartedPath("chalice_upgrades")}).build("getting_started/altars", output);
        CategoryBuilder.of((String)"Material Processing").landingText(FormattedStringBuilder.begin().then("Many resources used in witchcraft can only be obtained by extracting them from other materials.").paragraph("This involves two processes; fume collection and distillation. Both of these are detailed in this chapter.").toString()).icon(EItems.WITCH_OVEN.get().getDefaultInstance()).entries(this.blockPaths((Block)EBlocks.WITCH_OVEN.get(), (Block)EBlocks.DISTILLERY.get())).entries(this.itemPaths(EItems.CLAY_JAR.get(), EItems.BREATH_OF_THE_GODDESS.get(), EItems.DEMONIC_BLOOD.get(), EItems.DIAMOND_VAPOUR.get(), EItems.ENDER_DEW.get(), EItems.EXHALE_OF_THE_HORNED_ONE.get(), EItems.FOUL_FUME.get(), EItems.GYPSUM.get(), EItems.HINT_OF_REBIRTH.get(), EItems.ODOUR_OF_PURITY.get(), EItems.OIL_OF_VITRIOL.get(), EItems.QUICKLIME.get(), EItems.REEK_OF_MISFORTUNE.get(), EItems.REFINED_EVIL.get(), EItems.TEAR_OF_THE_GODDESS.get(), EItems.WHIFF_OF_MAGIC.get(), EItems.WOOD_ASH.get())).sortNum(1).build("extraction", output);
        CategoryBuilder.of((String)"Herbology").landingText(FormattedStringBuilder.begin().then("Witchcraft often requires using various plants, some of which are common while others require mutations.").paragraph("This chapter aims to tell you how to obtain these plants and what they do.").toString()).icon(EItems.WOLFSBANE_FLOWER.get().getDefaultInstance()).children(new String[]{"herbology/mutated_plants"}).entries(this.blockPaths((Block)EBlocks.BELLADONNA.get(), (Block)EBlocks.WATER_ARTICHOKE.get(), (Block)EBlocks.MANDRAKE.get(), (Block)EBlocks.SNOWBELL.get(), (Block)EBlocks.WOLFSBANE.get(), (Block)EBlocks.GARLIC.get())).sortNum(2).build("herbology", output);
        CategoryBuilder.of((String)"Mutated Plants").landingText(FormattedStringBuilder.begin().then("Some plants require mutations to be obtained, either by using Mutandis or Mutandis Extremis.").paragraph("Plants of this nature are covered in this chapter.").toString()).icon(EItems.MUTANDIS.get().getDefaultInstance()).displayOnFrontPage(false).entries(new String[]{this.herbologyPath("mutations")}).entries(this.itemPaths(EItems.MUTANDIS.get(), EItems.MUTANDIS_EXTREMIS.get())).entries(this.blockPaths((Block)EBlocks.ROWAN_SAPLING.get(), (Block)EBlocks.HAWTHORN_SAPLING.get(), (Block)EBlocks.ALDER_SAPLING.get(), (Block)EBlocks.SPANISH_MOSS.get(), EBlocks.GLINT_WEED.get(), EBlocks.EMBER_MOSS.get(), (Block)EBlocks.BLOOD_POPPY.get())).build("herbology/mutated_plants", output);
        CategoryBuilder.of((String)"Brewing").landingText(FormattedStringBuilder.begin().then("One of the most essential skills a witch can possess is the abilities and knowledge to create brews, potions and decoctions.").paragraph("The methods of brewing and various common recipes can be found in this chapter.").toString()).icon(EItems.REDSTONE_SOUP.get().getDefaultInstance()).entries(new String[]{"brewing/brewing"}).entries(this.itemPaths(EItems.MUTANDIS.get(), EItems.MUTANDIS_EXTREMIS.get(), (Item)EItems.GOLDEN_CHALK.get(), (Item)EItems.NETHER_CHALK.get(), (Item)EItems.OTHERWHERE_CHALK.get(), EItems.DROP_OF_LUCK.get(), EItems.REDSTONE_SOUP.get(), EItems.FLYING_OINTMENT.get(), EItems.HAPPENSTANCE_OIL.get(), EItems.MYSTIC_UNGUENT.get(), EItems.SPIRIT_OF_OTHERWHERE.get(), EItems.SOUL_OF_THE_WORLD.get(), EItems.BREW_OF_LOVE.get(), EItems.BREW_OF_SPROUTING.get(), EItems.BREW_OF_THE_DEPTHS.get(), EItems.BREW_OF_THE_GROTESQUE.get())).sortNum(3).build("brewing", output);
        CategoryBuilder.of((String)"Circle Magic").icon(EItems.CIRCLE_TALISMAN.get().getDefaultInstance()).landingText(FormattedStringBuilder.begin().then("Circle magic is the practice of using chalk circles and foci to manifest complex magical phenomenon.").paragraph("The fundamentals of circle magic and known rites are detailed in this chapter.").toString()).children(new String[]{"circle_magic/tutorial", "circle_magic/binding", "circle_magic/charging", "circle_magic/creature", "circle_magic/curses", "circle_magic/transposition", "circle_magic/world"}).sortNum(5).build("circle_magic", output);
        CategoryBuilder.of((String)"Fundamental Theory").icon(EItems.CIRCLE_TALISMAN.get().getDefaultInstance()).displayOnFrontPage(false).landingText(FormattedStringBuilder.begin().then("Performing a circle magic rite can be a complex and difficult process, requiring a mixture of chalk circles and foci.").paragraph("This chapter explains the fundamentals and some important items.").toString()).entries(new String[]{"circle_magic/tutorial/performing_rites"}).entries(this.itemPaths((Item)EItems.GOLDEN_CHALK.get(), (Item)EItems.RITUAL_CHALK.get(), (Item)EItems.NETHER_CHALK.get(), (Item)EItems.OTHERWHERE_CHALK.get(), EItems.BROOM.get(), EItems.CIRCLE_TALISMAN.get())).build("circle_magic/tutorial", output);
        CategoryBuilder.of((String)"Binding").icon(Items.CHAIN.getDefaultInstance()).displayOnFrontPage(false).landingText(FormattedStringBuilder.begin().then("Binding is the act of linking a being or object to a magical effect or property, for example imbuing a broomstick with the power of flight.").paragraph("Rites of this manner are explained in this chapter.").toString()).entries(this.ritePaths("charging_stone", "bind_familiar", "bind_talisman", "waystone", "waystone_blooded", "infuse_broom")).build("circle_magic/binding", output);
        CategoryBuilder.of((String)"Creature").icon(Items.CREEPER_HEAD.getDefaultInstance()).displayOnFrontPage(false).landingText(FormattedStringBuilder.begin().then("Creature rites are used to change or limit the behaviour of mobs and other creatures.").paragraph("Rites of this type are often used for protection, warding and imprisonment.").toString()).entries(this.ritePaths("imprisonment", "protection", "protection_temporary", "sanctity")).build("circle_magic/creature", output);
        CategoryBuilder.of((String)"Curses").icon(Items.WITHER_ROSE.getDefaultInstance()).displayOnFrontPage(false).landingText(FormattedStringBuilder.begin().then("A curse is a long-lasting, malicious form of magic intended to harm it's target.").paragraph("There are several types of curses, each of which are explained in detail here.").toString()).entries(new String[]{"circle_magic/curses/casting_curses"}).entries(this.ritePaths("blight", "curse_misfortune", "curse_overheating", "curse_sinking", "remove_misfortune", "remove_overheating", "remove_sinking")).build("circle_magic/curses", output);
        CategoryBuilder.of((String)"Transposition").icon(Items.ENDER_PEARL.getDefaultInstance()).displayOnFrontPage(false).landingText(FormattedStringBuilder.begin().then("Transposition rites are used to change the position of an object or being, for example, teleportation.").paragraph("Summoning also falls under transposition as the summoned being is being moved to the circle.").toString()).entries(this.ritePaths("summon_entity", "summon_familiar", "transpose_caster", "transpose_iron")).build("circle_magic/transposition", output);
        CategoryBuilder.of((String)"World").icon(Items.GRASS_BLOCK.getDefaultInstance()).displayOnFrontPage(false).landingText(FormattedStringBuilder.begin().then("World rites are a powerful form of circle magic in which a witch attempts to alter natural phenomenon.").paragraph("This can prove dangerous if used improperly.").toString()).entries(this.ritePaths("broiling", "fertility", "forest", "sky_wrath", "total_eclipse", "transpose_iron")).build("circle_magic/world", output);
        CategoryBuilder.of((String)"Poppetry").icon(EItems.SPINNING_WHEEL.get().getDefaultInstance()).landingText(FormattedStringBuilder.begin().then("Poppets are a type of sympathetic magic for transferring effects on a person to a doll or vice versa.").paragraph("There are beneficial and harmful poppets, both of which are detailed in this chapter.").toString()).entries(new String[]{this.itemPath(EItems.POPPET.get())}).entries(new String[]{this.blockPath((Block)EBlocks.POPPET_SHELF.get())}).entries(this.itemPaths(EItems.POPPET_INFUSED.get(), EItems.POPPET_STURDY.get(), EItems.ARMOUR_POPPET.get(), EItems.EARTH_POPPET.get(), EItems.FIRE_POPPET.get(), EItems.HUNGER_POPPET.get(), EItems.MAGIC_POPPET.get(), EItems.TOOL_POPPET.get(), EItems.VOID_POPPET.get(), EItems.VOODOO_POPPET.get(), EItems.VOODOO_PROTECTION_POPPET.get(), EItems.WATER_POPPET.get())).sortNum(4).build("poppetry", output);
    }

    public void buildEntries(HolderLookup.Provider provider, BookContentOutput output) {
        this.buildItemEntries(output);
        this.buildBlockEntries(output);
        this.buildGettingStartedEntries(output);
        this.buildHerbologyEntries(output);
        this.buildBrewingEntries(output);
        this.buildCircleMagicEntries(output);
        this.buildPoppetryEntries(output);
    }

    public void buildItemEntries(BookContentOutput output) {
        this.buildExtractionItemEntries(output);
        this.buildBrewItemEntries(output);
        this.craftingEntry(output, "Ritual Chalk", FormattedStringBuilder.begin().then("Ritual chalk is the most basic of the four types of chalk, used for drawing basic circles in rites.").paragraph("There are no known special effects of ritual chalk, it is merely chalk infused with ").boldEntryLink(this.itemPath(EItems.TEAR_OF_THE_GODDESS.get()), "Tear of the Goddess").then(".").toString(), (Item)EItems.RITUAL_CHALK.get());
        this.cauldronEntry(output, "Golden Chalk", (Item)EItems.GOLDEN_CHALK.get(), FormattedStringBuilder.begin().then("Chalk is vital for performing circle magic and among chalks golden chalk is the most important.").paragraph("The ").boldEntryLink("circle_magic/tutorial/performing_rites", "heart glyph").then(" for ").boldCategoryLink("circle_magic", "circle magic").then(" is drawn using golden chalk.").toString());
        this.cauldronEntry(output, "Infernal Chalk", (Item)EItems.NETHER_CHALK.get(), FormattedStringBuilder.begin().then("Infusing chalk with blaze powder binds it to the nether and enables it to better conduct heat.").paragraph("Infernal chalk is used for many rites involving the nether, demonic beings or fire.").toString());
        this.cauldronEntry(output, "Otherwhere Chalk", (Item)EItems.OTHERWHERE_CHALK.get(), FormattedStringBuilder.begin().then("Materials from the end can be infused into chalk to create a rich, purple chalk with special properties.").paragraph("Typically, otherwhere chalk is used in circle magic rites involving teleportation, transposition, relocation or the end.").toString());
        this.craftingEntry(output, "Brooms", FormattedStringBuilder.begin().then("A broom can be used to sweep chalk away quickly, without having to spend time erasing it.").paragraph("Conveniently, a broom can also make for an excellent method of transportation with some preparation.").toString(), EItems.BROOM.get());
        this.craftingEntry(output, "Earmuffs", FormattedStringBuilder.begin().then("When dealing with Mandrakes, Banshees and other loud creatures, protection for your ears is essential.").paragraph().bold("Earmuffs").then(" can dampen deafening sounds, rendering them bearable.").toString(), (Item)EItems.EARMUFFS.get());
        this.craftingEntry(output, "Taglocks", FormattedStringBuilder.begin().then("Sometimes, you may need to represent another person to perform magic. This can be achieved using a ").bold("taglock kit").paragraph("By using a taglock kit on a Player or their bed, you can collect a sample to use in magic.").toString(), EItems.TAGLOCK.get(), EItems.TAGLOCK_FILLED.get(), EItems.TAGLOCK.get());
        EntryBuilder.of((String)"Arthana").icon(EItems.ARTHANA.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.ARTHANA.get(), EItems.TONGUE_OF_DOG.get(), EItems.WOOL_OF_BAT.get(), EItems.CREEPER_HEART.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Arthana", (String)FormattedStringBuilder.begin().then("The ").bold("arthana").then("  is a ritual knife used for sacrifice. When used to kill certain mobs, they can drop rare materials.").toString()), CraftingRecipeBuilder.of((ResourceLocation)this.itemId((Item)EItems.ARTHANA.get())).y(75)}).page(new PageComponentBuilder[]{GalleryBuilder.of((PageComponentBuilder[])new PageComponentBuilder[]{EntityPageBuilder.of((EntityType)EntityType.BAT, (String)this.drops("Wool of Bat")).scale(0.75f), EntityPageBuilder.of((EntityType)EntityType.WOLF, (String)this.drops("Tongue of Dog")).scale(0.65f), EntityPageBuilder.of((EntityType)EntityType.CREEPER, (String)this.drops("Creeper Heart")), EntityPageBuilder.of((EntityType)EntityType.SKELETON, (String)this.drops("Skeleton Skull"))})}).build(this.itemPath((Item)EItems.ARTHANA.get()), (BookOutput)output);
        this.craftingEntry(output, "Attuned Stones", FormattedStringBuilder.begin().then("An attuned stone is a diamond which has been infused with magical energy.").paragraph("It can be charged to be used as a portable container for ").boldEntryLink(this.blockPath((Block)EBlocks.ALTAR.get()), "altar power").then(", allowing the user to cast circle magic without an altar being present, and is also used in the creation of a variety of magical tools.").toString(), EItems.ATTUNED_STONE.get());
        this.craftingEntry(output, "Bone Needles", FormattedStringBuilder.begin().then("Needles are an important part of many tools used for Witchcraft, most notably ").boldEntryLink(this.itemPath(EItems.TAGLOCK.get()), "taglock kits").then(" and ").bold("poppets").then(".").paragraph("A simple needle can be fashioned by whittling a bone.").toString(), EItems.BONE_NEEDLE.get());
        this.craftingEntry(output, "Waystone", FormattedStringBuilder.begin().then("Waystones are a type of stone which can be bound to the location of a block or entity and used to represent it in circle magic.").paragraph("This can be accomplished via a ").boldCategoryLink("circle_magic/binding", "rite of binding").then(".").toString(), EItems.WAYSTONE.get());
        this.craftingEntry(output, "Circle Talisman", FormattedStringBuilder.begin().then("Used for picking up and holding chalk glyphs via a ").boldEntryLink(this.ritePath("bind_talisman"), "rite of binding").then(", talismans are an indispensable tool for circle magic.").paragraph("The ornate and complex symbols engraved on the talisman can also indicate wealth.").toString(), EItems.CIRCLE_TALISMAN.get());
        this.cauldronEntry(output, "Mutandis", EItems.MUTANDIS.get(), FormattedStringBuilder.begin().then("Mutandis is used to mutate plants into other species you could not normally obtain.").paragraph("Using this substance on a block can cause it to ").boldEntryLink(this.herbologyPath("mutations"), "mutate").then(" into a different block under the right conditions.").toString());
        this.cauldronEntry(output, "Mutandis Extremis", EItems.MUTANDIS_EXTREMIS.get(), FormattedStringBuilder.begin().then("Mutandis Extremis, an enhanced form of ").boldEntryLink(this.itemPath(EItems.MUTANDIS.get()), "mutandis").then(", performs a very similar function.").paragraph("Extremis is able to create more advanced ").boldEntryLink(this.herbologyPath("mutations"), "mutations").then(" such as ").boldEntryLink(this.blockPath((Block)EBlocks.BLOOD_POPPY.get()), "Blood Poppies").then(".").toString());
        EntryBuilder.of((String)"Clay Jars").icon(EItems.CLAY_JAR.get().getDefaultInstance()).assignedItems(new Item[]{EItems.CLAY_JAR.get(), EItems.SOFT_CLAY_JAR.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Clay Jars", (String)"A container to hold materials collected during fume extraction or distillation is essential for witches. A simple clay jar works well for this purpose.")}).page(new PageComponentBuilder[]{HeaderBuilder.of((String)Modopedia.translation((String)"template", (String)"recipe")), SeparatorBuilder.of().y(10), CookingRecipeBuilder.of((ResourceLocation)this.itemId(EItems.CLAY_JAR.get()), (String[])new String[0]).y(30), CraftingRecipeBuilder.of((ResourceLocation)this.itemId(EItems.SOFT_CLAY_JAR.get())).y(70)}).build(this.itemPath(EItems.CLAY_JAR.get()), (BookOutput)output);
    }

    public void buildBrewItemEntries(BookContentOutput output) {
        this.kettleEntry(output, "Brew of Love", EItems.BREW_OF_LOVE.get(), FormattedStringBuilder.begin().then("Charming or love potions are one of the most widely sought types of brew.").paragraph("When thrown, the vapour produced will cause nearby animals to become infatuated.").toString());
        this.kettleEntry(output, "Brew of Sprouting", EItems.BREW_OF_SPROUTING.get(), FormattedStringBuilder.begin().then("Being able to slow your opponents in combat can be the difference between life and death.").paragraph("The brew of sprouting can be used to ensnare mobs and people with roots.").paragraph().bold("This feature is coming soon.").toString());
        this.kettleEntry(output, "Brew of the Depths", EItems.BREW_OF_THE_DEPTHS.get(), FormattedStringBuilder.begin().then("The ability to breathe underwater has fascinated people for millennia. Fortunately, witches have a solution for this.").paragraph("The brew of depths grants the ability to breathe underwater for an extended time when ingested.").toString());
        this.kettleEntry(output, "Brew of the Grotesque", EItems.BREW_OF_THE_GROTESQUE.get(), FormattedStringBuilder.begin().then("This brew makes the drinker unrecognisably grotesque, tricking nearby mobs into believing the drinker is one of their own.").paragraph("Additionally, brew of the grotesque is used as a base in most ").boldEntryLink("circle_magic/curses", "curses").then(".").toString());
        this.kettleEntry(output, "Flying Ointment", EItems.FLYING_OINTMENT.get(), FormattedStringBuilder.begin().then("Flying ointment is a brew which seems to defy gravity; anything imbued with it will gain the property of flight, including people who ingest it.").paragraph("Most notably, it can be used to ").boldEntryLink(this.ritePath("infuse_broomstick"), "infuse broomsticks").toString());
        this.kettleEntry(output, "Happenstance Oil", EItems.HAPPENSTANCE_OIL.get(), FormattedStringBuilder.begin().then("Clairvoyance is an indispensable tool for a witch in need of information.").paragraph("Happenstance oil is a key component of crystal balls, and while consuming it is not recommended, it can improve your vision.").toString());
        this.kettleEntry(output, "Mystic Unguent", EItems.MYSTIC_UNGUENT.get(), FormattedStringBuilder.begin().then("Mystic Unguent is a curious concoction which allows a witch to give physical form to thoughts.").paragraph("It's main use is in the production of mystic branches, consuming this brew is not recommended.").toString());
        this.kettleEntry(output, "Redstone Soup", EItems.REDSTONE_SOUP.get(), FormattedStringBuilder.begin().then("Redstone Soup primarily acts as a base for other infusions and brews, it has very few reported effects outside of this.").paragraph("Ingesting redstone soup can increase your health for a short time.").toString());
        this.kettleEntry(output, "Soul of the World", EItems.SOUL_OF_THE_WORLD.get(), FormattedStringBuilder.begin().then("Soul of the World is a derivation of ").boldEntryLink(this.itemPath(EItems.REDSTONE_SOUP.get()), "redstone soup").then(" imbued with natural energy. It can be used to infuse energy into a person to grant them special abilities.").paragraph("This brew is extremely toxic and should not be ingested.").toString());
        this.kettleEntry(output, "Spirit of Otherwhere", EItems.SPIRIT_OF_OTHERWHERE.get(), FormattedStringBuilder.begin().then("Similar to ").boldEntryLink(this.itemPath(EItems.SOUL_OF_THE_WORLD.get()), "soul of the world").then(", spirit of otherwhere is a derivation of ").boldEntryLink(this.itemPath(EItems.REDSTONE_SOUP.get()), "redstone soup").then(" imbued with the same properties as the End and its inhabitants.").paragraph("This infusion is extremely toxic and should not be ingested.").toString());
        this.cauldronEntry(output, "Drop of Luck", EItems.DROP_OF_LUCK.get(), this.formatItems("Liquid luck, or drop of luck, is a potion which enhances the luck of anybody who drinks it and can be used in rites or the creation of magical items.\n\nFamously, it's a core ingredient in $(b)$(el:%s)Redstone Soup$().", EItems.REDSTONE_SOUP.get()));
    }

    public void buildExtractionItemEntries(BookContentOutput output) {
        this.cookingEntry(output, "Wood Ash", FormattedStringBuilder.begin().then("Simple ash has many uses, including making ").boldEntryLink(this.itemPath((Item)EItems.RITUAL_CHALK.get()), "ritual chalk").then(" and bone meal among other things.").paragraph("As it has no magical properties, burning any sapling will work.").toString(), EItems.WOOD_ASH.get());
        this.cookingEntry(output, "Quicklime", FormattedStringBuilder.begin().then("Burnt lime, or quicklime, one of the primary ingredients for ").boldEntryLink(this.itemPath(EItems.GYPSUM.get()), "gypsum").then(", can be made using calcite.").paragraph("Quicklime can be thrown at players to temporarily blind them.").toString(), EItems.QUICKLIME.get());
        this.galleryEntry(output, "Breath of the Goddess", EItems.BREATH_OF_THE_GODDESS.get(), FormattedStringBuilder.begin().then("Due to it's silvery appearance, birch is sometimes called \"White Lady Of The Woods\" and is associated with the goddess Brigid.").paragraph("The smoke produced by burning birch has healing properties.").toString(), this.byproductComponents("byproduct/breath_of_the_goddess_birch_sapling"));
        this.galleryEntry(output, "Demonic Blood", EItems.DEMONIC_BLOOD.get(), FormattedStringBuilder.begin().then("The blood of a demon has many uses in witchcraft. While usually obtained from demons, it can also be refined from several other materials.").paragraph("It's main uses are in infusions and curses.").toString(), this.distillingComponents("distilling/diamond_vapour_blaze_rod"));
        this.galleryEntry(output, "Diamond Vapour", EItems.DIAMOND_VAPOUR.get(), FormattedStringBuilder.begin().then("Diamonds, by using oil of vitriol, can be dissolved and then evaporated to form a powerful refining agent.").paragraph("Diamond vapour is required to distill some other materials.").toString(), this.distillingComponents("distilling/diamond_oil_of_vitriol"));
        this.galleryEntry(output, "Ender Dew", EItems.ENDER_DEW.get(), FormattedStringBuilder.begin().then("Ender pearls, which allow people to teleport, can be distilled into a purer form called Ender Dew.").paragraph("This substance contains the relocation properties of ender pearls in a liquid form, making it useful for brewing.").toString(), this.distillingComponents("distilling/ender_pearl"));
        this.galleryEntry(output, "Horned One's Exhale", EItems.EXHALE_OF_THE_HORNED_ONE.get(), FormattedStringBuilder.begin().then("The Oak King, one of the aspects of the Horned God, symbolises nature, hunting and the cycle of life.").paragraph("The fumes produced by oaks are said to be The Horned God's exhale, carrying some of the properties associated with him.").toString(), this.byproductComponents("byproduct/exhale_of_the_horned_one_oak_sapling"));
        this.galleryEntry(output, "Foul Fume", EItems.FOUL_FUME.get(), FormattedStringBuilder.begin().then("A foul smelling smoke containing sulfur, often smelled when encountering demonic beings or the nether.").paragraph("There are many plants, foods and other sources containing this gas.").toString(), EContentSetProvider.merge(this.byproductComponents("byproduct/foul_fume_jungle_sapling", "byproduct/foul_fume_logs_that_burn", "byproduct/foul_fume_raw_foods"), this.distillingComponents("distilling/breath_of_the_goddess_lapis_lazuli", "distilling/diamond_vapour_ghast_tear")));
        this.galleryEntry(output, "Gypsum", EItems.GYPSUM.get(), FormattedStringBuilder.begin().then("A soft, translucent mineral salt produced by oxidising sulfides in the presence of quicklime.").paragraph("In addition to being an effective fertiliser, it is commonly used as a base for ritual chalks.").toString(), this.distillingComponents("distilling/foul_fume_quicklime"));
        this.galleryEntry(output, "Hint of Rebirth", EItems.HINT_OF_REBIRTH.get(), FormattedStringBuilder.begin().then("Spruce trees are associated with the birth of the divine child. As such, they are a symbol of rebirth, protection, resilience and endurance.").paragraph("Regardless, they make good firewood.").toString(), this.byproductComponents("byproduct/hint_of_rebirth_spruce_sapling"));
        this.galleryEntry(output, "Odour of Purity", EItems.ODOUR_OF_PURITY.get(), FormattedStringBuilder.begin().then("Hawthorn can be used to collect a powerful purifying agent called Odour of Purity, which is used in the creation of most pure substances.").paragraph("This tree is sacred to the Goddesses Aine and Brigid.").toString(), EContentSetProvider.merge(this.byproductComponents("byproduct/odour_of_purity_hawthorn_sapling"), this.distillingComponents("distilling/diamond_oil_of_vitriol", "distilling/diamond_vapour_ghast_tear")));
        this.galleryEntry(output, "Oil of Vitriol", EItems.OIL_OF_VITRIOL.get(), FormattedStringBuilder.begin().then("A clear, slightly yellowed liquid which seems to react to living matter with vitriol, leaving them burned and blackened.").paragraph("Oil of vitriol dissolves most substances it comes into contact with.").toString(), this.distillingComponents("distilling/foul_fume_quicklime"));
        this.galleryEntry(output, "Reek of Misfortune", EItems.REEK_OF_MISFORTUNE.get(), FormattedStringBuilder.begin().then("The sacred alder tree appears to bleed when cut, bringing misfortune to all. It is thought that the tree contains the souls of our ancestors.").paragraph("The fumes produced from burning it can be collected, keeping these effects.").toString(), EContentSetProvider.merge(this.byproductComponents("byproduct/reek_of_misfortune_alder_sapling"), this.distillingComponents("distilling/diamond_vapour_ghast_tear", "distilling/ender_pearl")));
        this.galleryEntry(output, "Refined Evil", EItems.REFINED_EVIL.get(), FormattedStringBuilder.begin().then("Pure, condensed evil refined using diamond vapour.").paragraph("Refined Evil is primarily used for brewing, but also has some uses in demonology.").toString(), this.distillingComponents("distilling/diamond_vapour_ghast_tear"));
        this.galleryEntry(output, "Tear of the Goddess", EItems.TEAR_OF_THE_GODDESS.get(), FormattedStringBuilder.begin().then("Lapis Lazuli is a gemstone which brings wisdom, truth, loyalty and honour.").paragraph("Combining Lapis with the White Goddess's power amplifies it's effects.").toString(), this.distillingComponents("distilling/breath_of_the_goddess_lapis_lazuli"));
        this.galleryEntry(output, "Whiff of Magic", EItems.WHIFF_OF_MAGIC.get(), FormattedStringBuilder.begin().then("Rowan wood is famous for it's unparalleled affinity for magic").paragraph("The smoke it produces can be condensed into pure magical energy thought to provide protection against malevolent beings.").toString(), EContentSetProvider.merge(this.byproductComponents("byproduct/whiff_of_magic_rowan_sapling"), this.distillingComponents("distilling/ender_pearl", "distilling/breath_of_the_goddess_lapis_lazuli")));
    }

    public void buildBlockEntries(BookContentOutput output) {
        this.buildHerbologyBlockEntries(output);
        EntryBuilder.of((String)"Creating an Altar").icon(EItems.ALTAR.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.ALTAR.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Creating an Altar", (String)FormattedStringBuilder.begin().then("To construct an altar, a witch must place ").bold("six altar blocks").then(" to form a rectangular platform.").toString()), CraftingRecipeBuilder.of((ResourceLocation)Enchanted.id("altar")).y(65)}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Altar Power", (String)"Altars draw their power from nature, specifically from plants in the surrounding area. A variety of plants works better than having only a few."), FramedImageBuilder.of(Enchanted.id("textures/gui/modopedia/altar.png")).x(10).y(80)}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Upgrades", (String)FormattedStringBuilder.begin().then("Certain blocks may be placed on top of the altar to multiply its effects.").paragraph("Upgrades have a ").bold("type").then(", only the best upgrade within a type will be counted.").toString()), MultiblockBuilder.of().y(70).height(70).multiblockId(Enchanted.id("altar"))}).build(this.blockPath((Block)EBlocks.ALTAR.get()), (BookOutput)output);
        EntryBuilder.of((String)"Distillation").icon(EItems.DISTILLERY.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.DISTILLERY.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Distillation", (String)FormattedStringBuilder.begin().then("The distillery allows witches to separate materials into their components by utilising differences in boiling and condensing points.").paragraph("Processing consumes ").boldEntryLink(this.blockPath((Block)EBlocks.ALTAR.get()), "altar power").then(", so the distillery must be placed accordingly.").toString())}).page(new PageComponentBuilder[]{HeaderBuilder.of((String)Modopedia.translation((String)"template", (String)"crafting_recipe")), SeparatorBuilder.of().y(10), MultiblockBuilder.of().multiblock((Multiblock)new DenseMultiblock(List.of(List.of("D")), Map.of(Character.valueOf('D'), new SimpleStateMatcher(List.of((BlockState)EBlocks.DISTILLERY.get().defaultBlockState().setValue((Property)DistilleryBlock.LIT, (Comparable)Boolean.valueOf(true))))))).y(10).height(50), CraftingRecipeBuilder.of((ResourceLocation)this.itemId((Item)EItems.DISTILLERY.get())).y(70)}).build(this.blockPath((Block)EBlocks.DISTILLERY.get()), (BookOutput)output);
        EntryBuilder.of((String)"Spinning").icon(EItems.SPINNING_WHEEL.get().getDefaultInstance()).assignedItems(new Item[]{EItems.SPINNING_WHEEL.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Spinning", (String)FormattedStringBuilder.begin().then("The spinning wheel is used by witches to weave materials together, this is especially prevalent in ").boldCategoryLink("poppetry", "poppetry").then(".").paragraph("Weaving consumes ").boldEntryLink(this.blockPath((Block)EBlocks.ALTAR.get()), "altar power").then(", so the spinning wheel must be placed accordingly.").toString())}).page(new PageComponentBuilder[]{HeaderBuilder.of((String)Modopedia.translation((String)"template", (String)"crafting_recipe")), SeparatorBuilder.of().y(10), MultiblockBuilder.of().multiblock((Multiblock)new DenseMultiblock(List.of(List.of("D")), Map.of(Character.valueOf('D'), new SimpleStateMatcher(List.of(EBlocks.SPINNING_WHEEL.get().defaultBlockState()))))).y(10).height(50), CraftingRecipeBuilder.of((ResourceLocation)this.itemId(EItems.SPINNING_WHEEL.get())).y(70)}).build(this.blockPath((Block)EBlocks.SPINNING_WHEEL.get()), (BookOutput)output);
        EntryBuilder.of((String)"Poppet Shelf").icon(EItems.POPPET_SHELF.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.POPPET_SHELF.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Poppet Shelf", (String)FormattedStringBuilder.begin().then("A poppet shelf allows the ").boldCategoryLink("poppetry", "poppets").then(" held within it to be activated without being in a player's inventory.").paragraph("A single shelf can hold up to four poppets, belonging to any player.").toString())}).page(new PageComponentBuilder[]{HeaderBuilder.of((String)Modopedia.translation((String)"template", (String)"crafting_recipe")), SeparatorBuilder.of().y(10), MultiblockBuilder.of().multiblock((Multiblock)new DenseMultiblock(List.of(List.of("D")), Map.of(Character.valueOf('D'), new SimpleStateMatcher(List.of(EBlocks.POPPET_SHELF.get().defaultBlockState()))))).y(10).height(50), CraftingRecipeBuilder.of((ResourceLocation)this.itemId((Item)EItems.POPPET_SHELF.get())).y(70)}).build(this.blockPath((Block)EBlocks.POPPET_SHELF.get()), (BookOutput)output);
        EntryBuilder.of((String)"Fume Collection").icon(EItems.WITCH_OVEN.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.WITCH_OVEN.get(), (Item)EItems.FUME_FUNNEL.get(), (Item)EItems.FUME_FUNNEL_FILTERED.get(), EItems.FUME_FILTER.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Fume Collection", (String)FormattedStringBuilder.begin().then("The witch's oven is a modified furnace used to collect byproducts and fumes made from burning materials.").paragraph("Unlike a furnace, this oven cannot process ores. Place a ").boldEntryLink(this.itemPath(EItems.CLAY_JAR.get()), "clay jar").then(" into the middle slot to collect fumes.").toString())}).page(new PageComponentBuilder[]{HeaderBuilder.of((String)Modopedia.translation((String)"template", (String)"crafting_recipe")), SeparatorBuilder.of().y(10), MultiblockBuilder.of().multiblock((Multiblock)new DenseMultiblock(List.of(List.of("W")), Map.of(Character.valueOf('W'), new SimpleStateMatcher(List.of((BlockState)EBlocks.WITCH_OVEN.get().defaultBlockState().setValue((Property)WitchOvenBlock.LIT, (Comparable)Boolean.valueOf(true))))))).y(10).height(50), CraftingRecipeBuilder.of((ResourceLocation)this.itemId((Item)EItems.WITCH_OVEN.get())).y(70)}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Fume Funnels", (String)"Adding fume funnels to the left and right of your witch's oven can drastically improve it's yield."), CraftingRecipeBuilder.of((ResourceLocation)this.itemId((Item)EItems.FUME_FUNNEL.get())).y(68)}).page(new PageComponentBuilder[]{MultiblockPageBuilder.of((String)"A third fume funnel can be placed on top of the witch oven as a decorative chimney.").multiblockId(Enchanted.id("witch_oven")).offsetY(-10.0f)}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Fume Filters", (String)"A fume filter can be added to fume funnels to further increase yield. With two filters, success is guaranteed."), CraftingRecipeBuilder.of((ResourceLocation)this.itemId(EItems.FUME_FILTER.get())).y(70)}).page(new PageComponentBuilder[]{BlockPageBuilder.of((String)FormattedStringBuilder.begin().bold("Procurement:").linebreak("Use a fume filter on a fume funnel.").toString(), (BlockState)((BlockState)EBlocks.FUME_FUNNEL_FILTERED.get().defaultBlockState().setValue((Property)FumeFunnelBlock.LIT, (Comparable)Boolean.valueOf(true))))}).build(this.blockPath((Block)EBlocks.WITCH_OVEN.get()), (BookOutput)output);
        EntryBuilder.of((String)"The Kettle").icon(EItems.KETTLE.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.KETTLE.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Kettle", (String)"The kettle, used for creating infusions, is a crucial utensil for any witch."), CraftingRecipeBuilder.of((ResourceLocation)this.itemId((Item)EItems.KETTLE.get())).y(65)}).page(new PageComponentBuilder[]{MultiblockBuilder.of().multiblockId(Enchanted.id("kettle")).y(20)}).build(this.blockPath(EBlocks.KETTLE.get()), (BookOutput)output);
        EntryBuilder.of((String)"Witch's Cauldron").icon(EItems.WITCH_CAULDRON.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.WITCH_CAULDRON.get(), EItems.ANOINTING_PASTE.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Witch's Cauldron", (String)"The witch's cauldron is the most important brewing tool at a witch's disposal, enabling you to brew complex potions."), CraftingRecipeBuilder.of((ResourceLocation)this.itemId(EItems.ANOINTING_PASTE.get())).y(70)}).page(new PageComponentBuilder[]{BlockPageBuilder.of((String)FormattedStringBuilder.begin().bold("Procurement:").linebreak("Use a anointing paste on a cauldron").toString(), (BlockState)EBlocks.WITCH_CAULDRON.get().defaultBlockState())}).build(this.blockPath(EBlocks.WITCH_CAULDRON.get()), (BookOutput)output);
    }

    public void buildHerbologyBlockEntries(BookContentOutput output) {
        this.blockEntry(output, "Belladonna", FormattedStringBuilder.begin().then("Atropa bella-donna, commonly known as deadly nightshade, is a poisonous member of the Solanaceae family.").paragraph("The berries and foliage of this plant are extremely toxic and should be handled with care.").toString(), EBlocks.BELLADONNA.get(), this.procureGrass(), EItems.BELLADONNA_FLOWER.get(), (Item)EItems.BELLADONNA_SEEDS.get());
        this.blockEntry(output, "Garlic", FormattedStringBuilder.begin().then("Garlic, scientific name allium sativum, is a dietary staple in many households.").paragraph("Vampires are said to dislike garlic but its effectiveness as a repellent is questionable.").toString(), EBlocks.GARLIC.get(), this.procureGrass(), (Item)EItems.GARLIC.get());
        this.blockEntry(output, "Mandrakes", FormattedStringBuilder.begin().then("Mandrakes are a group of. perennial herbaceous plants with long, parsnip shaped roots.").paragraph("If agitated, mandrakes will scream causing injury or even death. Wearing ").boldEntryLink(this.itemPath((Item)EItems.EARMUFFS.get()), "earmuffs").then(" can protect you, and they sleep at night.").toString(), EBlocks.MANDRAKE.get(), this.procureGrass(), EItems.MANDRAKE_ROOT.get(), (Item)EItems.MANDRAKE_SEEDS.get());
        this.blockEntry(output, "Snowbell", FormattedStringBuilder.begin().then("Styrax japonicus, more commonly referred to as Snowbell, is a shrub from the Styracaceae family.").paragraph("Despite the name, they are native to warm climates in Asia. Its resin is used for purification, dispelling anger or soothing tension.").toString(), EBlocks.SNOWBELL.get(), this.procureGrass(), EItems.ICY_NEEDLE.get(), (Item)EItems.SNOWBELL_SEEDS.get());
        this.blockEntry(output, "Water Artichoke", FormattedStringBuilder.begin().then("This subspecies of the common Artichoke, or cynara cardunculus, only grows on still water.").paragraph("Unlike it's green cousin, it is not considered edible. Consumption of this plant will satiate hunger but empty your stomach.").toString(), EBlocks.WATER_ARTICHOKE.get(), this.procureGrass(), EItems.WATER_ARTICHOKE.get(), (Item)EItems.WATER_ARTICHOKE_SEEDS.get());
        this.blockEntry(output, "Wolfsbane", FormattedStringBuilder.begin().then("Aconitum, common name of Wolfsbane, is a perennial flower of the Ranunculaceae family.").paragraph("Its roots contain aconitine, a potent neurotoxin and cardiotoxin. Contrary to popular belief, the name is just a translation from greek.").toString(), EBlocks.WOLFSBANE.get(), this.procureGrass(), EItems.WOLFSBANE_FLOWER.get(), (Item)EItems.WOLFSBANE_SEEDS.get());
        this.mutatedEntry(output, "Glint Weed", FormattedStringBuilder.begin().then("This magical weed emits a glow around it, acting like a torch. ").then("While it can survive on nearly any surface, if placed on grass, dirt or sand it will spread.").toString(), EBlocks.GLINT_WEED.get(), (Item)EItems.GLINT_WEED.get());
        this.mutatedEntry(output, "Ember Moss", FormattedStringBuilder.begin().then("Ember moss is a plant with a very unique defense mechanism; it bursts into flames at the slightest touch or disturbance. ").then("Harvest with shears to be keep intact.").toString(), EBlocks.EMBER_MOSS.get(), (Item)EItems.EMBER_MOSS.get());
        this.mutatedEntry(output, "Spanish Moss", FormattedStringBuilder.begin().then("An epiphytic flowering plant, similar to a moss or lichen, found growing on trees in tropical or subtropical climates. ").then("Harvest with shears to be keep intact.").toString(), (Block)EBlocks.SPANISH_MOSS.get(), (Item)EItems.SPANISH_MOSS.get());
        this.mutatedEntry(output, "Blood Poppy", FormattedStringBuilder.begin().then("Poppies famously thrive in ground stained with blood, with a mutation they can also draw blood from those who touch them. ").then("Right click with a ").boldEntryLink(this.itemPath(EItems.TAGLOCK.get()), "taglock kit").then(" to collect blood.").toString(), (Block)EBlocks.BLOOD_POPPY.get(), (Item)EItems.BLOOD_POPPY.get());
        EntryBuilder.of((String)"Alder Trees").icon(EItems.ALDER_SAPLING.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.ALDER_SAPLING.get(), (Item)EItems.ALDER_LOG.get(), (Item)EItems.STRIPPED_ALDER_LOG.get(), (Item)EItems.ALDER_PLANKS.get(), (Item)EItems.ALDER_STAIRS.get(), (Item)EItems.ALDER_SLAB.get(), (Item)EItems.ALDER_FENCE.get(), (Item)EItems.ALDER_FENCE_GATE.get(), (Item)EItems.ALDER_BUTTON.get(), (Item)EItems.ALDER_PRESSURE_PLATE.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Alder Trees", (String)FormattedStringBuilder.begin().then("Alder trees, of the Betulaceae family, are deciduous trees thought to bleed when cut due to their red sap.").toString()), GalleryBuilder.of((PageComponentBuilder[])new PageComponentBuilder[]{MultiblockBuilder.of().multiblockId(Enchanted.id("alder_tree")).height(80), MultiblockBuilder.of().multiblock((Multiblock)new DenseMultiblock(List.of(List.of("S")), Map.of(Character.valueOf('S'), new SimpleStateMatcher(List.of(EBlocks.ALDER_SAPLING.get().defaultBlockState()))))).noOffsets(true)}).y(54).height(80)}).page(new PageComponentBuilder[]{MutagenPageBuilder.of((Block)EBlocks.ALDER_SAPLING.get())}).build(this.blockPath((Block)EBlocks.ALDER_SAPLING.get()), (BookOutput)output);
        EntryBuilder.of((String)"Hawthorn Trees").icon(EItems.HAWTHORN_SAPLING.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.HAWTHORN_SAPLING.get(), (Item)EItems.HAWTHORN_LOG.get(), (Item)EItems.STRIPPED_HAWTHORN_LOG.get(), (Item)EItems.HAWTHORN_PLANKS.get(), (Item)EItems.HAWTHORN_STAIRS.get(), (Item)EItems.HAWTHORN_SLAB.get(), (Item)EItems.HAWTHORN_FENCE.get(), (Item)EItems.HAWTHORN_FENCE_GATE.get(), (Item)EItems.HAWTHORN_BUTTON.get(), (Item)EItems.HAWTHORN_PRESSURE_PLATE.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Hawthorn Trees", (String)FormattedStringBuilder.begin().then("This species of crataegus, commonly referred to as Hawthorn, has herbal uses and is known to be effective at dispatching vampires.").toString()), GalleryBuilder.of((PageComponentBuilder[])new PageComponentBuilder[]{MultiblockBuilder.of().multiblockId(Enchanted.id("hawthorn_tree")).height(80), MultiblockBuilder.of().multiblock((Multiblock)new DenseMultiblock(List.of(List.of("S")), Map.of(Character.valueOf('S'), new SimpleStateMatcher(List.of(EBlocks.HAWTHORN_SAPLING.get().defaultBlockState()))))).noOffsets(true)}).y(54).height(80)}).page(new PageComponentBuilder[]{MutagenPageBuilder.of((Block)EBlocks.HAWTHORN_SAPLING.get())}).build(this.blockPath((Block)EBlocks.HAWTHORN_SAPLING.get()), (BookOutput)output);
        EntryBuilder.of((String)"Rowan Trees").icon(EItems.ROWAN_SAPLING.get().getDefaultInstance()).assignedItems(new Item[]{EItems.ROWAN_BERRIES.get(), (Item)EItems.ROWAN_SAPLING.get(), (Item)EItems.ROWAN_LOG.get(), (Item)EItems.STRIPPED_ROWAN_LOG.get(), (Item)EItems.ROWAN_PLANKS.get(), (Item)EItems.ROWAN_STAIRS.get(), (Item)EItems.ROWAN_SLAB.get(), (Item)EItems.ROWAN_FENCE.get(), (Item)EItems.ROWAN_FENCE_GATE.get(), (Item)EItems.ROWAN_BUTTON.get(), (Item)EItems.ROWAN_PRESSURE_PLATE.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Rowan Trees", (String)FormattedStringBuilder.begin().then("The rowan, or mountain-ash, a small deciduous tree native to Europe, has many uses in witchcraft.").toString()), GalleryBuilder.of((PageComponentBuilder[])new PageComponentBuilder[]{MultiblockBuilder.of().multiblockId(Enchanted.id("rowan_tree")).height(80), MultiblockBuilder.of().multiblock((Multiblock)new DenseMultiblock(List.of(List.of("S")), Map.of(Character.valueOf('S'), new SimpleStateMatcher(List.of(EBlocks.ROWAN_SAPLING.get().defaultBlockState()))))).noOffsets(true)}).y(54).height(80)}).page(new PageComponentBuilder[]{MutagenPageBuilder.of((Block)EBlocks.ROWAN_SAPLING.get())}).build(this.blockPath((Block)EBlocks.ROWAN_SAPLING.get()), (BookOutput)output);
    }

    public void buildGettingStartedEntries(BookContentOutput output) {
        EntryBuilder.of((String)"Chalice Upgrades").icon(EItems.CHALICE_FILLED.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.CHALICE_FILLED.get(), (Item)EItems.CHALICE.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Chalices", (String)FormattedStringBuilder.begin().then("A chalice may be placed on top of an altar to increase its power capacity. The chalice can be filled by using ").boldEntryLink(this.itemPath(EItems.REDSTONE_SOUP.get()), "Redstone Soup").then(" on it.").toString()), CraftingRecipeBuilder.of((ResourceLocation)Enchanted.id("chalice")).y(70)}).page(new PageComponentBuilder[]{GalleryBuilder.of((PageComponentBuilder[])new PageComponentBuilder[]{BlockPageBuilder.of((String)"$(b)Chalice:$()\n+1x Power Capacity", (BlockState)EBlocks.CHALICE.get().defaultBlockState()).scale(2.0f).offsetY(-20.0f), BlockPageBuilder.of((String)"$(b)Chalice (Filled):$()\n+2x Power Capacity", (BlockState)EBlocks.CHALICE_FILLED.get().defaultBlockState()).scale(2.0f).offsetY(-20.0f)})}).build(this.gettingStartedPath("chalice_upgrades"), (BookOutput)output);
        EntryBuilder.of((String)"Skull Upgrades").icon(Items.SKELETON_SKULL.getDefaultInstance()).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Skulls", (String)FormattedStringBuilder.begin().then("Skulls can increase both the capacity and recharge rate of an altar, with varying effectiveness.").paragraph("Human skulls are particularly effective at channeling energy.").toString())}).page(new PageComponentBuilder[]{GalleryBuilder.of((PageComponentBuilder[])new PageComponentBuilder[]{BlockPageBuilder.of((String)"$(b)Skeleton Skull:$()\n+1x Power Capacity\n+1x Recharge Rate", (BlockState)Blocks.SKELETON_SKULL.defaultBlockState()).scale(1.6f).offsetY(-20.0f).textOffset(-25), BlockPageBuilder.of((String)"$(b)Wither Skeleton Skull:$()\n+2x Power Capacity\n+2x Recharge Rate", (BlockState)Blocks.WITHER_SKELETON_SKULL.defaultBlockState()).scale(1.6f).offsetY(-20.0f).textOffset(-25), BlockPageBuilder.of((String)"$(b)Player Skull:$()\n+2.5x Power Capacity\n+3x Recharge Rate", (BlockState)Blocks.PLAYER_HEAD.defaultBlockState()).scale(1.6f).offsetY(-20.0f).textOffset(-25)})}).build(this.gettingStartedPath("skull_upgrades"), (BookOutput)output);
        EntryBuilder.of((String)"Torch Upgrades").icon(EItems.CANDELABRA.get().getDefaultInstance()).assignedItems(new Item[]{(Item)EItems.CANDELABRA.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Torches", (String)"A torch, candelabra or candle can be an effective means of increasing your altar's recharge rate."), CraftingRecipeBuilder.of((ResourceLocation)Enchanted.id("candelabra")).y(70)}).page(new PageComponentBuilder[]{GalleryBuilder.of((PageComponentBuilder[])new PageComponentBuilder[]{BlockPageBuilder.of((String)"$(b)Torch:$()\n+0.5x Recharge Rate", (BlockState)Blocks.TORCH.defaultBlockState()).scale(1.8f).offsetY(-15.0f).textOffset(-30), BlockPageBuilder.of((String)"$(b)Candle:$()\n+1x Recharge Rate", (BlockState)Blocks.LIGHT_GRAY_CANDLE.defaultBlockState()).scale(2.0f).offsetY(-20.0f).textOffset(-30), BlockPageBuilder.of((String)"$(b)Candelabra:$()\n+2x Recharge Rate", (BlockState)EBlocks.CANDELABRA.get().defaultBlockState()).scale(1.75f).offsetY(-15.0f).textOffset(-30)})}).build(this.gettingStartedPath("torch_upgrades"), (BookOutput)output);
    }

    public void buildBrewingEntries(BookContentOutput output) {
        EntryBuilder.of((String)"Creating Brews").icon(EItems.WITCH_CAULDRON.get().getDefaultInstance()).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Brews and Potions", (String)FormattedStringBuilder.begin().then("Creating a brew, infusion or potion is a simple process, requiring either a ").boldEntryLink(this.blockPath(EBlocks.WITCH_CAULDRON.get()), "witch's cauldron", 5778537).then(" or ").boldEntryLink(this.blockPath(EBlocks.KETTLE.get()), "kettle", 5778537).then(".").paragraph("First, you must fill your ").boldEntryLink(this.blockPath(EBlocks.WITCH_CAULDRON.get()), "cauldron").then(" or ").boldEntryLink(this.blockPath(EBlocks.KETTLE.get()), "kettle").then(" with water from a bucket. You will know it is full if no more water can fit.").toString())}).page(new PageComponentBuilder[]{MultiblockBuilder.of().y(70).height(60).multiblock((Multiblock)new DenseMultiblock(List.of(List.of("H"), List.of("C")), Map.of(Character.valueOf('C'), new SimpleStateMatcher(List.of(EBlocks.WITCH_CAULDRON.get().defaultBlockState())), Character.valueOf('H'), new TagStateMatcher(ETags.Blocks.HEAT_SOURCES)))), HeaderedTextBuilder.of((String)"Heat Sources", (String)"Next, place a heat source underneath your vessel such as fire, lava or a campfire. After a few seconds, the water should begin to boil.")}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Adding Ingredients", (String)FormattedStringBuilder.begin().then("The final step, after filling the vessel and waiting for it to boil, is to drop your ingredients into the vessel, ").bold("in order").then(", one by one").paragraph("The water should start to change colour. Once added, the brew needs to boil for a few seconds to finish.").toString())}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Spoiled Brews", (String)FormattedStringBuilder.begin().then("If you make a mistake during brewing, such as adding the wrong ingredient or removing the heat source, your brew will ").bold("spoil").then(".").paragraph("When spoiled, the brew will turn brown and need to be removed using an ").bold("empty bucket").then(".").toString())}).build(this.brewingPath("brewing"), (BookOutput)output);
    }

    public void buildHerbologyEntries(BookContentOutput output) {
        EntryBuilder.of((String)"Mutations").icon(Items.CHORUS_FRUIT.getDefaultInstance()).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Mutations", (String)FormattedStringBuilder.begin().then("While many plants are naturally occurring, herbology often requires witches to mutate existing plants to suit their needs.").paragraph("This is done using ").boldEntryLink(this.itemPath(EItems.MUTANDIS.get()), "mutandis", 5778537).then(" or ").boldEntryLink(this.itemPath(EItems.MUTANDIS_EXTREMIS.get()), "mutandis extremis", 5778537).then(".").toString())}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Mutandis", (String)FormattedStringBuilder.begin().then("Using mutandis on a block will make it start ").bold("mutating").then(", giving it a chance to turn into a different block based on nearby ").bold("mutagens").then(".").toString()), FramedImageBuilder.of(Enchanted.id("textures/gui/modopedia/mutation.png")).x(10).y(75)}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Mutagens", (String)FormattedStringBuilder.begin().bold("Mutagens").then(" are the blocks a witch needs to place in the area surrounding a mutating plant. The more mutagens you place, the more likely it is for the plant to mutate.").paragraph("The block in the center is the plant being mutated, while the surrounding blocks are its mutagens.").toString())}).page(new PageComponentBuilder[]{MutagenPageBuilder.of((Block)EBlocks.ROWAN_SAPLING.get())}).build(this.herbologyPath("mutations"), (BookOutput)output);
    }

    public void buildCircleMagicEntries(BookContentOutput output) {
        EntryBuilder.of((String)"Performing Rites").icon(EItems.CIRCLE_TALISMAN.get().getDefaultInstance()).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Performing Rites", (String)FormattedStringBuilder.begin().then("To perform circle magic, there are three basic steps a witch must follow; drawing the correct glyphs, adding foci and lastly, activating the rite.").toString()), FramedImageBuilder.of(Enchanted.id("textures/gui/modopedia/circle_magic.png")).x(10).y(80)}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Heart Glyphs", (String)FormattedStringBuilder.begin().then("Every rite starts with a heart glyph, a symbol drawn with ").boldEntryLink(this.itemPath((Item)EItems.GOLDEN_CHALK.get()), "golden chalk").then(".").paragraph("This is the center of the rite, acting as a conduit for power and being used to activate or deactivate the magic.").toString()), MultiblockBuilder.of().y(80).height(50).multiblock((Multiblock)new DenseMultiblock(List.of(List.of("G")), Map.of(Character.valueOf('G'), new SimpleStateMatcher(List.of(EBlocks.GOLDEN_CHALK.get().defaultBlockState())))))}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Glyphs and Foci", (String)FormattedStringBuilder.begin().then("After a heart glyph, rites need chalk circles, drawn using ").boldEntryLink(this.itemPath((Item)EItems.RITUAL_CHALK.get()), "ritual").then(", ").boldEntryLink(this.itemPath((Item)EItems.NETHER_CHALK.get()), "infernal").then(" or ").boldEntryLink(this.itemPath((Item)EItems.OTHERWHERE_CHALK.get()), "otherwhere").then(" chalk. ").paragraph("Foci, such as items living sacrifices, should be placed within the circles.").paragraph("When all requirements are met, the heart glyph can be activated.").toString())}).page(new PageComponentBuilder[]{RitePageBuilder.of(Enchanted.id("charging_stone"))}).build("circle_magic/tutorial/performing_rites", (BookOutput)output);
        this.riteEntry(output, "Charging Stones", EItems.ATTUNED_STONE_CHARGED.get(), EItems.ATTUNED_STONE_CHARGED.get(), FormattedStringBuilder.begin().then("Gather power to imbue an attuned stone with magical energy.").paragraph("This stone can be used for various purposes such as substituting an altar during circle magic rites.").toString(), "charging_stone");
        this.riteEntry(output, "Broomsticks", EItems.ENCHANTED_BROOMSTICK.get(), EItems.ENCHANTED_BROOMSTICK.get(), FormattedStringBuilder.begin().then("The humble ").boldEntryLink(this.itemPath(EItems.BROOM.get()), "broomstick").then(" can be imbued with the power of flight using ").boldEntryLink(this.itemPath(EItems.FLYING_OINTMENT.get()), "flying ointment").then(", creating a classic and effective means of transportation.").paragraph("The witches association recommends practicing at low altitudes.").toString(), "infuse_broom");
        this.riteEntry(output, "Familiars", (Item)EItems.ARTHANA.get(), FormattedStringBuilder.begin().then("Bind a familiar to yourself. This companion provides a variety of benefits depending on what type of creature it is. The tamed animal must be within the circle.").paragraph("The ").boldCategoryLink("familiars", "familiars").then(" chapter discusses this in greater detail.").toString(), "bind_familiar");
        this.riteEntry(output, "Talisman", EItems.CIRCLE_TALISMAN.get(), FormattedStringBuilder.begin().boldEntryLink(this.itemPath(EItems.CIRCLE_TALISMAN.get()), "Circle talismans").then(" can be used to easily pick up and move glyphs, reducing wasted chalk.").paragraph("The bound talisman can be used on the ground to place the glyphs it holds.").paragraph("Works with any and all glyphs.").toString(), "bind_talisman", "bind_talisman_charged");
        this.riteEntry(output, "Waystone", (Item)EItems.BOUND_WAYSTONE.get(), EItems.BOUND_WAYSTONE.get(), FormattedStringBuilder.begin().then("A ").boldEntryLink(this.itemPath(EItems.WAYSTONE.get()), "waystone").then(" can be bound to a location to represent it in other rites, most notably in ").boldCategoryLink("circle_magic/translocation", "translocation rites.").paragraph("The waystone will be bound to the location the rite is cast at, or duplicated from an existing waystone.").toString(), "waystone", "waystone_charged", "duplicate_waystone", "duplicate_waystone_charged");
        this.riteEntry(output, "Blooded Waystone", (Item)EItems.BLOODED_WAYSTONE.get(), EItems.BLOODED_WAYSTONE.get(), FormattedStringBuilder.begin().then("A blooded ").boldEntryLink(this.itemPath(EItems.WAYSTONE.get()), "waystone").then(", similar to a regular waystone, is bound to a location. The difference is that it is bound to the location of an entity.").paragraph("Unlike regular waystones, blooded waystones cannot be duplicated.").toString(), "waystone_blooded", "waystone_blooded_charged");
        EntryBuilder.of((String)"Casting Curses").icon(Items.WITHER_ROSE.getDefaultInstance()).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Casting Curses", (String)FormattedStringBuilder.begin().then("Curses at their core are the same as any other circle magic, however the level of the curse is increased by the skill of the caster.").paragraph("Witches with a cat familiar or those who perform the rite with a coven will be more skilled at cursing others.").toString())}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Removing Curses", (String)FormattedStringBuilder.begin().then("To remove a curse, a witch must perform the appropriate cleansing rite.").paragraph("Cleanses have a level raised in the same way as curses, making them more likely to succeed or fail. Failed removals will only make a curse stronger.").toString())}).build("circle_magic/curses/casting_curses", (BookOutput)output);
        this.riteEntry(output, "Blight", Items.SPIDER_EYE, FormattedStringBuilder.begin().then("Cause plants within a large area to wither, grass and dirt to decay, make animals sick and turn villagers into zombies.").toString(), "blight");
        this.riteEntry(output, "Misfortune", Items.ENDER_EYE, FormattedStringBuilder.begin().then("Curse the afflicted to become prone to occasionally gaining an unfortunate effect such as weakness or mining fatigue.").paragraph("The strength and duration of effects increases with the level of the curse.").toString(), "curse_misfortune");
        this.riteEntry(output, "Overheating", Items.BLAZE_POWDER, FormattedStringBuilder.begin().then("Curse the afflicted to periodically overheat and catch fire while in hot biomes.").paragraph("The duration of the flames increases with the level of the curse.").toString(), "curse_overheating");
        this.riteEntry(output, "Sinking", Items.WATER_BUCKET, FormattedStringBuilder.begin().then("Curse the afflicted to become heavier in both water and air, making it difficult to swim or fly.").paragraph("The weight of the target will increase with the level of the curse.").toString(), "curse_sinking");
        this.riteEntry(output, "Cleanse Misfortune", Items.ENDER_EYE, FormattedStringBuilder.begin().then("Cleanse the targeted being of instances of misfortune.").paragraph("If removal fails, it will bring even greater misfortune on the target.").toString(), "remove_misfortune");
        this.riteEntry(output, "Cleanse Overheating", Items.BLAZE_POWDER, FormattedStringBuilder.begin().then("Cleanse a being of their tendency to overheat in certain biomes").paragraph("If the cleansing fails, the target will grow even hotter.").toString(), "remove_overheating");
        this.riteEntry(output, "Cleanse Sinking", Items.WATER_BUCKET, FormattedStringBuilder.begin().then("Assist the afflicted in losing weight, allowing them to swim and fly as normal.").paragraph("Failing this rite will add more weight to the afflicted's shoulders.").toString(), "remove_sinking");
        this.riteEntry(output, "Broiling", Items.BEEF, FormattedStringBuilder.begin().then("Summon a ring of flames to rapidly cook all raw foods dropped within the circle.").paragraph("The heat is so intense that some food may be incinerated.").toString(), "broiling");
        this.riteEntry(output, "Fertility", Items.EMERALD, FormattedStringBuilder.begin().then("A large scale rejuvenation rite which causes plants to grow, heals sick animals and cures zombified villagers.").paragraph("The witches association recommends against liberal use of the rite of fertility following the overgrowth it leaves behind.").toString(), "fertility", "fertility_charged");
        this.riteEntry(output, "Forest", Items.OAK_SAPLING, FormattedStringBuilder.begin().then("Grow a large sea of trees around the circle, sprouting a forest even in the most desolate conditions.").paragraph("A sapling must be dropped within the circle to determine which type of tree to grow.").toString(), "forest");
        this.riteEntry(output, "Sky's Wrath", Items.LIGHTNING_ROD, FormattedStringBuilder.begin().then("Summon a concentrated thunderstorm around the edges of the circle, causing lighting to strike.").paragraph("Adding a ").boldEntryLink(this.ritePath("waystone"), "bound").then(" or ").boldEntryLink(this.ritePath("waystone_blooded"), "blooded").then(" waystone allows the caster to direct the lightning to that location.").toString(), "sky_wrath", "sky_wrath_charged", "sky_wrath_waystone", "sky_wrath_waystone_charged", "sky_wrath_blooded", "sky_wrath_blooded_charged");
        this.riteEntry(output, "Total Eclipse", Items.CLOCK, FormattedStringBuilder.begin().then("Summon the moon to cover the sky with darkness and blot out the sun.").paragraph("This rite can be useful for witches who need to perform a different magic at night.").toString(), "total_eclipse", "total_eclipse_charged");
        this.riteEntry(output, "Transpose Iron", Items.RAW_IRON, FormattedStringBuilder.begin().then("Transpose all useful iron from underneath the circle to the surface, leaving the stone behind.").paragraph("The rite will consume all ores where it is placed and must be moved after each use.").toString(), "transpose_iron");
        this.riteEntry(output, "Imprisonment", Items.IRON_BARS, FormattedStringBuilder.begin().then("Create a cage of fire, trapping monsters within the circle.").paragraph("While powerful, this barrier is certainly not impenetrable. Projectiles and teleportation can still break through it.").toString(), "imprisonment");
        this.riteEntry(output, "Protection", Items.SHIELD, FormattedStringBuilder.begin().then("Summon an impenetrable dome which can only be passed through by sneaking players.").paragraph("Adding a ").boldEntryLink(this.ritePath("waystone"), "bound waystone").then(" allows the caster to summon the dome at a different location.").toString(), "protection", "protection_large", "protection_waystone", "protection_large_waystone");
        this.riteEntry(output, "Temporary Protection", Items.SHULKER_SHELL, FormattedStringBuilder.begin().then("Summon an impenetrable dome which cannot be passed through by anything for one minute.").paragraph("Adding a ").boldEntryLink(this.ritePath("waystone"), "bound").then(" or ").boldEntryLink(this.ritePath("waystone_blooded"), "blooded").then(" waystone allows the caster to summon the dome at a different location.").toString(), "protection_temporary", "protection_temporary_waystone", "protection_temporary_blooded");
        this.riteEntry(output, "Sanctity", Items.FEATHER, FormattedStringBuilder.begin().then("Create a place of refuge within the circle, pushing mobs away and preventing them from entering.").paragraph("While strong, this barrier is not impenetrable. Projectiles and teleportation can still break through it.").toString(), "sanctity");
        this.riteEntry(output, "Summon Entity", Items.CHORUS_FRUIT, FormattedStringBuilder.begin().then("Summon the taglocked being, causing them to teleport to the casting circle. Those wearing witch hunter clothing may be unaffected.").paragraph("Unloaded or despawned entities cannot be summoned.").toString(), "summon_entity");
        this.riteEntry(output, "Summon Familiar", (Item)EItems.ARTHANA.get(), FormattedStringBuilder.begin().then("Summon the familiar bound to the caster of the rite, causing them to teleport to the casting circle.").paragraph("This rite is capable of summoning dismissed or deceased familiars.").toString(), "summon_familiar");
        this.riteEntry(output, "Transpose Caster", Items.ENDER_PEARL, FormattedStringBuilder.begin().then("Teleports the caster of the rite to the location contained within a ").boldEntryLink(this.ritePath("circle_magic/binding/waystone"), "bound").then(" or ").boldEntryLink(this.ritePath("circle_magic/binding/waystone_blooded"), "blooded").then(" waystone.").paragraph("The witches association has reported occasional instances of parts being left behind.").toString(), "transpose_caster", "transpose_caster_blooded");
    }

    public void buildPoppetryEntries(BookContentOutput output) {
        EntryBuilder.of((String)"Poppet Theory").icon(EItems.SPINNING_WHEEL.get().getDefaultInstance()).assignedItems(new Item[]{EItems.POPPET.get()}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Poppetry", (String)FormattedStringBuilder.begin().then("Poppetry is the art of creating dolls, weaving magical materials into them using a ").boldEntryLink(this.blockPath((Block)EBlocks.SPINNING_WHEEL.get()), "spinning wheel", 5778537).then(" and binding them to a living being to protect or harm them.").paragraph("For a poppet to work, it needs to be in the target being's inventory or in a").boldEntryLink(this.blockPath((Block)EBlocks.POPPET_SHELF.get()), "poppet shelf").then(".").toString())}).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)"Creating Poppets", (String)FormattedStringBuilder.begin().then("Poppets need to be weaved with other materials using a ").boldEntryLink(this.blockPath((Block)EBlocks.SPINNING_WHEEL.get()), "spinning wheel").then(" after they have been crafted to gain an effect.").toString()), CraftingRecipeBuilder.of((ResourceLocation)this.itemId(EItems.POPPET.get())).y(69)}).build(this.itemPath(EItems.POPPET.get()), (BookOutput)output);
        this.spinningEntry(output, "Sturdy Poppets", FormattedStringBuilder.begin().then("A ").bold("sturdy poppet").then(" is an upgraded ").boldEntryLink(this.itemPath(EItems.POPPET.get()), "poppet").then(" which provides additional reinforcement.").paragraph("Sturdy poppets will be able to withstand being used twice, rather than breaking after a single use.").toString(), EItems.POPPET_STURDY.get());
        this.spinningEntry(output, "Infused Poppets", FormattedStringBuilder.begin().then("An ").bold("infused poppet").then(" is an upgraded ").boldEntryLink(this.itemPath(EItems.POPPET.get()), "poppet").then(" capable of amplifying the effects of the materials woven into it.").paragraph("Infused poppets will have an additional effect applied to them when triggered.").toString(), EItems.POPPET_INFUSED.get());
        this.spinningEntry(output, "Armour", FormattedStringBuilder.begin().then("Protects a piece of wearable equipment belonging to the beneficiary when it breaks, restoring some of its durability.").paragraph("If infused, the item is instead restored to full durability.").toString(), EItems.ARMOUR_POPPET.get(), EItems.ARMOUR_POPPET_INFUSED.get(), EItems.ARMOUR_POPPET_STURDY.get());
        this.spinningEntry(output, "Earth", FormattedStringBuilder.begin().then("If the beneficiary were to take enough fall damage to die, they will instead live on one health.").paragraph("When infused, the beneficiary will also gain ").bold().tooltip("Gives immunity to fall damage", "fall resistance").stopBold().then(" for ten seconds.").toString(), EItems.EARTH_POPPET.get(), EItems.EARTH_POPPET_INFUSED.get(), EItems.EARTH_POPPET_STURDY.get());
        this.spinningEntry(output, "Fire", FormattedStringBuilder.begin().then("When the beneficiary burns to death, they will instead remain at one health and the fire will be extinguished.").paragraph("If infused, fire poppets also grant ten seconds of fire resistance.").toString(), EItems.FIRE_POPPET.get(), EItems.FIRE_POPPET_INFUSED.get(), EItems.FIRE_POPPET_STURDY.get());
        this.spinningEntry(output, "Hunger", FormattedStringBuilder.begin().then("Protects the beneficiary from starving to death. Dying of starvation will instead fill the beneficiary's stomach.").paragraph("Infused hunger poppets grant two minutes of saturation five.").toString(), EItems.HUNGER_POPPET.get(), EItems.HUNGER_POPPET_INFUSED.get(), EItems.HUNGER_POPPET_STURDY.get());
        this.spinningEntry(output, "Magic", FormattedStringBuilder.begin().then("Taking fatal magic damage will instead cause the beneficiary to survive with one health.").paragraph("When infused, it provides ").bold().tooltip("Gives immunity to magic damage", "magic resistance").stopBold().then(" for ten seconds.").toString(), EItems.MAGIC_POPPET.get(), EItems.MAGIC_POPPET_INFUSED.get(), EItems.MAGIC_POPPET_STURDY.get());
        this.spinningEntry(output, "Tool", FormattedStringBuilder.begin().then("Protects a piece of handheld equipment from destruction when it breaks, restoring some of its durability.").paragraph("When infused, tool poppets will restore the tool to full durability.").toString(), EItems.TOOL_POPPET.get(), EItems.TOOL_POPPET_INFUSED.get(), EItems.TOOL_POPPET_STURDY.get());
        this.spinningEntry(output, "Void", FormattedStringBuilder.begin().then("If the beneficiary falls into the void, a void poppet will transport them into the sky instead.").paragraph("Infused void poppets will also grant ten seconds of ").bold().tooltip("Gives immunity to fall damage", "fall resistance").toString(), EItems.VOID_POPPET.get(), EItems.VOID_POPPET_INFUSED.get(), EItems.VOID_POPPET_STURDY.get());
        this.spinningEntry(output, "Voodoo", FormattedStringBuilder.begin().then("Unlike other poppets, voodoo poppets are an effigy used to transfer damage to their target.").paragraph("Burning a voodoo poppet in fire or lava, drowning it or poking needles into it will harm the target instead.").toString(), EItems.VOODOO_POPPET.get());
        this.spinningEntry(output, "Voodoo Protection", FormattedStringBuilder.begin().then("Protects the beneficiary from voodoo poppets. When affected by a voodoo poppet, the poppet will break instead.").paragraph("If infused, the holder of the poppet will also be struck by lightning.").toString(), EItems.VOODOO_PROTECTION_POPPET.get(), EItems.VOODOO_PROTECTION_POPPET_INFUSED.get(), EItems.VOODOO_PROTECTION_POPPET_STURDY.get());
        this.spinningEntry(output, "Water", FormattedStringBuilder.begin().then("Prevents the beneficiary from drowning to death, instead leaving them at one health and granting five seconds of ").bold().tooltip("Gives immunity to drowning damage", "drown resistance").stopBold().paragraph("Infused water poppets will provide ten seconds of water breathing instead of resistance.").toString(), EItems.WATER_POPPET.get(), EItems.WATER_POPPET_INFUSED.get(), EItems.WATER_POPPET_STURDY.get());
    }

    private void galleryEntry(BookContentOutput output, String title, Item item, String description, PageComponentBuilder ... galleryComponents) {
        this.headeredTextEntry(title, description, item).page(new PageComponentBuilder[]{GalleryBuilder.of((PageComponentBuilder[])galleryComponents)}).build(this.itemPath(item), (BookOutput)output);
    }

    private void craftingEntry(BookContentOutput output, String title, String description, Item item) {
        this.craftingEntry(output, title, description, item, item);
    }

    private void cookingEntry(BookContentOutput output, String title, String description, Item item) {
        this.cookingEntry(output, title, description, item, item);
    }

    private void craftingEntry(BookContentOutput output, String title, String description, Item item, Item ... items) {
        this.headeredTextEntry(title, description, items).page(new PageComponentBuilder[]{CraftingPageBuilder.of((ResourceLocation)this.itemId(item))}).build(this.itemPath(item), (BookOutput)output);
    }

    private void cookingEntry(BookContentOutput output, String title, String description, Item item, Item ... items) {
        this.headeredTextEntry(title, description, items).page(new PageComponentBuilder[]{CookingPageBuilder.of((ResourceLocation)this.itemId(item))}).build(this.itemPath(item), (BookOutput)output);
    }

    private void blockEntry(BookContentOutput output, String title, String description, Block block, String procurement, Item ... items) {
        this.blockEntry(title, description, block.defaultBlockState(), procurement, items).build(this.blockPath(block), (BookOutput)output);
    }

    private void mutatedEntry(BookContentOutput output, String title, String description, Block result, Item ... items) {
        this.mutatedEntry(title, description, result, items).build(this.blockPath(result), (BookOutput)output);
    }

    private void blockEntry(BookContentOutput output, String title, String description, CropBlockAgeFive block, String procurement, Item ... items) {
        this.blockEntry(title, description, (BlockState)block.defaultBlockState().setValue((Property)CropBlockAgeFive.AGE_FIVE, (Comparable)Integer.valueOf(4)), procurement, items).build(this.blockPath((Block)block), (BookOutput)output);
    }

    private void cauldronEntry(BookContentOutput output, String title, Item item, String description) {
        this.headeredTextEntry(title, description, item).page(new PageComponentBuilder[]{WitchCauldronRecipeBuilder.of(Enchanted.id("witch_cauldron/" + this.itemId(item).getPath()))}).build(this.itemPath(item), (BookOutput)output);
    }

    private void kettleEntry(BookContentOutput output, String title, Item item, String description) {
        this.headeredTextEntry(title, description, item).page(new PageComponentBuilder[]{KettleRecipeBuilder.of(Enchanted.id("kettle/" + this.itemId(item).getPath()))}).build(this.itemPath(item), (BookOutput)output);
    }

    private void spinningEntry(BookContentOutput output, String title, String description, Item ... items) {
        EntryBuilder builder = EntryBuilder.of((String)title).icon(items[0].getDefaultInstance()).assignedItems(items).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)title, (String)description)});
        if (items.length > 1) {
            builder.page(new PageComponentBuilder[]{GalleryBuilder.of((PageComponentBuilder[])((PageComponentBuilder[])Arrays.stream(items).map(i -> SpinningPageBuilder.of(this.spinningRecipe((Item)i))).toArray(PageComponentBuilder[]::new)))});
        } else {
            builder.page(new PageComponentBuilder[]{SpinningPageBuilder.of(this.spinningRecipe(items[0]))});
        }
        builder.build(this.itemPath(items[0]), (BookOutput)output);
    }

    private void riteEntry(BookContentOutput output, String title, Item icon, String description, String ... rites) {
        this.riteEntry(title, icon, description, rites).build(this.ritePath(rites[0]), (BookOutput)output);
    }

    private void riteEntry(BookContentOutput output, String title, Item icon, Item assigned, String description, String ... rites) {
        this.riteEntry(title, icon, description, rites).assignedItems(new Item[]{assigned}).build(this.ritePath(rites[0]), (BookOutput)output);
    }

    private EntryBuilder riteEntry(String title, Item icon, String description, String ... rites) {
        EntryBuilder builder = EntryBuilder.of((String)title).icon(icon.getDefaultInstance()).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)title, (String)description)});
        if (rites.length > 1) {
            builder.page(new PageComponentBuilder[]{GalleryBuilder.of((PageComponentBuilder[])((PageComponentBuilder[])Arrays.stream(rites).map(s -> RitePageBuilder.of(Enchanted.id(s))).toArray(PageComponentBuilder[]::new)))});
        } else {
            builder.page(new PageComponentBuilder[]{RitePageBuilder.of(Enchanted.id(rites[0]))});
        }
        return builder;
    }

    private EntryBuilder blockEntry(String title, String description, BlockState state, String blockDescription, Item ... items) {
        return this.headeredTextEntry(title, description, items).page(new PageComponentBuilder[]{BlockPageBuilder.of((String)blockDescription, (BlockState)state)});
    }

    private EntryBuilder mutatedEntry(String title, String description, Block result, Item ... items) {
        return EntryBuilder.of((String)title).icon(items[0].getDefaultInstance()).assignedItems(items).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)title, (String)description), MultiblockBuilder.of().y(70).height(60).multiblock((Multiblock)new DenseMultiblock(List.of(List.of("S")), Map.of(Character.valueOf('S'), new SimpleStateMatcher(List.of(result.defaultBlockState()))))).noOffsets(true)}).page(new PageComponentBuilder[]{MutagenPageBuilder.of(result)});
    }

    private EntryBuilder headeredTextEntry(String title, String description, Item ... items) {
        return EntryBuilder.of((String)title).icon(items[0].getDefaultInstance()).assignedItems(items).page(new PageComponentBuilder[]{HeaderedTextBuilder.of((String)title, (String)description)});
    }

    private static <T> T[] merge(T a, T[] b) {
        return ArrayUtils.insert((int)0, (Object[])b, (Object[])new Object[]{a});
    }

    private static <T> T[] merge(T[] a, T b) {
        return ArrayUtils.insert((int)0, (Object[])a, (Object[])new Object[]{b});
    }

    private static <T> T[] merge(T[] a, T[] b) {
        return ArrayUtils.addAll((Object[])a, (Object[])b);
    }

    private PageComponentBuilder[] byproductComponents(String ... recipes) {
        ArrayList<Object> pages = new ArrayList<Object>();
        for (int i = 0; i < recipes.length; ++i) {
            if (++i < recipes.length) {
                pages.add(DoubleByproductPageBuilder.of(Enchanted.id(recipes[i - 1]), Enchanted.id(recipes[i])));
                continue;
            }
            pages.add(ByproductPageBuilder.of(Enchanted.id(recipes[i - 1])));
        }
        return (PageComponentBuilder[])pages.toArray(PageComponentBuilder[]::new);
    }

    private PageComponentBuilder[] distillingComponents(String ... recipes) {
        return (PageComponentBuilder[])Arrays.stream(recipes).map(Enchanted::id).map(DistilleryPageBuilder::of).toArray(PageComponentBuilder[]::new);
    }

    private String procureGrass() {
        return FormattedStringBuilder.begin().bold("Procurement:").linebreak("Dropped by tall and short grass").toString();
    }

    private String drops(String string) {
        return FormattedStringBuilder.begin().bold("Drops:").linebreak(string).toString();
    }

    private ResourceLocation itemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    private ResourceLocation spinningRecipe(Item item) {
        return Enchanted.id("spinning/" + this.itemId(item).getPath());
    }

    private String gettingStartedPath(String path) {
        return "getting_started/" + path;
    }

    private String brewingPath(String path) {
        return "brewing/" + path;
    }

    private String herbologyPath(String path) {
        return "herbology/" + path;
    }

    private String itemPath(Item item) {
        return "items/" + BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    private String blockPath(Block block) {
        return "blocks/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    private String ritePath(ResourceLocation rite) {
        return this.ritePath(rite.getPath());
    }

    private String ritePath(String rite) {
        return "circle_magic/rites/" + rite;
    }

    private String[] itemPaths(Item ... items) {
        return (String[])Arrays.stream(items).map(this::itemPath).toArray(String[]::new);
    }

    private String[] blockPaths(Block ... items) {
        return (String[])Arrays.stream(items).map(this::blockPath).toArray(String[]::new);
    }

    private String[] ritePaths(ResourceLocation ... rites) {
        return (String[])Arrays.stream(rites).map(this::ritePath).toArray(String[]::new);
    }

    private String[] ritePaths(String ... rites) {
        return (String[])Arrays.stream(rites).map(this::ritePath).toArray(String[]::new);
    }

    private String format(String string, Object ... vars) {
        return String.format(string, vars);
    }

    private String formatItems(String string, Item ... items) {
        return this.format(string, this.itemPaths(items));
    }

    private String formatBlocks(String string, Block ... blocks) {
        return this.format(string, this.blockPaths(blocks));
    }
}

