/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.neoforge.datagen.providers.loot_tables;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.favouriteless.enchanted.common.blocks.crops.CropBlockAgeFive;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.platform.services.NeoCommonRegistryHelper;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class EBlockLoot
extends BlockLootSubProvider {
    private final Set<Block> usedBlocks = new HashSet<Block>();

    public EBlockLoot(HolderLookup.Provider registries) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.add(EBlocks.ALDER_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)EBlocks.ALDER_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add((Block)EBlocks.ALDER_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.createCropBlockAgeFiveDrops(EBlocks.BELLADONNA.get(), (ItemLike)EItems.BELLADONNA_FLOWER.get(), (ItemLike)EItems.BELLADONNA_SEEDS.get());
        this.add(EBlocks.EMBER_MOSS.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)EItems.EMBER_MOSS.get())))));
        this.add((Block)EBlocks.GARLIC.get(), (LootTable.Builder)this.applyExplosionDecay((ItemLike)EBlocks.GARLIC.get(), (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EItems.GARLIC.get())))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EItems.GARLIC.get())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)EBlocks.GARLIC.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlockAgeFive.AGE_FIVE, 4)))).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3))))));
        this.add(EBlocks.HAWTHORN_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)EBlocks.HAWTHORN_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add((Block)EBlocks.HAWTHORN_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.createCropBlockAgeFiveDrops(EBlocks.MANDRAKE.get(), (ItemLike)EItems.MANDRAKE_ROOT.get(), (ItemLike)EItems.MANDRAKE_SEEDS.get());
        this.add(EBlocks.ROWAN_LEAVES.get(), block -> this.createFruitLeavesDrop((Block)block, (Block)EBlocks.ROWAN_SAPLING.get(), (ItemLike)EItems.ROWAN_BERRIES.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add((Block)EBlocks.ROWAN_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.createDualCropBlockAgeFiveDrops((Block)EBlocks.SNOWBELL.get(), (ItemLike)EItems.ICY_NEEDLE.get(), (ItemLike)Items.SNOWBALL, (ItemLike)EItems.SNOWBELL_SEEDS.get());
        this.add((Block)EBlocks.SPANISH_MOSS.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)EItems.SPANISH_MOSS.get())))));
        this.createCropBlockAgeFiveDrops(EBlocks.WATER_ARTICHOKE.get(), (ItemLike)EItems.WATER_ARTICHOKE.get(), (ItemLike)EItems.WATER_ARTICHOKE_SEEDS.get());
        this.createCropBlockAgeFiveDrops(EBlocks.WOLFSBANE.get(), (ItemLike)EItems.WOLFSBANE_FLOWER.get(), (ItemLike)EItems.WOLFSBANE_SEEDS.get());
        this.autoGenerateDefaults();
    }

    protected void autoGenerateDefaults() {
        for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
            if (!((ResourceKey)entry.getKey()).location().getNamespace().equals("enchanted") || ((Block)entry.getValue()).getLootTable() == BuiltInLootTables.EMPTY || this.usedBlocks.contains(entry.getValue())) continue;
            this.dropSelf((Block)entry.getValue());
        }
    }

    protected void createDualCropBlockAgeFiveDrops(Block block, ItemLike crop, ItemLike otherCrop, ItemLike seeds) {
        LootItemBlockStatePropertyCondition.Builder ageCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlockAgeFive.AGE_FIVE, 4));
        this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seeds))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)crop)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)otherCrop)).when((LootItemCondition.Builder)ageCondition)).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seeds).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float)0.1714286f, (int)3))).when((LootItemCondition.Builder)ageCondition)));
    }

    protected LootTable.Builder createFruitLeavesDrop(Block leaves, Block sapling, ItemLike fruit, float ... chances) {
        return this.createLeavesDrops(leaves, sapling, chances).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS.or(this.hasSilkTouch()).invert()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leaves, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)fruit))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected void createCropBlockAgeFiveDrops(CropBlockAgeFive block, ItemLike crop, ItemLike seeds) {
        LootItemBlockStatePropertyCondition.Builder itemCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlockAgeFive.AGE_FIVE, 4));
        this.add((Block)block, this.createCropDrops((Block)block, crop.asItem(), seeds.asItem(), (LootItemCondition.Builder)itemCondition));
    }

    protected Iterable<Block> getKnownBlocks() {
        return NeoCommonRegistryHelper.getRegistryMap().getDeferred(BuiltInRegistries.BLOCK).getEntries().stream().map(h -> (Block)h.get())::iterator;
    }

    protected void add(Block block, LootTable.Builder builder) {
        this.usedBlocks.add(block);
        super.add(block, builder);
    }
}

