/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.neoforge.datagen.providers;

import java.util.concurrent.CompletableFuture;
import net.favouriteless.enchanted.api.datagen.builders.recipe.ByproductRecipeBuilder;
import net.favouriteless.enchanted.api.datagen.builders.recipe.CauldronTypeRecipeBuilder;
import net.favouriteless.enchanted.api.datagen.builders.recipe.DistillingRecipeBuilder;
import net.favouriteless.enchanted.api.datagen.builders.recipe.SpinningRecipeBuilder;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.neoforge.datagen.builders.EShapedRecipeBuilder;
import net.favouriteless.modopedia.common.init.MDataComponents;
import net.favouriteless.modopedia.common.init.MItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ERecipeProvider
extends RecipeProvider {
    public ERecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        this.buildShapedRecipes(output, registries);
        this.buildShapelessRecipes(output, registries);
        this.buildSmeltingRecipes(output, registries);
        this.buildByproductRecipes(output, registries);
        this.buildSpinningRecipes(output, registries);
        this.buildDistillingRecipes(output, registries);
        this.buildCauldronRecipes(output, registries);
        this.buildKettleRecipes(output, registries);
    }

    protected void buildShapedRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        EShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)EItems.ALTAR.get()).pattern("bwe").pattern("srs").pattern("srs").define(Character.valueOf('s'), (ItemLike)Items.STONE_BRICKS).define(Character.valueOf('r'), (ItemLike)EItems.ROWAN_LOG.get()).define(Character.valueOf('b'), (ItemLike)EItems.BREATH_OF_THE_GODDESS.get()).define(Character.valueOf('e'), (ItemLike)EItems.EXHALE_OF_THE_HORNED_ONE.get()).define(Character.valueOf('w'), (ItemLike)Items.POTION).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, (ItemLike)EItems.ARTHANA.get()).pattern(" i ").pattern("nen").pattern(" s ").define(Character.valueOf('i'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('n'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('e'), (ItemLike)Items.EMERALD).define(Character.valueOf('s'), (ItemLike)Items.STICK).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.ATTUNED_STONE.get()).pattern("w").pattern("d").pattern("l").define(Character.valueOf('w'), (ItemLike)EItems.WHIFF_OF_MAGIC.get()).define(Character.valueOf('d'), (ItemLike)Items.DIAMOND).define(Character.valueOf('l'), (ItemLike)Items.LAVA_BUCKET).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.BROOM.get()).pattern(" s ").pattern(" s ").pattern("hhh").define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('h'), (ItemLike)EItems.HAWTHORN_SAPLING.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, (ItemLike)EItems.CANDELABRA.get()).pattern("ccc").pattern("iai").pattern(" i ").define(Character.valueOf('c'), (ItemLike)Items.CANDLE).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, (ItemLike)EItems.CHALICE.get()).pattern("nan").pattern("ngn").pattern(" g ").define(Character.valueOf('n'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('g'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, (ItemLike)EItems.RITUAL_CHALK.get()).pattern("ata").pattern("aga").pattern("aga").define(Character.valueOf('g'), (ItemLike)EItems.GYPSUM.get()).define(Character.valueOf('t'), (ItemLike)EItems.TEAR_OF_THE_GODDESS.get()).define(Character.valueOf('a'), (ItemLike)EItems.WOOD_ASH.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, (ItemLike)EItems.CIRCLE_TALISMAN.get()).pattern("ngn").pattern("gag").pattern("ngn").define(Character.valueOf('n'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('g'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.SOFT_CLAY_JAR.get(), 4).pattern(" c ").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Items.CLAY_BALL).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.DISTILLERY.get()).pattern("cic").pattern("iii").pattern("gag").define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('g'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('c'), (ItemLike)EItems.CLAY_JAR.get()).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, (ItemLike)EItems.EARMUFFS.get()).pattern(" i ").pattern("whw").define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('w'), ItemTags.WOOL).define(Character.valueOf('h'), (ItemLike)Items.LEATHER_HELMET).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.FUME_FILTER.get()).pattern("ggg").pattern("iai").pattern("ggg").define(Character.valueOf('g'), (ItemLike)Items.GLASS).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.FUME_FUNNEL.get()).pattern("blb").pattern("bgb").pattern("ifi").define(Character.valueOf('g'), (ItemLike)Items.GLOWSTONE).define(Character.valueOf('i'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('b'), (ItemLike)Items.BUCKET).define(Character.valueOf('l'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('f'), (ItemLike)Items.IRON_BARS).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.KETTLE.get()).pattern("wsw").pattern("sas").pattern(" c ").define(Character.valueOf('w'), (ItemLike)Items.STICK).define(Character.valueOf('s'), (ItemLike)Items.STRING).define(Character.valueOf('c'), (ItemLike)Items.CAULDRON).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.POPPET.get()).pattern("wmw").pattern("bms").pattern("waw").define(Character.valueOf('w'), ItemTags.WOOL).define(Character.valueOf('s'), (ItemLike)Items.STRING).define(Character.valueOf('m'), (ItemLike)EItems.SPANISH_MOSS.get()).define(Character.valueOf('b'), (ItemLike)EItems.BONE_NEEDLE.get()).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.POPPET_SHELF.get()).pattern("apa").pattern("pwp").pattern("apa").define(Character.valueOf('w'), (ItemLike)Items.GREEN_WOOL).define(Character.valueOf('p'), (ItemLike)Items.DARK_OAK_PLANKS).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.SPINNING_WHEEL.get()).pattern("wrr").pattern("srr").pattern("pap").define(Character.valueOf('w'), ItemTags.WOOL).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('a'), (ItemLike)EItems.ATTUNED_STONE.get()).define(Character.valueOf('p'), (ItemLike)EItems.ALDER_PLANKS.get()).define(Character.valueOf('r'), (ItemLike)EItems.ROWAN_STAIRS.get()).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)EItems.WICKER_BUNDLE.get()).pattern("sss").pattern("sss").pattern("sss").define(Character.valueOf('s'), ItemTags.SAPLINGS).unlockedBy("has_sapling", ERecipeProvider.has((TagKey)ItemTags.SAPLINGS)).save(output);
        EShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)EItems.WITCH_OVEN.get()).pattern(" b ").pattern("iii").pattern("ibi").define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)Items.IRON_BARS).save(output);
        ERecipeProvider.slab(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EItems.ROWAN_SLAB.get(), (ItemLike)EItems.ROWAN_PLANKS.get());
        ERecipeProvider.slab(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EItems.ALDER_SLAB.get(), (ItemLike)EItems.ALDER_PLANKS.get());
        ERecipeProvider.slab(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EItems.HAWTHORN_SLAB.get(), (ItemLike)EItems.HAWTHORN_PLANKS.get());
        ERecipeProvider.stairs(output, (ItemLike)EItems.ROWAN_STAIRS.get(), (ItemLike)EItems.ROWAN_PLANKS.get());
        ERecipeProvider.stairs(output, (ItemLike)EItems.ALDER_STAIRS.get(), (ItemLike)EItems.ALDER_PLANKS.get());
        ERecipeProvider.stairs(output, (ItemLike)EItems.HAWTHORN_STAIRS.get(), (ItemLike)EItems.HAWTHORN_PLANKS.get());
        ERecipeProvider.pressurePlate(output, (ItemLike)EItems.ALDER_PRESSURE_PLATE.get(), (ItemLike)EItems.ALDER_PLANKS.get());
        ERecipeProvider.pressurePlate(output, (ItemLike)EItems.HAWTHORN_PRESSURE_PLATE.get(), (ItemLike)EItems.HAWTHORN_PLANKS.get());
        ERecipeProvider.pressurePlate(output, (ItemLike)EItems.ROWAN_PRESSURE_PLATE.get(), (ItemLike)EItems.ROWAN_PLANKS.get());
        ERecipeProvider.fence(output, (ItemLike)EItems.ALDER_FENCE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.ALDER_PLANKS.get()}));
        ERecipeProvider.fence(output, (ItemLike)EItems.HAWTHORN_FENCE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.HAWTHORN_PLANKS.get()}));
        ERecipeProvider.fence(output, (ItemLike)EItems.ROWAN_FENCE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.ROWAN_PLANKS.get()}));
        ERecipeProvider.fenceGate(output, (ItemLike)EItems.ALDER_FENCE_GATE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.ALDER_PLANKS.get()}));
        ERecipeProvider.fenceGate(output, (ItemLike)EItems.HAWTHORN_FENCE_GATE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.HAWTHORN_PLANKS.get()}));
        ERecipeProvider.fenceGate(output, (ItemLike)EItems.ROWAN_FENCE_GATE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.ROWAN_PLANKS.get()}));
    }

    protected void buildShapelessRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.ANOINTING_PASTE.get())).requires((ItemLike)EItems.WATER_ARTICHOKE_SEEDS.get()).requires((ItemLike)EItems.MANDRAKE_SEEDS.get()).requires((ItemLike)EItems.BELLADONNA_SEEDS.get()).requires((ItemLike)EItems.SNOWBELL_SEEDS.get()).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.BELLADONNA_SEEDS.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.BELLADONNA_SEEDS.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.BONE_NEEDLE.get()), (int)8).requires((ItemLike)Items.FLINT).requires((ItemLike)Items.BONE).unlockedBy(ERecipeProvider.getHasName((ItemLike)Items.BONE), ERecipeProvider.has((ItemLike)Items.BONE)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.PURIFIED_MILK.get())).requires((ItemLike)Items.MILK_BUCKET).requires((ItemLike)EItems.ODOUR_OF_PURITY.get()).requires((ItemLike)EItems.CLAY_JAR.get(), 3).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.ODOUR_OF_PURITY.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.ODOUR_OF_PURITY.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.TAGLOCK.get())).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)EItems.BONE_NEEDLE.get()).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.BONE_NEEDLE.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.BONE_NEEDLE.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.WAYSTONE.get())).requires((ItemLike)Items.FLINT).requires((ItemLike)EItems.BONE_NEEDLE.get()).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.BONE_NEEDLE.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.BONE_NEEDLE.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.CHALICE_FILLED.get())).requires((ItemLike)EItems.CHALICE.get()).requires((ItemLike)EItems.REDSTONE_SOUP.get()).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.CHALICE.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.CHALICE.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BONE_MEAL, (int)4).requires((ItemLike)EItems.WOOD_ASH.get(), 2).requires((ItemLike)Items.BONE).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.WOOD_ASH.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.WOOD_ASH.get()))).save(output);
        ERecipeProvider.buttonBuilder((ItemLike)((ItemLike)EItems.ALDER_BUTTON.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.ALDER_PLANKS.get()})).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.ALDER_PLANKS.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.ALDER_PLANKS.get()))).save(output);
        ERecipeProvider.buttonBuilder((ItemLike)((ItemLike)EItems.HAWTHORN_BUTTON.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.HAWTHORN_PLANKS.get()})).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.HAWTHORN_PLANKS.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.HAWTHORN_PLANKS.get()))).save(output);
        ERecipeProvider.buttonBuilder((ItemLike)((ItemLike)EItems.ROWAN_BUTTON.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.ROWAN_PLANKS.get()})).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.ROWAN_PLANKS.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.ROWAN_PLANKS.get()))).save(output);
        ERecipeProvider.planksFromLog((RecipeOutput)output, (ItemLike)((ItemLike)EItems.ALDER_PLANKS.get()), ETags.Items.ALDER_LOGS, (int)4);
        ERecipeProvider.planksFromLog((RecipeOutput)output, (ItemLike)((ItemLike)EItems.HAWTHORN_PLANKS.get()), ETags.Items.HAWTHORN_LOGS, (int)4);
        ERecipeProvider.planksFromLog((RecipeOutput)output, (ItemLike)((ItemLike)EItems.ROWAN_PLANKS.get()), ETags.Items.ROWAN_LOGS, (int)4);
        ItemStack book = new ItemStack((ItemLike)MItems.BOOK.get());
        book.set(MDataComponents.BOOK, (Object)Enchanted.id("art_of_witchcraft"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemStack)book).requires((ItemLike)Items.INK_SAC).requires((ItemLike)Items.BOOK).requires((ItemLike)Items.FEATHER).requires((ItemLike)EItems.BELLADONNA_SEEDS.get()).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.BELLADONNA_SEEDS.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.BELLADONNA_SEEDS.get()))).save(output, Enchanted.id("art_of_witchcraft"));
    }

    protected void buildSmeltingRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.SOFT_CLAY_JAR.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.CLAY_JAR.get()), (float)0.1f, (int)200).unlockedBy(ERecipeProvider.getHasName((ItemLike)((ItemLike)EItems.SOFT_CLAY_JAR.get())), ERecipeProvider.has((ItemLike)((ItemLike)EItems.SOFT_CLAY_JAR.get()))).save(output);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((TagKey)ItemTags.SAPLINGS), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.WOOD_ASH.get()), (float)0.1f, (int)150).unlockedBy("has_sapling", ERecipeProvider.has((TagKey)ItemTags.SAPLINGS)).save(output);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.CALCITE}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EItems.QUICKLIME.get()), (float)0.1f, (int)200).unlockedBy(ERecipeProvider.getHasName((ItemLike)Items.CALCITE), ERecipeProvider.has((ItemLike)Items.CALCITE)).save(output);
    }

    protected void buildByproductRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.BREATH_OF_THE_GODDESS.get()), new ItemLike[]{Items.BIRCH_SAPLING});
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.EXHALE_OF_THE_HORNED_ONE.get()), new ItemLike[]{Items.OAK_SAPLING});
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.FOUL_FUME.get()), new ItemLike[]{Items.JUNGLE_SAPLING});
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.FOUL_FUME.get()), (TagKey<Item>)ItemTags.LOGS_THAT_BURN);
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.FOUL_FUME.get()), ETags.Items.RAW_FOODS);
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.HINT_OF_REBIRTH.get()), new ItemLike[]{Items.SPRUCE_SAPLING});
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.ODOUR_OF_PURITY.get()), (ItemLike)EItems.HAWTHORN_SAPLING.get());
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.REEK_OF_MISFORTUNE.get()), (ItemLike)EItems.ALDER_SAPLING.get());
        ERecipeProvider.byproduct(output, new ItemStack((ItemLike)EItems.WHIFF_OF_MAGIC.get()), (ItemLike)EItems.ROWAN_SAPLING.get());
    }

    protected void buildSpinningRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        ERecipeProvider.spinning(output, (ItemLike)EItems.POPPET_INFUSED.get(), (ItemLike)EItems.POPPET.get(), EItems.ATTUNED_STONE.get(), Items.ENDER_PEARL);
        ERecipeProvider.spinning(output, (ItemLike)EItems.POPPET_STURDY.get(), (ItemLike)EItems.POPPET.get(), EItems.HINT_OF_REBIRTH.get(), Items.SHIELD);
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.ARMOUR_POPPET.get(), (ItemLike)EItems.ARMOUR_POPPET_INFUSED.get(), (ItemLike)EItems.ARMOUR_POPPET_STURDY.get(), EItems.HINT_OF_REBIRTH.get(), Items.DIAMOND_BOOTS);
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.EARTH_POPPET.get(), (ItemLike)EItems.EARTH_POPPET_INFUSED.get(), (ItemLike)EItems.EARTH_POPPET_STURDY.get(), new ItemStack((ItemLike)EItems.MANDRAKE_ROOT.get()), PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_SLOW_FALLING));
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.FIRE_POPPET.get(), (ItemLike)EItems.FIRE_POPPET_INFUSED.get(), (ItemLike)EItems.FIRE_POPPET_STURDY.get(), new ItemStack((ItemLike)EItems.EMBER_MOSS.get()), PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_FIRE_RESISTANCE));
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.HUNGER_POPPET.get(), (ItemLike)EItems.HUNGER_POPPET_INFUSED.get(), (ItemLike)EItems.HUNGER_POPPET_STURDY.get(), EItems.ROWAN_BERRIES.get(), Items.ROTTEN_FLESH);
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.TOOL_POPPET.get(), (ItemLike)EItems.TOOL_POPPET_INFUSED.get(), (ItemLike)EItems.TOOL_POPPET_STURDY.get(), EItems.HINT_OF_REBIRTH.get(), Items.DIAMOND_SWORD);
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.VOID_POPPET.get(), (ItemLike)EItems.VOID_POPPET_INFUSED.get(), (ItemLike)EItems.VOID_POPPET_STURDY.get(), (Item)EItems.OTHERWHERE_CHALK.get(), EItems.ENDER_DEW.get());
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.WATER_POPPET.get(), (ItemLike)EItems.WATER_POPPET_INFUSED.get(), (ItemLike)EItems.WATER_POPPET_STURDY.get(), new ItemStack((ItemLike)EItems.WATER_ARTICHOKE.get()), PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_WATER_BREATHING));
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.MAGIC_POPPET.get(), (ItemLike)EItems.MAGIC_POPPET_INFUSED.get(), (ItemLike)EItems.MAGIC_POPPET_STURDY.get(), new ItemStack((ItemLike)EItems.ANOINTING_PASTE.get()), PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.STRONG_HARMING));
        ERecipeProvider.spinningSet(output, (ItemLike)EItems.VOODOO_PROTECTION_POPPET.get(), (ItemLike)EItems.VOODOO_PROTECTION_POPPET_INFUSED.get(), (ItemLike)EItems.VOODOO_PROTECTION_POPPET_STURDY.get(), new ItemStack((ItemLike)EItems.BONE_NEEDLE.get()), PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.STRONG_HEALING));
        ERecipeProvider.spinning(output, (ItemLike)EItems.VOODOO_POPPET.get(), (ItemLike)EItems.POPPET_INFUSED.get(), EItems.BONE_NEEDLE.get(), EItems.BREW_OF_THE_GROTESQUE.get());
    }

    protected void buildDistillingRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        DistillingRecipeBuilder.create(new ItemStack((ItemLike)EItems.CLAY_JAR.get(), 3), new ItemStack((ItemLike)EItems.BREATH_OF_THE_GODDESS.get()), new ItemStack((ItemLike)Items.LAPIS_LAZULI)).results(new ItemLike[]{(ItemLike)EItems.TEAR_OF_THE_GODDESS.get(), (ItemLike)EItems.WHIFF_OF_MAGIC.get(), Items.SLIME_BALL, (ItemLike)EItems.FOUL_FUME.get()}).save(output);
        DistillingRecipeBuilder.create(new ItemStack((ItemLike)EItems.CLAY_JAR.get(), 2), new ItemStack((ItemLike)EItems.DEMON_HEART.get()), new ItemStack((ItemLike)EItems.DIAMOND_VAPOUR.get())).results(new ItemStack((ItemLike)EItems.DEMONIC_BLOOD.get(), 2)).results((ItemLike)EItems.REFINED_EVIL.get()).save(output);
        DistillingRecipeBuilder.create(new ItemStack((ItemLike)EItems.CLAY_JAR.get(), 3), new ItemStack((ItemLike)Items.DIAMOND), new ItemStack((ItemLike)EItems.OIL_OF_VITRIOL.get())).results(new ItemStack((ItemLike)EItems.DIAMOND_VAPOUR.get(), 2)).results((ItemLike)EItems.ODOUR_OF_PURITY.get()).save(output);
        DistillingRecipeBuilder.create(new ItemLike[]{(ItemLike)EItems.CLAY_JAR.get(), (ItemLike)EItems.DIAMOND_VAPOUR.get(), Items.BLAZE_ROD}).results((ItemLike)EItems.DEMONIC_BLOOD.get()).save(output);
        DistillingRecipeBuilder.create(new ItemStack((ItemLike)EItems.CLAY_JAR.get(), 3), new ItemStack((ItemLike)EItems.DIAMOND_VAPOUR.get()), new ItemStack((ItemLike)Items.GHAST_TEAR)).results((ItemLike)EItems.ODOUR_OF_PURITY.get(), (ItemLike)EItems.REEK_OF_MISFORTUNE.get(), (ItemLike)EItems.FOUL_FUME.get(), (ItemLike)EItems.REFINED_EVIL.get()).save(output);
        DistillingRecipeBuilder.create(new ItemStack((ItemLike)EItems.CLAY_JAR.get(), 6), new ItemStack((ItemLike)Items.ENDER_PEARL)).results(new ItemStack((ItemLike)EItems.ENDER_DEW.get(), 5)).results((ItemLike)EItems.WHIFF_OF_MAGIC.get()).save(output);
        DistillingRecipeBuilder.create((ItemLike)EItems.CLAY_JAR.get(), (ItemLike)EItems.FOUL_FUME.get(), (ItemLike)EItems.QUICKLIME.get()).results(new ItemLike[]{(ItemLike)EItems.GYPSUM.get(), (ItemLike)EItems.OIL_OF_VITRIOL.get(), Items.SLIME_BALL}).save(output);
    }

    protected void buildCauldronRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        CauldronTypeRecipeBuilder.cauldron(new ItemStack((ItemLike)EItems.GOLDEN_CHALK.get()), 3000).inputs(new ItemLike[]{(ItemLike)EItems.MANDRAKE_ROOT.get(), Items.GOLD_NUGGET, (ItemLike)EItems.RITUAL_CHALK.get()}).cookColor(5849088).finalColor(12753664).save(output);
        CauldronTypeRecipeBuilder.cauldron(new ItemStack((ItemLike)EItems.OTHERWHERE_CHALK.get()), 2000).inputs(new ItemLike[]{Items.NETHER_WART, (ItemLike)EItems.TEAR_OF_THE_GODDESS.get(), Items.ENDER_PEARL, (ItemLike)EItems.RITUAL_CHALK.get()}).cookColor(3216714).finalColor(4787586).save(output);
        CauldronTypeRecipeBuilder.cauldron(new ItemStack((ItemLike)EItems.NETHER_CHALK.get()), 2000).inputs(new ItemLike[]{Items.NETHER_WART, Items.BLAZE_POWDER, (ItemLike)EItems.RITUAL_CHALK.get()}).cookColor(5505306).finalColor(10223919).save(output);
        CauldronTypeRecipeBuilder.cauldron(new ItemStack((ItemLike)EItems.DROP_OF_LUCK.get()), 7000).inputs(new ItemLike[]{(ItemLike)EItems.MANDRAKE_ROOT.get(), Items.NETHER_WART, (ItemLike)EItems.TEAR_OF_THE_GODDESS.get(), (ItemLike)EItems.REFINED_EVIL.get(), (ItemLike)EItems.MUTANDIS_EXTREMIS.get()}).cookColor(17687).finalColor(29991).save(output);
        CauldronTypeRecipeBuilder.cauldron(new ItemStack((ItemLike)EItems.MUTANDIS.get(), 6), 0).inputs(new ItemLike[]{(ItemLike)EItems.MANDRAKE_ROOT.get(), (ItemLike)EItems.EXHALE_OF_THE_HORNED_ONE.get(), Items.EGG}).cookColor(1722147).finalColor(4096078).save(output);
        CauldronTypeRecipeBuilder.cauldron(new ItemStack((ItemLike)EItems.MUTANDIS_EXTREMIS.get()), 7000).inputs(new ItemLike[]{(ItemLike)EItems.MUTANDIS.get(), Items.NETHER_WART}).cookColor(5511192).finalColor(8396061).save(output);
    }

    protected void buildKettleRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.BREW_OF_LOVE.get(), 3), 0).inputs(new ItemLike[]{Items.POPPY, Items.GOLDEN_CARROT, Items.LILY_PAD, Items.COCOA_BEANS, (ItemLike)EItems.WHIFF_OF_MAGIC.get(), (ItemLike)EItems.WATER_ARTICHOKE.get()}).cookColor(11552421).finalColor(16224235).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.BREW_OF_SPROUTING.get(), 3), 0).inputs(new ItemLike[]{(ItemLike)EItems.ROWAN_SAPLING.get(), (ItemLike)EItems.TONGUE_OF_DOG.get(), (ItemLike)EItems.ALDER_SAPLING.get(), (ItemLike)EItems.MANDRAKE_ROOT.get(), (ItemLike)EItems.HAWTHORN_SAPLING.get(), Items.POPPY}).cookColor(6044694).finalColor(8411691).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.BREW_OF_THE_DEPTHS.get(), 3), 0).inputs(new ItemLike[]{Items.LILY_PAD, Items.INK_SAC, (ItemLike)EItems.MANDRAKE_ROOT.get(), (ItemLike)EItems.TEAR_OF_THE_GODDESS.get(), (ItemLike)EItems.WATER_ARTICHOKE.get(), (ItemLike)EItems.ODOUR_OF_PURITY.get()}).cookColor(1601192).finalColor(5552854).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.BREW_OF_THE_GROTESQUE.get(), 3), 750).inputs(new ItemLike[]{(ItemLike)EItems.MUTANDIS_EXTREMIS.get(), (ItemLike)EItems.MANDRAKE_ROOT.get(), (ItemLike)EItems.WATER_ARTICHOKE.get(), Items.GOLDEN_APPLE, (ItemLike)EItems.TONGUE_OF_DOG.get(), Items.POISONOUS_POTATO}).cookColor(3549729).finalColor(8412998).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.FLYING_OINTMENT.get()), 3000).inputs((ItemLike)EItems.REDSTONE_SOUP.get()).inputs(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_SWIFTNESS)).inputs(new ItemLike[]{Items.DIAMOND, Items.FEATHER, (ItemLike)EItems.WOOL_OF_BAT.get(), (ItemLike)EItems.BELLADONNA_FLOWER.get()}).cookColor(7366165).finalColor(14403370).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.HAPPENSTANCE_OIL.get()), 2000).inputs((ItemLike)EItems.REDSTONE_SOUP.get()).inputs(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_NIGHT_VISION)).inputs(new ItemLike[]{Items.ENDER_EYE, Items.GOLDEN_CARROT, Items.SPIDER_EYE, (ItemLike)EItems.MANDRAKE_ROOT.get()}).cookColor(3280750).finalColor(5511864).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.MYSTIC_UNGUENT.get()), 3000).inputs((ItemLike)EItems.REDSTONE_SOUP.get()).inputs(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.STRONG_STRENGTH)).inputs(new ItemLike[]{Items.DIAMOND, (ItemLike)EItems.ROWAN_SAPLING.get(), (ItemLike)EItems.CREEPER_HEART.get(), (ItemLike)EItems.DEMONIC_BLOOD.get()}).cookColor(1585174).finalColor(1859094).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.REDSTONE_SOUP.get()), 1000).inputs(new ItemLike[]{Items.REDSTONE, (ItemLike)EItems.DROP_OF_LUCK.get(), (ItemLike)EItems.WOOL_OF_BAT.get(), (ItemLike)EItems.TONGUE_OF_DOG.get(), (ItemLike)EItems.BELLADONNA_FLOWER.get(), (ItemLike)EItems.MANDRAKE_ROOT.get()}).cookColor(8396311).finalColor(14561565).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.SOUL_OF_THE_WORLD.get(), 2), 4000).inputs((ItemLike)EItems.REDSTONE_SOUP.get()).inputs(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_REGENERATION)).inputs(new ItemLike[]{(ItemLike)EItems.ROWAN_SAPLING.get(), (ItemLike)EItems.ATTUNED_STONE.get(), (ItemLike)EItems.MANDRAKE_ROOT.get(), Items.GOLDEN_APPLE}).cookColor(875545).finalColor(629023).save(output);
        CauldronTypeRecipeBuilder.kettle(new ItemStack((ItemLike)EItems.SPIRIT_OF_OTHERWHERE.get(), 2), 4000).inputs((ItemLike)EItems.REDSTONE_SOUP.get()).inputs(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_SWIFTNESS)).inputs(new ItemLike[]{(ItemLike)EItems.WOOL_OF_BAT.get(), Items.ENDER_EYE, Items.ENDER_EYE, (ItemLike)EItems.DROP_OF_LUCK.get()}).cookColor(3085893).finalColor(5117568).save(output);
    }

    protected static void spinning(RecipeOutput output, ItemLike result, ItemLike first, Item second, Item third) {
        SpinningRecipeBuilder.create(result, new ItemLike[]{first, second, third}).power(500).save(output);
    }

    protected static void spinningSet(RecipeOutput output, ItemLike normal, ItemLike infused, ItemLike sturdy, Item second, Item third) {
        SpinningRecipeBuilder.create(normal, new ItemLike[]{(ItemLike)EItems.POPPET.get(), second, third}).power(500).save(output);
        SpinningRecipeBuilder.create(infused, new ItemLike[]{(ItemLike)EItems.POPPET_INFUSED.get(), second, third}).power(1000).save(output);
        SpinningRecipeBuilder.create(sturdy, new ItemLike[]{(ItemLike)EItems.POPPET_STURDY.get(), second, third}).power(1000).save(output);
    }

    protected static void spinningSet(RecipeOutput output, ItemLike normal, ItemLike infused, ItemLike sturdy, ItemStack second, ItemStack third) {
        SpinningRecipeBuilder.create(normal, EItems.POPPET.get().getDefaultInstance(), second, third).power(500).save(output);
        SpinningRecipeBuilder.create(infused, EItems.POPPET_INFUSED.get().getDefaultInstance(), second, third).power(1000).save(output);
        SpinningRecipeBuilder.create(sturdy, EItems.POPPET_STURDY.get().getDefaultInstance(), second, third).power(1000).save(output);
    }

    protected static void byproduct(RecipeOutput output, ItemStack result, ItemLike ... items) {
        ByproductRecipeBuilder.create(result, items).save(output);
    }

    protected static void byproduct(RecipeOutput output, ItemStack result, ItemStack ... items) {
        ByproductRecipeBuilder.create(result, items).save(output);
    }

    protected static void byproduct(RecipeOutput output, ItemStack result, TagKey<Item> items) {
        ByproductRecipeBuilder.create(result, items).save(output);
    }

    protected static void slab(RecipeOutput output, RecipeCategory category, ItemLike slab, ItemLike material) {
        EShapedRecipeBuilder.shaped(category, slab, 6).define(Character.valueOf('#'), material).pattern("###").save(output);
    }

    protected static void stairs(RecipeOutput output, ItemLike stairs, ItemLike material) {
        EShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, stairs, 4).define(Character.valueOf('#'), material).pattern("#  ").pattern("## ").pattern("###").save(output);
    }

    protected static void pressurePlate(RecipeOutput output, ItemLike pressurePlate, ItemLike material) {
        EShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, pressurePlate).define(Character.valueOf('#'), material).pattern("##").save(output);
    }

    protected static void fence(RecipeOutput output, ItemLike fence, Ingredient material) {
        EShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, fence, fence == Blocks.NETHER_BRICK_FENCE ? 6 : 3).define(Character.valueOf('W'), material).define(Character.valueOf('#'), (ItemLike)(fence == Blocks.NETHER_BRICK_FENCE ? Items.NETHER_BRICK : Items.STICK)).pattern("W#W").pattern("W#W").save(output);
    }

    protected static void fenceGate(RecipeOutput output, ItemLike fenceGate, Ingredient material) {
        EShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, fenceGate).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), material).pattern("#W#").pattern("#W#").save(output);
    }
}

