/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.neoforge.datagen.providers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EEntityTypes;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.util.LangUtils;
import net.favouriteless.modopedia.api.text.FormattedStringBuilder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class ELanguageProvider
extends LanguageProvider {
    public static final Set<String> lowerCaseWords = Set.of("of", "the", "and");
    private final Set<String> usedKeys = new HashSet<String>();

    public ELanguageProvider(PackOutput output) {
        super(output, "enchanted", "en_us");
    }

    protected void addTranslations() {
        this.add(LangUtils.tab("main"), "Enchanted");
        this.add(LangUtils.item("bound_waystone.not_bound"), "Not bound");
        this.add("death.attack.enchanted.sacrifice", "%1$s was sacrificed.");
        this.add("death.attack.enchanted.sound", "%1$s had their eardrums pierced.");
        this.add("death.attack.enchanted.voodoo", "%1$s died mysteriously.");
        this.addBlock(EBlocks.CHALICE_FILLED, "Chalice (Filled)");
        this.addBlock(EBlocks.FUME_FUNNEL_FILTERED, "Fume Funnel (Filtered)");
        this.addBlock(EBlocks.WITCH_CAULDRON, "Witch's Cauldron");
        this.addBlock(EBlocks.WITCH_OVEN, "Witch's Oven");
        this.addItem(EItems.EXHALE_OF_THE_HORNED_ONE, "Horned One's Exhale");
        this.addItem(EItems.ATTUNED_STONE_CHARGED, "Attuned Stone (Charged)");
        this.addEntityType(EEntityTypes.FAMILIAR_CAT, "Cat (Familiar)");
        this.addJei(EItems.CHALICE_FILLED, "Right click on a chalice using redstone soup");
        this.addJei(EItems.WITCH_CAULDRON, "Right click on a cauldron using anointing Paste");
        this.addJei(EItems.FUME_FUNNEL_FILTERED, "Right click on a fume funnel using a fume filter");
        this.addJeiCategory("circle_magic", "Circle Magic");
        this.addJeiCategory("kettle", "Kettle");
        this.addJeiCategory("witch_cauldron", "Witch's Cauldron");
        this.addJeiCategory("mutandis", "Mutandis");
        this.addJeiCategory("mutandis_extremis", "Mutandis Extremis");
        this.addJei("mutandis.description", "Use mutandis to transmute plants.");
        this.addJei("arthana.bat", "Obtained by killing a bat with an arthana. Looting increases the odds.");
        this.addJei("arthana.wolf", "Obtained by killing a wolf with an arthana. Looting increases the odds.");
        this.addJei("arthana.creeper", "Obtained by killing a creeper with an arthana. Looting increases the odds.");
        this.addContainer(EBlocks.ALTAR, "Altar");
        this.addContainer(EBlocks.DISTILLERY, "Distillery");
        this.addContainer(EBlocks.KETTLE, "Kettle");
        this.addContainer(EBlocks.WITCH_CAULDRON, "Witch's Cauldron");
        this.addContainer(EBlocks.POPPET_SHELF, "Poppet Shelf");
        this.addContainer(EBlocks.SPINNING_WHEEL, "Spinning Wheel");
        this.addContainer(EBlocks.WITCH_OVEN, "Witch's Oven");
        this.addCircleShape("small_circle", "Small Circle");
        this.addCircleShape("medium_circle", "Medium Circle");
        this.addCircleShape("large_circle", "Large Circle");
        this.addRite("bind_familiar", "Rite of Binding");
        this.addRite("bind_talisman", "Rite of Binding");
        this.addRite("bind_talisman_charged", "Rite of Binding");
        this.addRite("blight", "Curse of Blight");
        this.addRite("broiling", "Rite of Broiling");
        this.addRite("broiling_charged", "Rite of Broiling");
        this.addRite("charging_stone", "Rite of Charging");
        this.addRite("curse_misfortune", "Curse of Misfortune");
        this.addRite("curse_overheating", "Curse of Overheating");
        this.addRite("curse_sinking", "Curse of Sinking");
        this.addRite("duplicate_waystone", "Rite of Binding");
        this.addRite("duplicate_waystone_charged", "Rite of Binding");
        this.addRite("fertility", "Rite of Fertility");
        this.addRite("fertility_charged", "Rite of Fertility");
        this.addRite("forest", "Rite of Forest");
        this.addRite("imprisonment", "Rite of Imprisonment");
        this.addRite("infuse_broom", "Rite of Infusion");
        this.addRite("protection", "Rite of Protection");
        this.addRite("protection_waystone", "Rite of Protection");
        this.addRite("protection_large", "Rite of Protection");
        this.addRite("protection_large_waystone", "Rite of Protection");
        this.addRite("protection_temporary", "Rite of Protection");
        this.addRite("protection_temporary_blooded", "Rite of Protection");
        this.addRite("protection_temporary_waystone", "Rite of Protection");
        this.addRite("remove_misfortune", "Rite of Curse Removal");
        this.addRite("remove_overheating", "Rite of Curse Removal");
        this.addRite("remove_sinking", "Rite of Curse Removal");
        this.addRite("sanctity", "Rite of Sanctity");
        this.addRite("sky_wrath", "Rite of Sky's Wrath");
        this.addRite("sky_wrath_charged", "Rite of Sky's Wrath");
        this.addRite("sky_wrath_blooded", "Rite of Sky's Wrath");
        this.addRite("sky_wrath_blooded_charged", "Rite of Sky's Wrath");
        this.addRite("sky_wrath_waystone", "Rite of Sky's Wrath");
        this.addRite("sky_wrath_waystone_charged", "Rite of Sky's Wrath");
        this.addRite("summon_entity", "Rite of Summoning");
        this.addRite("summon_familiar", "Rite of Summoning");
        this.addRite("total_eclipse", "Rite of Total Eclipse");
        this.addRite("total_eclipse_charged", "Rite of Total Eclipse");
        this.addRite("transpose_caster_blooded", "Rite of Transposition");
        this.addRite("transpose_caster", "Rite of Transposition");
        this.addRite("transpose_iron", "Rite of Transposition");
        this.addRite("waystone", "Rite of Binding");
        this.addRite("waystone_charged", "Rite of Binding");
        this.addRite("waystone_blooded", "Rite of Binding");
        this.addRite("waystone_blooded_charged", "Rite of Binding");
        this.addBookTitle("art_of_witchcraft", "Art of Witchcraft");
        this.addBookSubtitle("art_of_witchcraft", "A guide to magic");
        this.addBookLandingText("art_of_witchcraft", FormattedStringBuilder.begin().bold("Witchcraft").then(" is the art of bringing out and using the magical effects of seemingly mundane objects.").paragraph("This book aims to explain the various schools of witchcraft.").toString());
        this.addBookHeader("fume_extraction", "Fume Extraction");
        this.addBookHeader("distillation", "Distillation");
        this.addBookHeader("witch_cauldron_recipe", "Cauldron Recipe");
        this.addBookHeader("kettle_recipe", "Kettle Recipe");
        this.addBookHeader("mutagen_info", "Mutation");
        this.addBookHeader("circle_magic", "Circle Magic");
        this.addBookHeader("weaving", "Weaving");
        this.addTooltip("byproduct_recipe", "Byproduct Recipe");
        this.addTooltip("altar_power", "%1$s Altar Power");
        this.addTooltip("mutagen_weight", "Weight");
        this.addTooltip("mutee", "Mutee:");
        this.addTooltip("mutagens", "Mutagens:");
        this.addTooltip("mutagen_extremis", "Extremis");
        this.addTooltip("disabled_totems", "Disabled (Enchanted: Witchcraft)");
        this.addTooltip("rite_requirement.shapes", "Requires glyphs:");
        this.addTooltip("rite_requirement.time_range", "Must be cast between %1$s and %2$s");
        this.addTooltip("rite_requirement.power", "Requires %1$s power");
        this.addTooltip("rite_requirement.power_tick", "Requires %1$s power per tick");
        this.addTooltip("rite_requirement.weather", "Requires weather:");
        this.addTooltip("rite_requirement.sacrifice", "Requires sacrifices:");
        this.addTooltip("rite_requirement.weather.clear", "Clear");
        this.addTooltip("rite_requirement.weather.raining", "Raining");
        this.addTooltip("rite_requirement.weather.thundering", "Thundering");
        this.add(LangUtils.key("taglock", "failed"), "Taglock attempt failed");
        this.add(LangUtils.key("taglock", "failed.player"), "%1$s tried to taglock you");
        this.autoGenerateAll();
    }

    protected void addContainer(Supplier<? extends Block> block, String value) {
        this.add(LangUtils.key("container", BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath()), value);
    }

    protected void addRite(String key, String value) {
        this.add(LangUtils.rite(key), value);
    }

    protected void addCircleShape(String shape, String value) {
        this.add(LangUtils.circleShape(shape), value);
    }

    protected void addBookTitle(String key, String value) {
        this.add(LangUtils.bookTitle(key), value);
    }

    protected void addBookSubtitle(String key, String value) {
        this.add(LangUtils.bookSubtitle(key), value);
    }

    protected void addBookHeader(String key, String value) {
        this.add(LangUtils.bookHeader(key), value);
    }

    protected void addBookLandingText(String key, String value) {
        this.add(LangUtils.bookLandingText(key), value);
    }

    protected void addJeiCategory(String key, String value) {
        this.add(LangUtils.jeiCategory(key), value);
    }

    protected void addJei(String key, String value) {
        this.add(LangUtils.jei(key), value);
    }

    protected void addJei(Supplier<? extends Item> item, String value) {
        this.add(LangUtils.jei(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath()), value);
    }

    protected void addTooltip(String suffix, String value) {
        this.add(LangUtils.tooltip(suffix), value);
    }

    protected void autoGenerateAll() {
        this.autoGenerate((Registry)BuiltInRegistries.BLOCK, (Function)Block::getDescriptionId);
        this.autoGenerate((Registry)BuiltInRegistries.ITEM, (Function)Item::getDescriptionId);
        this.autoGenerate((Registry)BuiltInRegistries.ENTITY_TYPE, (Function)EntityType::getDescriptionId);
        this.autoGenerate(BuiltInRegistries.MOB_EFFECT, MobEffect::getDescriptionId);
    }

    protected <T> void autoGenerate(Registry<T> registry, Function<T, String> idGetter) {
        for (Map.Entry entry : registry.entrySet()) {
            String id;
            if (!((ResourceKey)entry.getKey()).location().getNamespace().equals("enchanted") || this.usedKeys.contains(id = idGetter.apply(entry.getValue()))) continue;
            this.add(id, this.getAutoName(((ResourceKey)entry.getKey()).location().getPath()));
        }
    }

    public String getAutoName(String path) {
        String[] words = path.split("_");
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            if (!builder.isEmpty()) {
                builder.append(" ");
            }
            if (!lowerCaseWords.contains(word)) {
                builder.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
                continue;
            }
            builder.append(word);
        }
        return builder.toString();
    }

    public void add(String key, String value) {
        this.usedKeys.add(key);
        super.add(key, value);
    }
}

