/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.neoforge.datagen.providers;

import net.favouriteless.enchanted.common.blocks.FumeFunnelBlock;
import net.favouriteless.enchanted.common.blocks.cauldrons.KettleBlock;
import net.favouriteless.enchanted.common.blocks.chalk.ChalkCircleBlock;
import net.favouriteless.enchanted.common.blocks.chalk.GoldChalkBlock;
import net.favouriteless.enchanted.common.blocks.crops.BloodPoppyBlock;
import net.favouriteless.enchanted.common.blocks.crops.CropBlockAgeFive;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockstateProvider
extends BlockStateProvider {
    public BlockstateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "enchanted", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.logWithItem(EBlocks.ROWAN_LOG.get());
        this.logWithItem(EBlocks.HAWTHORN_LOG.get());
        this.logWithItem(EBlocks.ALDER_LOG.get());
        this.logWithItem((RotatedPillarBlock)EBlocks.WICKER_BUNDLE.get());
        this.logWithItem(EBlocks.STRIPPED_ALDER_LOG.get());
        this.logWithItem(EBlocks.STRIPPED_ROWAN_LOG.get());
        this.logWithItem(EBlocks.STRIPPED_HAWTHORN_LOG.get());
        this.fenceWithItem(EBlocks.ALDER_FENCE.get(), this.blockTexture(EBlocks.ALDER_PLANKS.get()));
        this.fenceWithItem(EBlocks.ROWAN_FENCE.get(), this.blockTexture(EBlocks.ROWAN_PLANKS.get()));
        this.fenceWithItem(EBlocks.HAWTHORN_FENCE.get(), this.blockTexture(EBlocks.HAWTHORN_PLANKS.get()));
        this.fenceGateWithItem(EBlocks.ALDER_FENCE_GATE.get(), this.blockTexture(EBlocks.ALDER_PLANKS.get()));
        this.fenceGateWithItem(EBlocks.ROWAN_FENCE_GATE.get(), this.blockTexture(EBlocks.ROWAN_PLANKS.get()));
        this.fenceGateWithItem(EBlocks.HAWTHORN_FENCE_GATE.get(), this.blockTexture(EBlocks.HAWTHORN_PLANKS.get()));
        this.buttonWithItem(EBlocks.ALDER_BUTTON.get(), this.blockTexture(EBlocks.ALDER_PLANKS.get()));
        this.buttonWithItem(EBlocks.HAWTHORN_BUTTON.get(), this.blockTexture(EBlocks.HAWTHORN_PLANKS.get()));
        this.buttonWithItem(EBlocks.ROWAN_BUTTON.get(), this.blockTexture(EBlocks.ROWAN_PLANKS.get()));
        this.pressurePlateWithItem(EBlocks.ROWAN_PRESSURE_PLATE.get(), this.blockTexture(EBlocks.ROWAN_PLANKS.get()));
        this.pressurePlateWithItem(EBlocks.ALDER_PRESSURE_PLATE.get(), this.blockTexture(EBlocks.ALDER_PLANKS.get()));
        this.pressurePlateWithItem(EBlocks.HAWTHORN_PRESSURE_PLATE.get(), this.blockTexture(EBlocks.HAWTHORN_PLANKS.get()));
        this.simpleWithItem(EBlocks.ROWAN_PLANKS.get());
        this.simpleWithItem(EBlocks.HAWTHORN_PLANKS.get());
        this.simpleWithItem(EBlocks.ALDER_PLANKS.get());
        this.slabWithItem(EBlocks.ROWAN_SLAB.get(), EBlocks.ROWAN_PLANKS.get());
        this.slabWithItem(EBlocks.HAWTHORN_SLAB.get(), EBlocks.HAWTHORN_PLANKS.get());
        this.slabWithItem(EBlocks.ALDER_SLAB.get(), EBlocks.ALDER_PLANKS.get());
        this.stairsWithItem(EBlocks.ROWAN_STAIRS.get(), EBlocks.ROWAN_PLANKS.get());
        this.stairsWithItem(EBlocks.HAWTHORN_STAIRS.get(), EBlocks.HAWTHORN_PLANKS.get());
        this.stairsWithItem(EBlocks.ALDER_STAIRS.get(), EBlocks.ALDER_PLANKS.get());
        this.leafRandomWithItem(EBlocks.ROWAN_LEAVES.get(), 4);
        this.leafRandomWithItem(EBlocks.HAWTHORN_LEAVES.get(), 4);
        this.leafRandomWithItem(EBlocks.ALDER_LEAVES.get(), 4);
        this.crossWithItem((Block)EBlocks.ROWAN_SAPLING.get());
        this.crossWithItem((Block)EBlocks.HAWTHORN_SAPLING.get());
        this.crossWithItem((Block)EBlocks.ALDER_SAPLING.get());
        this.chalkWithItem(EBlocks.RITUAL_CHALK.get());
        this.chalkWithItem(EBlocks.NETHER_CHALK.get());
        this.chalkWithItem(EBlocks.OTHERWHERE_CHALK.get());
        this.goldChalkWithItem(EBlocks.GOLDEN_CHALK.get());
        this.simpleBlockItem((Block)EBlocks.ALTAR.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/altar")));
        this.horizontalLitWithItem((Block)EBlocks.WITCH_OVEN.get(), "_on", 180);
        this.fumeFunnelWithItem(EBlocks.FUME_FUNNEL.get());
        this.fumeFunnelWithItem(EBlocks.FUME_FUNNEL_FILTERED.get());
        this.horizontalLitWithItem((Block)EBlocks.DISTILLERY.get(), "", 180);
        this.complexWithItem(EBlocks.WITCH_CAULDRON.get());
        this.complexWithItem(EBlocks.CHALICE.get());
        this.complexWithItem(EBlocks.CHALICE_FILLED.get());
        this.complexWithItem((Block)EBlocks.INFINITY_EGG.get(), "block/dragon_egg");
        this.complexWithItem(EBlocks.CANDELABRA.get());
        this.kettleWithItem(EBlocks.KETTLE.get());
        this.complexWithItem((Block)EBlocks.POPPET_SHELF.get());
        this.cropsWithItem(EBlocks.BELLADONNA.get(), "crop");
        this.cropsWithItem(EBlocks.SNOWBELL.get(), "cross");
        this.cropsWithItem(EBlocks.WATER_ARTICHOKE.get(), "crop");
        this.cropsWithItem(EBlocks.MANDRAKE.get(), "crop");
        this.cropsWithItem(EBlocks.GARLIC.get(), "crop");
        this.cropsWithItem(EBlocks.WOLFSBANE.get(), "cross");
        this.crossWithItem(EBlocks.GLINT_WEED.get());
        this.crossWithItem(EBlocks.EMBER_MOSS.get());
        this.getVariantBuilder((Block)EBlocks.BLOOD_POPPY.get()).forAllStates(state -> {
            String name = "block/" + BuiltInRegistries.BLOCK.getKey((Object)((Block)EBlocks.BLOOD_POPPY.get())).getPath();
            if (((Boolean)state.getValue((Property)BloodPoppyBlock.FILLED)).booleanValue()) {
                name = name + "_filled";
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/cross"))).texture("cross", name)).renderType("minecraft:cutout")).build();
        });
        this.simpleItem((Block)EBlocks.BLOOD_POPPY.get());
        this.simpleItem((Block)EBlocks.SPANISH_MOSS.get());
    }

    private void kettleWithItem(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile((Integer)state.getValue((Property)KettleBlock.TYPE) == 0 ? this.modLoc("block/kettle") : ((Integer)state.getValue((Property)KettleBlock.TYPE) == 1 ? this.modLoc("block/kettle_hanging") : this.modLoc("block/kettle_hanging_beam")))).rotationY((int)((Direction)state.getValue((Property)KettleBlock.FACING)).toYRot() % 360).build());
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(this.modLoc("block/kettle")));
    }

    private void simpleItem(Block block) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ((ItemModelBuilder)this.itemModels().withExistingParent("item/" + name, this.mcLoc("item/generated"))).texture("layer0", "block/" + name);
    }

    private void chalkWithItem(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/glyph_" + (Integer)state.getValue((Property)ChalkCircleBlock.GLYPH) % 12, this.modLoc("block/glyph"))).texture("top", "block/glyph_" + (Integer)state.getValue((Property)ChalkCircleBlock.GLYPH) % 12)).rotationY((Integer)state.getValue((Property)ChalkCircleBlock.GLYPH) % 4 * 90).build());
        ((ItemModelBuilder)this.itemModels().withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block).toString(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath()));
    }

    private void goldChalkWithItem(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/glyph"))).texture("top", this.modLoc("block/glyph_gold"));
        for (int j = 0; j < 4; ++j) {
            builder.partialState().with((Property)GoldChalkBlock.GLYPH, (Comparable)Integer.valueOf(j)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, j * 90, false)});
        }
        ((ItemModelBuilder)this.itemModels().withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block).toString(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    private void simpleWithItem(Block block) {
        this.simpleBlock(block);
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath())));
    }

    private void complexWithItem(Block block) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath()));
        this.simpleBlock(block, (ModelFile)model);
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void complexWithItem(Block block, String location) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.mcLoc(location));
        this.simpleBlock(block, (ModelFile)model);
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void slabWithItem(SlabBlock block, Block parent) {
        ResourceLocation path = this.blockTexture(parent);
        this.slabBlock(block, path, this.blockTexture(parent));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void stairsWithItem(StairBlock block, Block parent) {
        this.stairsBlock(block, this.blockTexture(parent));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void horizontalLitWithItem(Block block, String onSuffix, int angleOffset) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelFile.ExistingModelFile modelUnlit = this.models().getExistingFile(this.modLoc("block/" + name));
        ModelFile.ExistingModelFile modelLit = this.models().getExistingFile(this.modLoc("block/" + name + onSuffix));
        this.getVariantBuilder(block).forAllStates(arg_0 -> BlockstateProvider.lambda$horizontalLitWithItem$3((ModelFile)modelLit, (ModelFile)modelUnlit, angleOffset, arg_0));
        ((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)modelUnlit);
    }

    private void fumeFunnelWithItem(Block block) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        String[] types = new String[]{"_left", "_top", "_right", ""};
        for (int type = 0; type < types.length; ++type) {
            ModelFile.ExistingModelFile modelUnlit = this.models().getExistingFile(this.modLoc("block/" + name + types[type]));
            ModelFile.ExistingModelFile modelLit = type == 3 ? modelUnlit : this.models().getExistingFile(this.modLoc("block/" + name + types[type] + "_on"));
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                builder.partialState().with((Property)FumeFunnelBlock.TYPE, (Comparable)Integer.valueOf(type)).with((Property)FumeFunnelBlock.FACING, (Comparable)dir).with((Property)FumeFunnelBlock.LIT, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelUnlit, 0, (int)(dir.toYRot() + 180.0f), false)});
                builder.partialState().with((Property)FumeFunnelBlock.TYPE, (Comparable)Integer.valueOf(type)).with((Property)FumeFunnelBlock.FACING, (Comparable)dir).with((Property)FumeFunnelBlock.LIT, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelLit, 0, (int)(dir.toYRot() + 180.0f) % 360, false)});
            }
        }
        ((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/" + name + types[0])));
    }

    private void leafRandomWithItem(Block block, int numVariants) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ConfiguredModel[] models = new ConfiguredModel[numVariants];
        for (int i = 0; i < numVariants; ++i) {
            models[i] = new ConfiguredModel((ModelFile)this.models().getExistingFile(this.modLoc("block/" + name + "_" + i)));
        }
        this.getVariantBuilder(block).partialState().setModels(models);
        ((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/" + name + "_0")));
    }

    private void logWithItem(RotatedPillarBlock block) {
        this.logBlock(block);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void fenceWithItem(FenceBlock block, ResourceLocation texture) {
        this.fenceBlock(block, texture);
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(key.getPath())).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/fence_inventory")))).texture("texture", texture);
    }

    private void fenceGateWithItem(FenceGateBlock block, ResourceLocation texture) {
        this.fenceGateBlock(block, texture);
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        ((ItemModelBuilder)this.itemModels().getBuilder(key.getPath())).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/" + key.getPath())));
    }

    private void buttonWithItem(ButtonBlock block, ResourceLocation texture) {
        this.buttonBlock(block, texture);
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(key.getPath())).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/button_inventory")))).texture("texture", texture);
    }

    private void pressurePlateWithItem(PressurePlateBlock block, ResourceLocation texture) {
        this.pressurePlateBlock(block, texture);
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        ((ItemModelBuilder)this.itemModels().getBuilder(key.getPath())).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/" + key.getPath())));
    }

    private void cross(Block block) {
        ResourceLocation path = this.blockTexture(block);
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(path.toString(), path)).renderType(ResourceLocation.withDefaultNamespace((String)"cutout")));
    }

    private void crossWithItem(Block block) {
        this.cross(block);
        this.simpleItem(block);
    }

    private void cropsWithItem(CropBlockAgeFive block, String parent) {
        String path = "block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_stage_";
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(path + String.valueOf(state.getValue((Property)CropBlockAgeFive.AGE_FIVE)), this.mcLoc("block/" + parent))).texture(parent, path + String.valueOf(state.getValue((Property)CropBlockAgeFive.AGE_FIVE)))).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"))).build());
    }

    private static /* synthetic */ ConfiguredModel[] lambda$horizontalLitWithItem$3(ModelFile modelLit, ModelFile modelUnlit, int angleOffset, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? modelLit : modelUnlit).rotationY((int)(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + (float)angleOffset) % 360).build();
    }
}

