/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.neoforge.datagen;

import java.util.concurrent.CompletableFuture;
import net.favouriteless.enchanted.neoforge.datagen.providers.BlockstateProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.ELanguageProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.ELootTableProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.ERecipeProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.ItemModelProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.enchanted.EMutagenInfoProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.enchanted.EPowerProvidersProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.modopedia.EBookProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.modopedia.EBookTextureProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.modopedia.EContentSetProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.modopedia.ETemplateProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.tag.EBiomeTagProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.tag.EBlockTagProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.tag.EDamageTypeTagProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.tag.EEntityTypeTagProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.tag.EItemTagProvider;
import net.favouriteless.enchanted.neoforge.datagen.providers.tag.EMobEffectTagProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="enchanted")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        EBlockTagProvider blockTagProvider = (EBlockTagProvider)gen.addProvider(true, (DataProvider)new EBlockTagProvider(output, provider, fileHelper));
        gen.addProvider(true, (DataProvider)new EItemTagProvider(output, provider, fileHelper, blockTagProvider.contentsGetter()));
        gen.addProvider(true, (DataProvider)new EEntityTypeTagProvider(output, provider, fileHelper));
        gen.addProvider(true, (DataProvider)new EMobEffectTagProvider(output, provider, fileHelper));
        gen.addProvider(true, (DataProvider)new EBiomeTagProvider(output, provider, fileHelper));
        gen.addProvider(true, (DataProvider)new EDamageTypeTagProvider(output, provider, fileHelper));
        gen.addProvider(true, (DataProvider)new ERecipeProvider(output, provider));
        gen.addProvider(true, (DataProvider)new BlockstateProvider(output, fileHelper));
        gen.addProvider(true, (DataProvider)new ItemModelProvider(output, fileHelper));
        gen.addProvider(true, (DataProvider)new ELanguageProvider(output));
        gen.addProvider(true, (DataProvider)ELootTableProvider.create(output, provider));
        gen.addProvider(true, (DataProvider)new EBookTextureProvider(provider, output));
        gen.addProvider(true, (DataProvider)new ETemplateProvider(provider, output));
        gen.addProvider(true, (DataProvider)new EBookProvider(provider, output));
        gen.addProvider(true, (DataProvider)new EContentSetProvider(provider, output));
        gen.addProvider(true, (DataProvider)new EMutagenInfoProvider(output, provider));
        gen.addProvider(true, (DataProvider)new EPowerProvidersProvider(output, provider));
    }
}

