/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.neoforge.common;

import net.favouriteless.enchanted.common.CommonEvents;
import net.favouriteless.enchanted.common.effects.EffectEvents;
import net.favouriteless.enchanted.common.poppet.PoppetEvents;
import net.favouriteless.enchanted.platform.services.NeoCommonRegistryHelper;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="enchanted")
public class CommonEventsNeo {
    @SubscribeEvent
    public static void onPlayerItemBreak(PlayerDestroyItemEvent event) {
        PoppetEvents.onPlayerItemBreak(event.getEntity(), event.getOriginal(), event.getHand());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onArmourHurt(ArmorHurtEvent event) {
        event.getArmorMap().forEach((slot, entry) -> {
            if (PoppetEvents.onArmourHurt(event.getEntity(), slot, entry.armorItemStack, entry.newDamage)) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        if (EffectEvents.onLivingHurt(event.getEntity(), event.getSource(), event.getOriginalDamage())) {
            event.setNewDamage(0.0f);
            return;
        }
        if (PoppetEvents.onLivingEntityHurt(event.getEntity(), event.getOriginalDamage(), event.getSource())) {
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(CanPlayerSleepEvent event) {
        CommonEvents.onPlayerSleeping((Player)event.getEntity(), event.getPos());
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        CommonEvents.onLevelTick(event.getLevel());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CommonEvents.onPlayerLoggedIn(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        CommonEvents.onPlayerLoggedOut(event.getEntity());
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        for (SimpleJsonResourceReloadListener loader : NeoCommonRegistryHelper.dataLoaders) {
            event.addListener((PreparableReloadListener)loader);
        }
    }
}

