/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.neoforge.client;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.function.Consumer;
import net.favouriteless.enchanted.client.ClientConfig;
import net.favouriteless.enchanted.client.ClientRegistry;
import net.favouriteless.enchanted.client.EShaders;
import net.favouriteless.enchanted.client.EnchantedClient;
import net.favouriteless.enchanted.client.render.blockentity.item.SpinningWheelItemRenderer;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EItems;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.apache.logging.log4j.util.TriConsumer;

@Mod(value="enchanted", dist={Dist.CLIENT})
@EventBusSubscriber(modid="enchanted", value={Dist.CLIENT})
public class EnchantedClientNeo {
    public EnchantedClientNeo(IEventBus bus, ModContainer container) {
        EnchantedClient.init();
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC, "enchanted-client.toml");
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientRegistry.registerItemModelPredicates();
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        ClientRegistry.registerMenuScreens();
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        ClientRegistry.registerBlockColors((BlockColor x$0, Block xva$1) -> event.register(x$0, new Block[]{xva$1}));
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientRegistry.registerEntityRenderers();
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ClientRegistry.registerLayerDefinitions((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        ClientRegistry.registerParticleProviders();
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private BlockEntityWithoutLevelRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SpinningWheelItemRenderer();
                }
                return this.renderer;
            }
        }, new Item[]{EItems.SPINNING_WHEEL.get()});
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) {
        EShaders.load((TriConsumer<String, VertexFormat, Consumer<ShaderInstance>>)((TriConsumer)(name, format, callback) -> {
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), Enchanted.id(name), format), callback);
            }
            catch (IOException e) {
                Enchanted.LOG.error("Failed to load ShaderInstance: {}", name);
            }
        }));
    }
}

