/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.modopedia.client.template_processors;

import java.util.List;
import java.util.Optional;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.recipes.SpinningRecipe;
import net.favouriteless.enchanted.common.util.LangUtils;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.TemplateProcessor;
import net.favouriteless.modopedia.client.page_components.item_displays.SimpleItemDisplay;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class SpinningRecipeProcessor
implements TemplateProcessor {
    public static final ResourceLocation ID = Enchanted.id("spinning_recipe");

    public void init(Book book, Lookup.MutableLookup lookup, Level level) {
        ResourceLocation id = (ResourceLocation)lookup.get("recipe").as(ResourceLocation.class);
        Optional optional = level.getRecipeManager().byKey(id);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(id) + " is not a valid recipe.");
        }
        RecipeHolder holder = (RecipeHolder)optional.get();
        Recipe recipe = holder.value();
        if (!(recipe instanceof SpinningRecipe)) {
            throw new IllegalArgumentException("SpinningRecipe template must use a SpinningRecipe recipe.");
        }
        SpinningRecipe recipe2 = (SpinningRecipe)recipe;
        List<ItemStack> inputs = recipe2.getInputs();
        lookup.set("p_input1", Variable.of((Object)new SimpleItemDisplay(inputs.get(0))));
        lookup.set("p_input2", Variable.of((Object)new SimpleItemDisplay(inputs.get(1))));
        lookup.set("p_input3", Variable.of((Object)new SimpleItemDisplay(inputs.get(2))));
        lookup.set("p_output", Variable.of((Object)new SimpleItemDisplay(recipe2.getResultItem((HolderLookup.Provider)level.registryAccess()))));
        lookup.set("p_power", Variable.of((Object)Component.translatable((String)LangUtils.tooltip("altar_power"), (Object[])new Object[]{recipe2.getPower()}).getString()));
    }
}

