/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.modopedia.client.template_processors;

import java.util.List;
import java.util.Optional;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.recipes.DistillingRecipe;
import net.favouriteless.enchanted.common.util.LangUtils;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.TemplateProcessor;
import net.favouriteless.modopedia.api.book.page_components.ItemDisplay;
import net.favouriteless.modopedia.api.registries.client.BookTextureRegistry;
import net.favouriteless.modopedia.client.page_components.item_displays.EmptyItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.GridItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.SimpleItemDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class DistillingRecipeProcessor
implements TemplateProcessor {
    public static final ResourceLocation ID = Enchanted.id("distilling_recipe");

    public void init(Book book, Lookup.MutableLookup lookup, Level level) {
        this.initComponents(book, lookup);
        this.initRecipes(lookup, level);
    }

    protected void initRecipes(Lookup.MutableLookup lookup, Level level) {
        ResourceLocation id = (ResourceLocation)lookup.get("recipe").as(ResourceLocation.class);
        Optional optional = level.getRecipeManager().byKey(id);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(id) + " is not a valid recipe.");
        }
        RecipeHolder holder = (RecipeHolder)optional.get();
        Recipe recipe = holder.value();
        if (!(recipe instanceof DistillingRecipe)) {
            throw new IllegalArgumentException("DistilleryRecipe template must use a DistilleryRecipe.");
        }
        DistillingRecipe recipe2 = (DistillingRecipe)recipe;
        List<ItemDisplay> inputs = recipe2.inputs().stream().map(SimpleItemDisplay::new).toList();
        List<ItemDisplay> outputs = recipe2.outputs().stream().map(SimpleItemDisplay::new).toList();
        lookup.set("p_input1", Variable.of((Object)inputs.getFirst()));
        lookup.set("p_input2", Variable.of((Object)new GridItemDisplay(inputs.subList(1, inputs.size()), 2, 20, false)));
        lookup.set("p_output1", Variable.of((Object)new GridItemDisplay(outputs.size() > 1 ? outputs.subList(0, 2) : outputs.subList(0, 1), 2, 19, false)));
        lookup.set("p_output2", Variable.of((Object)(outputs.size() > 2 ? new GridItemDisplay(outputs.subList(2, outputs.size()), 2, 19, false) : new EmptyItemDisplay())));
        lookup.set("p_power", Variable.of((Object)Component.translatable((String)LangUtils.tooltip("altar_power"), (Object[])new Object[]{recipe2.power()}).getString()));
    }

    protected void initComponents(Book book, Lookup.MutableLookup lookup) {
        BookTexture tex = BookTextureRegistry.get().getTexture(book.getTexture());
        if (tex == null) {
            throw new IllegalStateException("DistilleryRecipe must have a valid BookTexture");
        }
        BookTexture.Rectangle page = (BookTexture.Rectangle)tex.pages().get(lookup.get("page_num").asInt() % tex.pages().size());
        BookTexture.Rectangle back = (BookTexture.Rectangle)tex.widgets().get("distillery");
        if (back == null) {
            throw new IllegalStateException("DistilleryRecipe must have a valid distillery widget");
        }
        int center = page.width() / 2;
        lookup.set("p_x", Variable.of((Object)(center - back.width() / 2)));
        lookup.set("p_input1_x", Variable.of((Object)(center - 8)));
        lookup.set("p_input2_x", Variable.of((Object)(center - 18)));
        lookup.set("p_output1_x", Variable.of((Object)(center - 37)));
        lookup.set("p_output2_x", Variable.of((Object)(center + 2)));
    }
}

