/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.modopedia.client.template_processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.recipes.CauldronTypeRecipe;
import net.favouriteless.enchanted.common.util.LangUtils;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.TemplateProcessor;
import net.favouriteless.modopedia.client.page_components.item_displays.GridItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.SimpleItemDisplay;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class CauldronTypeRecipeProcessor
implements TemplateProcessor {
    public static final ResourceLocation ID = Enchanted.id("cauldron_type_recipe");

    public void init(Book book, Lookup.MutableLookup lookup, Level level) {
        ResourceLocation id = (ResourceLocation)lookup.get("recipe").as(ResourceLocation.class);
        Optional optional = level.getRecipeManager().byKey(id);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(id) + " is not a valid recipe.");
        }
        RecipeHolder holder = (RecipeHolder)optional.get();
        Recipe recipe = holder.value();
        if (!(recipe instanceof CauldronTypeRecipe)) {
            throw new IllegalArgumentException("CauldronTypeRecipe template must use a CauldronTypeRecipe recipe.");
        }
        CauldronTypeRecipe recipe2 = (CauldronTypeRecipe)recipe;
        ArrayList inputs = new ArrayList();
        recipe2.getInputs().forEach(i -> inputs.add(List.of(i)));
        int rows = (int)Math.ceil((float)inputs.size() / 5.0f);
        lookup.set("p_inputs_y", Variable.of((Object)(35 - rows * 8)));
        lookup.set("p_inputs", Variable.of((Object)new GridItemDisplay(recipe2.getInputs().stream().map(SimpleItemDisplay::new).toList(), 5, 16, true)));
        lookup.set("p_output", Variable.of((Object)new SimpleItemDisplay(recipe2.getResultItem((HolderLookup.Provider)level.registryAccess()))));
        lookup.set("p_power", Variable.of((Object)Component.translatable((String)LangUtils.tooltip("altar_power"), (Object[])new Object[]{recipe2.getPower()}).getString()));
    }
}

