/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.modopedia.client.template_processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.recipes.ByproductRecipe;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.TemplateProcessor;
import net.favouriteless.modopedia.client.page_components.item_displays.CyclingItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.SimpleItemDisplay;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ByproductRecipeProcessor
implements TemplateProcessor {
    public static final ResourceLocation ID = Enchanted.id("byproduct_recipe");

    public void init(Book book, Lookup.MutableLookup lookup, Level level) {
        ArrayList<ItemStack> outputs;
        ArrayList<ItemStack> inputs;
        ByproductRecipe recipe;
        ResourceLocation id = (ResourceLocation)lookup.get("recipe").as(ResourceLocation.class);
        Optional optional = level.getRecipeManager().byKey(id);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(id) + " is not a valid recipe.");
        }
        RecipeHolder holder = (RecipeHolder)optional.get();
        Recipe recipe2 = holder.value();
        if (recipe2 instanceof ByproductRecipe) {
            recipe = (ByproductRecipe)recipe2;
            Ingredient input = recipe.getInput();
            inputs = new ArrayList<ItemStack>();
            outputs = new ArrayList<ItemStack>();
            for (ItemStack stack : input.getItems()) {
                List smeltingRecipes = level.getRecipeManager().getRecipesFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), level);
                for (RecipeHolder sHolder : smeltingRecipes) {
                    ItemStack result = ((SmeltingRecipe)sHolder.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                    inputs.add(stack);
                    outputs.add(result);
                }
            }
        } else {
            throw new IllegalArgumentException("ByproductRecipe template must use a ByproductRecipe.");
        }
        ItemStack result = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        lookup.set("p_inputs", Variable.of((Object)new CyclingItemDisplay(inputs)));
        lookup.set("p_output", Variable.of((Object)new CyclingItemDisplay(outputs)));
        lookup.set("p_byproduct", Variable.of((Object)new SimpleItemDisplay(result)));
        lookup.set("p_jars", Variable.of((Object)new SimpleItemDisplay(new ItemStack((ItemLike)EItems.CLAY_JAR.get(), result.getCount()))));
    }
}

