/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.modopedia.client.page_components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.favouriteless.enchanted.client.EnchantedClient;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.CircleMagicShape;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.circle_magic.RiteWeatherRequirement;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.util.LangUtils;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.ItemDisplay;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.registries.client.BookTextureRegistry;
import net.favouriteless.modopedia.client.page_components.item_displays.RingsItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.SimpleItemDisplay;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class RitePageComponent
extends PageComponent {
    public static final ResourceLocation ID = Enchanted.id("rite");
    private RiteType rite;
    private ItemDisplay itemDisplay;
    private List<Requirement> requirements;
    private int requirementsWidth;

    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        Registry registry = level.registryAccess().registryOrThrow(EData.RITE_TYPES_REGISTRY);
        ResourceLocation id = (ResourceLocation)lookup.get("rite").as(ResourceLocation.class);
        this.rite = (RiteType)registry.get(id);
        if (this.rite == null) {
            throw new IllegalArgumentException(String.valueOf(id) + " is not a valid rite");
        }
        this.itemDisplay = new RingsItemDisplay(this.rite.getItems().stream().map(SimpleItemDisplay::new).toList(), 6, 16, 8);
        this.requirements = new ArrayList<Requirement>();
        BookTexture tex = BookTextureRegistry.get().getTexture(book.getTexture());
        if (tex == null) {
            throw new IllegalStateException("RitePageComponent needs a valid book texture");
        }
        this.buildRequirements(tex);
    }

    public void buildRequirements(BookTexture tex) {
        Pair<Integer, Integer> range;
        this.requirementsWidth = 0;
        ArrayList<Component> powerLines = new ArrayList<Component>();
        if (this.rite.getPower() > 0) {
            powerLines.add((Component)Component.translatable((String)LangUtils.tooltip("rite_requirement.power"), (Object[])new Object[]{this.rite.getPower()}).withStyle(ChatFormatting.GREEN));
        }
        if (this.rite.getTickPower() > 0) {
            powerLines.add((Component)Component.translatable((String)LangUtils.tooltip("rite_requirement.power_tick"), (Object[])new Object[]{this.rite.getTickPower()}).withStyle(ChatFormatting.GREEN));
        }
        if (!powerLines.isEmpty()) {
            this.addRequirement(tex, "rite/power", powerLines);
        }
        if (this.rite.getTimeRange() != null && ((Integer)(range = this.rite.getTimeRange()).getFirst() != 0 || (Integer)range.getSecond() != 24000)) {
            this.addRequirement(tex, "rite/time", List.of(Component.translatable((String)LangUtils.tooltip("rite_requirement.time_range")).withStyle(ChatFormatting.GREEN)));
        }
        if (this.rite.getWeatherRequirement() != RiteWeatherRequirement.NONE) {
            String weather = this.rite.getWeatherRequirement().getSerializedName();
            this.addRequirement(tex, "rite/weather/" + weather, List.of(Component.translatable((String)LangUtils.tooltip("rite_requirement.weather")), Component.translatable((String)LangUtils.tooltip("rite_requirement.weather." + weather)).withStyle(ChatFormatting.GREEN)));
        }
        if (!this.rite.getEntities().isEmpty()) {
            ArrayList<Component> sacrificeLines = new ArrayList<Component>();
            sacrificeLines.add((Component)Component.translatable((String)LangUtils.tooltip("rite_requirement.sacrifice")));
            for (EntityType<?> type : this.rite.getEntities()) {
                sacrificeLines.add((Component)type.getDescription().copy().withStyle(ChatFormatting.GREEN));
            }
            this.addRequirement(tex, "rite/sacrifices", sacrificeLines);
        }
    }

    private void addRequirement(BookTexture tex, String widget, List<Component> tooltipLines) {
        BookTexture.Rectangle rec = (BookTexture.Rectangle)tex.widgets().get(widget);
        if (rec == null) {
            throw new IllegalStateException("RitePageComponent needs a \"" + widget + "\" widget.");
        }
        this.requirementsWidth += rec.width();
        this.requirements.add(new Requirement(rec, tooltipLines));
    }

    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTicks) {
        this.renderShapes(graphics);
        this.renderItems(graphics, context, mouseX, mouseY);
        this.renderShapeTooltip(graphics, context, mouseX, mouseY);
        this.renderRequirementWidgets(graphics, context, mouseX, mouseY);
    }

    public void renderShapes(GuiGraphics graphics) {
        ResourceLocation heart = Enchanted.id("textures/gui/gold_glyph.png");
        graphics.blit(heart, this.x - 50, this.y, 0.0f, 0.0f, 100, 100, 100, 100);
        for (Map.Entry<Holder<CircleMagicShape>, Block> entry : this.rite.getShapes().entrySet()) {
            ResourceLocation tex;
            Optional optional = entry.getKey().unwrapKey();
            if (optional.isEmpty() || (tex = EnchantedClient.getShapeGuiTexture((ResourceKey<CircleMagicShape>)((ResourceKey)optional.get()), entry.getValue())) == null) continue;
            graphics.blit(tex, this.x - 50, this.y, 0.0f, 0.0f, 100, 100, 100, 100);
        }
    }

    public void renderItems(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY) {
        PoseStack pose = graphics.pose();
        int xShift = this.x;
        int yShift = this.y + 50;
        pose.pushPose();
        pose.translate((float)this.x, (float)(this.y + 50), 0.0f);
        this.itemDisplay.render(graphics, context, mouseX - xShift, mouseY - yShift, this.entryId);
        pose.popPose();
    }

    public void renderShapeTooltip(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        ArrayList<MutableComponent> shapeTooltip = new ArrayList<MutableComponent>();
        shapeTooltip.add(Component.translatable((String)LangUtils.tooltip("rite_requirement.shapes")));
        this.rite.getShapes().forEach((rite, block) -> rite.unwrapKey().map(ResourceKey::location).ifPresent(loc -> shapeTooltip.add(Component.translatable((String)LangUtils.key(loc.getNamespace(), "circle_magic.shape", loc.getPath())).withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.WHITE)).append((Component)block.getName().withStyle(ChatFormatting.GREEN)))));
        if (context.isHovered((double)mouseX, (double)mouseY, this.x - 5, this.y + 45, 10, 10)) {
            graphics.renderComponentTooltip(font, shapeTooltip, mouseX, mouseY);
        }
    }

    public void renderRequirementWidgets(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY) {
        Font font = Minecraft.getInstance().font;
        BookTexture tex = context.getBookTexture();
        ResourceLocation atlas = tex.location();
        int x = this.x - this.requirementsWidth / 2;
        int y = this.y + 101;
        for (Requirement req : this.requirements) {
            BookTexture.Rectangle r = req.rectangle();
            graphics.blit(atlas, x, y, (float)r.u(), (float)r.v(), r.width(), r.height(), tex.texWidth(), tex.texHeight());
            if (context.isHovered((double)mouseX, (double)mouseY, x, y, r.width(), r.height())) {
                graphics.renderComponentTooltip(font, req.tooltip, mouseX, mouseY);
            }
            x += r.width();
        }
    }

    private record Requirement(BookTexture.Rectangle rectangle, List<Component> tooltip) {
    }
}

