/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.modopedia.client.page_components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.favouriteless.enchanted.api.MutagenManager;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.crops.CropBlockAgeFive;
import net.favouriteless.enchanted.common.mutandis.MutagenInfo;
import net.favouriteless.enchanted.common.util.LangUtils;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.book.page_components.PageRenderable;
import net.favouriteless.modopedia.api.book.page_components.PageWidgetHolder;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.favouriteless.modopedia.api.registries.client.BookTextureRegistry;
import net.favouriteless.modopedia.client.multiblock.DenseMultiblock;
import net.favouriteless.modopedia.client.multiblock.PlacedMultiblock;
import net.favouriteless.modopedia.client.multiblock.state_matchers.SimpleStateMatcher;
import net.favouriteless.modopedia.client.page_widgets.PageImageButton;
import net.favouriteless.modopedia.platform.ClientServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MutagenDisplayPageComponent
extends PageComponent {
    public static final ResourceLocation ID = Enchanted.id("mutagen_display");
    private static final RandomSource RANDOM = RandomSource.createNewThreadLocalInstance();
    private List<MutagenDisplay> displays;
    protected PageImageButton leftButton;
    protected PageImageButton rightButton;
    protected int selected = 0;

    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        BookTexture texture = BookTextureRegistry.get().getTexture(book.getTexture());
        if (texture == null || !texture.widgets().containsKey("mutagen")) {
            throw new IllegalStateException("MutagenInfoPageComponent has been created on a book texture with no mutagen widget");
        }
        this.displays = new ArrayList<MutagenDisplay>();
        Block result = (Block)BuiltInRegistries.BLOCK.get((ResourceLocation)lookup.get("result").as(ResourceLocation.class));
        for (Map.Entry<Block, List<MutagenInfo.MutagenSet>> entry : MutagenManager.get().getMutagensFor(level, result).entrySet()) {
            BlockState mutee = this.getState(entry.getKey());
            for (MutagenInfo.MutagenSet set : entry.getValue()) {
                this.displays.add(new MutagenDisplay(new PlacedMultiblock((Multiblock)new DenseMultiblock(List.of(List.of("m")), Map.of(Character.valueOf('m'), new SimpleStateMatcher(List.of(mutee)))), level), set.mutagens().stream().map(b -> new PlacedMultiblock((Multiblock)new DenseMultiblock(List.of(List.of("m")), Map.of(Character.valueOf('m'), new SimpleStateMatcher(List.of(this.getState((Block)b))))), level)).toList(), set.weight(), set.extremis()));
            }
        }
        this.displays.sort((o1, o2) -> o2.weight - o1.weight);
    }

    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTicks) {
        BookTexture tex = context.getBookTexture();
        BookTexture.Rectangle mutagen = (BookTexture.Rectangle)tex.widgets().get("mutagen");
        int width = mutagen.width();
        int height = mutagen.height();
        int xo = mutagen.width() / 2;
        int yo = this.y + height / 2;
        graphics.blit(tex.location(), this.x - xo, this.y, width, height, (float)mutagen.u(), (float)mutagen.v(), width, height, tex.texWidth(), tex.texHeight());
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)this.x, (float)yo, 100.0f);
        MutagenDisplay display = this.displays.get(this.selected);
        this.render(context, display.mutee, pose, (MultiBufferSource)bufferSource, 16.0f, partialTicks);
        float a = 360.0f / (float)display.mutagens.size() * ((float)Math.PI / 180);
        float sin = Mth.sin((float)a);
        float cos = Mth.cos((float)a);
        float aStart = ((float)context.getTicks() + partialTicks) / 8.0f * ((float)(-Math.PI) / 180);
        float x1 = 23.0f * Mth.sin((float)aStart);
        float y1 = 23.0f * Mth.cos((float)aStart);
        for (PlacedMultiblock multiblock : display.mutagens) {
            pose.pushPose();
            pose.translate(x1, y1, 0.0f);
            this.render(context, multiblock, pose, (MultiBufferSource)bufferSource, 10.0f, partialTicks);
            pose.popPose();
            float xc = x1;
            x1 = xc * cos - y1 * sin;
            y1 = xc * sin + y1 * cos;
        }
        pose.popPose();
        Font font = Minecraft.getInstance().font;
        MutableComponent weightTitle = Component.translatable((String)LangUtils.tooltip("mutagen_weight")).withStyle(context.getStyle().withBold(Boolean.valueOf(true)));
        MutableComponent weight = Component.literal((String)String.valueOf(display.weight)).withStyle(context.getStyle());
        MutableComponent extremis = Component.translatable((String)LangUtils.tooltip("mutagen_extremis")).withStyle(context.getStyle().withBold(Boolean.valueOf(true)).withColor(7548205));
        int yw = this.y + height + 2;
        graphics.drawString(font, (Component)weightTitle, this.x - font.width((FormattedText)weightTitle) / 2, yw, 0, false);
        int n = this.x - font.width((FormattedText)weight) / 2;
        Objects.requireNonNull(font);
        graphics.drawString(font, (Component)weight, n, yw + 9, 0, false);
        if (display.extremis) {
            graphics.drawString(font, (Component)extremis, this.x - font.width((FormattedText)extremis) / 2, this.y - 7, 0, false);
        }
        if (context.isHovered((double)mouseX, (double)mouseY, this.x - xo, this.y, width, height)) {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            lines.add(Component.translatable((String)LangUtils.tooltip("mutee")));
            lines.add(display.mutee.getBlockState(BlockPos.ZERO).getBlock().getName().withStyle(ChatFormatting.GREEN));
            lines.add(Component.literal((String)""));
            lines.add(Component.translatable((String)LangUtils.tooltip("mutagens")));
            display.mutagens.stream().map(m -> m.getBlockState(BlockPos.ZERO).getBlock().getName().withStyle(ChatFormatting.GREEN)).forEach(lines::add);
            graphics.renderComponentTooltip(font, lines, mouseX, mouseY);
        }
    }

    public void initWidgets(PageWidgetHolder holder, BookRenderContext context) {
        if (this.displays.size() < 2) {
            return;
        }
        BookTexture bookTex = context.getBookTexture();
        ResourceLocation tex = bookTex.location();
        BookTexture.FixedRectangle left = bookTex.left();
        BookTexture.FixedRectangle right = bookTex.right();
        BookTexture.Rectangle mutagen = (BookTexture.Rectangle)bookTex.widgets().get("mutagen");
        int xo = mutagen.width() / 2;
        this.leftButton = (PageImageButton)holder.addRenderableWidget((PageRenderable)new PageImageButton(tex, this.x - xo, this.y + mutagen.height() + 11, left.width(), left.height(), left.u(), left.v(), bookTex.texWidth(), bookTex.texHeight(), b -> this.changeImage(-1)));
        this.rightButton = (PageImageButton)holder.addRenderableWidget((PageRenderable)new PageImageButton(tex, this.x + xo - right.width(), this.y + mutagen.height() + 11, right.width(), right.height(), right.u(), right.v(), bookTex.texWidth(), bookTex.texHeight(), b -> this.changeImage(1)));
        this.updateWidgetVisibility();
    }

    public void tick(BookRenderContext context) {
        this.displays.forEach(d -> {
            d.mutee.tick();
            d.mutagens.forEach(PlacedMultiblock::tick);
        });
    }

    protected BlockState getState(Block block) {
        return (BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().trySetValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(7))).trySetValue((Property)CropBlockAgeFive.AGE_FIVE, (Comparable)Integer.valueOf(4))).trySetValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true))).trySetValue((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(true));
    }

    protected void render(BookRenderContext context, PlacedMultiblock multiblock, PoseStack pose, MultiBufferSource bufferSource, float scale, float partialTicks) {
        float off = 0.5f * scale;
        pose.pushPose();
        pose.translate(off, off, off);
        pose.scale(-scale, -scale, -scale);
        pose.translate(0.5f, 0.5f, 0.5f);
        pose.mulPose(Axis.XN.rotationDegrees(30.0f));
        pose.mulPose(Axis.YP.rotationDegrees(((float)context.getTicks() + partialTicks) / 2.0f));
        pose.translate(-0.5f, -0.5f, -0.5f);
        this.renderBlock(multiblock, pose, bufferSource, partialTicks);
        this.renderBlockEntity(multiblock, pose, bufferSource, partialTicks);
        pose.popPose();
    }

    protected void renderBlock(PlacedMultiblock multiblock, PoseStack pose, MultiBufferSource bufferSource, float partialTicks) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BlockState state = multiblock.getBlockState(BlockPos.ZERO);
        if (state.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        pose.pushPose();
        for (RenderType type : ClientServices.PLATFORM.getRenderTypes((BlockAndTintGetter)multiblock, BlockPos.ZERO, state)) {
            VertexConsumer buffer = bufferSource.getBuffer(type);
            Vec3 offset = state.getOffset((BlockGetter)multiblock, BlockPos.ZERO);
            pose.translate(-offset.x, -offset.y, -offset.z);
            dispatcher.renderBatched(state, BlockPos.ZERO, (BlockAndTintGetter)multiblock, pose, buffer, false, RANDOM);
        }
        pose.popPose();
    }

    protected void renderBlockEntity(PlacedMultiblock multiblock, PoseStack pose, MultiBufferSource bufferSource, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        BlockEntity be = multiblock.getBlockEntity(BlockPos.ZERO);
        if (be == null) {
            return;
        }
        be.setLevel((Level)mc.level);
        try {
            BlockEntityRenderer renderer = mc.getBlockEntityRenderDispatcher().getRenderer(be);
            if (renderer != null) {
                renderer.render(be, partialTicks, pose, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void changeImage(int by) {
        this.selected = Mth.clamp((int)(this.selected + by), (int)0, (int)(this.displays.size() - 1));
        this.updateWidgetVisibility();
    }

    protected void updateWidgetVisibility() {
        if (this.selected <= 0) {
            this.selected = 0;
            this.leftButton.active = false;
        } else {
            this.leftButton.active = true;
        }
        if (this.selected >= this.displays.size() - 1) {
            this.selected = this.displays.size() - 1;
            this.rightButton.active = false;
        } else {
            this.rightButton.active = true;
        }
    }

    private record MutagenDisplay(PlacedMultiblock mutee, List<PlacedMultiblock> mutagens, int weight, boolean extremis) {
    }
}

