/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei.categories;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.favouriteless.enchanted.client.EnchantedClient;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.CircleMagicShape;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.favouriteless.enchanted.integrations.jei.recipes.JeiRiteRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class RiteCategory
extends AbstractRecipeCategory<JeiRiteRecipe> {
    private static final int CIRCLE_SIZE = 100;
    private static final int START_RADIUS = 15;
    private static final int RADIUS_INCREMENT = 15;
    private final IGuiHelper helper;
    private final IDrawableStatic background;
    private final IDrawableStatic glyph_golden;
    private final IDrawableAnimated arrow;
    private final List<IDrawableStatic> circles = new ArrayList<IDrawableStatic>();

    public RiteCategory(IGuiHelper helper) {
        super(EJeiRecipeTypes.RITE, (Component)Component.translatable((String)"jei.category.enchanted.circle_magic"), helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EItems.RITUAL_CHALK.get())), 180, 120);
        this.helper = helper;
        this.background = helper.createDrawable(Enchanted.id("textures/gui/jei/circle_magic.png"), 0, 0, 180, 120);
        this.glyph_golden = this.buildTexture(Enchanted.id("textures/gui/gold_glyph.png"), 100, 100);
        this.arrow = helper.createAnimatedRecipeArrow(120);
    }

    public void draw(JeiRiteRecipe recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        this.background.draw(graphics);
        for (IDrawableStatic drawable : this.circles) {
            drawable.draw(graphics, 0, 14);
        }
        this.glyph_golden.draw(graphics, 0, 14);
        this.arrow.draw(graphics, 95, 53);
        ResourceLocation riteName = recipe.id();
        String nameText = Component.translatable((String)("rite." + riteName.getNamespace() + "." + riteName.getPath())).getString();
        this.drawText(graphics, nameText, 180, 0);
        this.drawText(graphics, "Required Altar Power : " + recipe.rite().getPower(), 180, 112);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JeiRiteRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> itemsOut = recipe.rite().getOutputs();
        if (itemsOut == null) {
            return;
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(recipe.rite().getItems());
        int circleNum = 1;
        int itemsRemaining = itemList.size();
        while (itemsRemaining > 0) {
            int radius = 15 + (circleNum - 1) * 15;
            int limit = (int)Math.round(Math.pow(6.0, circleNum));
            int itemCount = Math.min(itemsRemaining, limit);
            for (int i = 0; i < itemCount; ++i) {
                ItemStack stack = (ItemStack)itemList.getFirst();
                itemList.remove(stack);
                float angle = (float)i * ((float)Math.PI * 2) / (float)itemCount + (float)Math.PI;
                int cx = Math.round(Mth.sin((float)(-angle)) * (float)radius) - 8;
                int cy = Math.round(Mth.cos((float)(-angle)) * (float)radius) - 8;
                builder.addSlot(RecipeIngredientRole.INPUT, 47 + cx, 60 + cy).addItemStack(stack);
                --itemsRemaining;
            }
            ++circleNum;
        }
        int numRows = (int)Math.ceil((float)itemsOut.size() / 3.0f);
        int height = numRows * 17;
        int startX = 119;
        int startY = 61 - Math.round((float)height / 2.0f);
        for (int i = 0; i < itemsOut.size(); ++i) {
            ItemStack stack = itemsOut.get(i);
            builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i % 3 * 17, startY + i / 3 * 17).addItemStack(stack);
        }
        this.circles.clear();
        for (Map.Entry<Holder<CircleMagicShape>, Block> entry : recipe.rite().getShapes().entrySet()) {
            ResourceKey shape = entry.getKey().unwrapKey().orElse(null);
            if (shape == null) {
                return;
            }
            ResourceLocation tex = EnchantedClient.getShapeGuiTexture((ResourceKey<CircleMagicShape>)shape, entry.getValue());
            if (tex == null) continue;
            this.circles.add(this.buildTexture(tex, 100, 100));
        }
    }

    private void drawText(GuiGraphics graphics, String text, int x, int y) {
        Minecraft mc = Minecraft.getInstance();
        int width = mc.font.width(text);
        int cx = x / 2 - width / 2 - 1;
        graphics.drawString(mc.font, text, cx + 1, y, Color.DARK_GRAY.getRGB(), false);
    }

    private IDrawableStatic buildTexture(ResourceLocation id, int width, int height) {
        return this.helper.drawableBuilder(id, 0, 0, width, height).setTextureSize(width, height).build();
    }
}

