/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei.categories;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.recipes.DistillingRecipe;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DistillingCategory
extends AbstractRecipeCategory<DistillingRecipe> {
    private final IDrawableStatic background;
    private final IDrawableAnimated bubbles;
    private final IDrawableAnimated arrow;

    public DistillingCategory(IGuiHelper helper) {
        super(EJeiRecipeTypes.DISTILLING, (Component)Component.translatable((String)"container.enchanted.distillery"), helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EItems.DISTILLERY.get())), 146, 75);
        this.background = helper.createDrawable(Enchanted.id("textures/gui/distillery.png"), 4, 5, this.getWidth(), this.getHeight());
        this.bubbles = helper.createAnimatedDrawable(helper.createDrawable(Enchanted.id("textures/gui/distillery.png"), 176, 0, 12, 29), 120, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.arrow = helper.createAnimatedDrawable(helper.createDrawable(Enchanted.id("textures/gui/distillery.png"), 176, 29, 57, 61), 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DistillingRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> inputs = recipe.inputs();
        boolean hasJars = false;
        for (ItemStack stack : inputs) {
            if (!stack.is(EItems.CLAY_JAR.get())) continue;
            hasJars = true;
            break;
        }
        if (hasJars) {
            builder.addSlot(RecipeIngredientRole.INPUT, 28, 30).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)inputs.getFirst());
        }
        int offset = 0;
        for (ItemStack i : recipe.inputs()) {
            if (i.is(EItems.CLAY_JAR.get())) continue;
            builder.addSlot(RecipeIngredientRole.INPUT, 50, 20 + offset).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            offset += 20;
        }
        offset = 0;
        for (ItemStack i : recipe.outputs()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 123, 2 + offset).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            offset += 19;
        }
    }

    public void draw(DistillingRecipe recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        this.background.draw(graphics);
        this.bubbles.draw(graphics, 88, 22);
        this.arrow.draw(graphics, 65, 8);
    }
}

