/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei.categories;

import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.recipes.CauldronTypeRecipe;
import net.favouriteless.enchanted.common.util.RecipeUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CauldronTypeRecipeCategory<T extends CauldronTypeRecipe>
extends AbstractRecipeCategory<T> {
    private final IDrawableStatic background;
    private final IDrawableAnimated arrow;

    public CauldronTypeRecipeCategory(IGuiHelper guiHelper, RecipeType<T> type, Component title, Item icon) {
        super(type, title, guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)icon)), 140, 70);
        this.background = guiHelper.createDrawable(Enchanted.id("textures/gui/jei/witch_cauldron.png"), 4, 4, 140, 70);
        this.arrow = guiHelper.createAnimatedRecipeArrow(120);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        int offset = 0;
        for (ItemStack i : ((CauldronTypeRecipe)recipe).getInputs()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 5 + offset, 5).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            offset += 20;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 30).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)RecipeUtils.getResultItem(recipe));
    }

    public void draw(T recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        this.background.draw(graphics);
        this.arrow.draw(graphics, 85, 29);
        this.drawPowerCost(graphics, recipe);
    }

    private void drawPowerCost(GuiGraphics graphics, T recipe) {
        Minecraft mc = Minecraft.getInstance();
        String text = "Required Altar Power : " + ((CauldronTypeRecipe)recipe).getPower();
        graphics.drawString(mc.font, text, 70 - mc.font.width(text) / 2, 55, Color.DARK_GRAY.getRGB(), false);
    }
}

