/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei.categories;

import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.recipes.ByproductRecipe;
import net.favouriteless.enchanted.common.util.RecipeUtils;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ByproductCategory
extends AbstractRecipeCategory<ByproductRecipe> {
    private final IDrawableStatic background;
    private final IDrawableAnimated fire;
    private final IDrawableAnimated arrow;

    public ByproductCategory(IGuiHelper helper) {
        super(EJeiRecipeTypes.BYPRODUCT, (Component)Component.translatable((String)"container.enchanted.witch_oven"), helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EItems.WITCH_OVEN.get())), 96, 65);
        this.background = helper.createDrawable(Enchanted.id("textures/gui/witch_oven.png"), 40, 10, this.getWidth(), this.getHeight());
        this.fire = helper.createAnimatedRecipeFlame(120);
        this.arrow = helper.createAnimatedRecipeArrow(120);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ByproductRecipe recipe, IFocusGroup focuses) {
        ArrayList itemsOut = new ArrayList();
        for (ItemStack stack : recipe.getInput().getItems()) {
            Minecraft mc = Minecraft.getInstance();
            mc.level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)mc.level).ifPresent(holder -> itemsOut.add(RecipeUtils.getResultItem(holder)));
        }
        if (!itemsOut.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 13, 7).addIngredients(recipe.getInput());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 7).addItemStacks(itemsOut);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 43).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)RecipeUtils.getResultItem(recipe));
            builder.addSlot(RecipeIngredientRole.CATALYST, 13, 43).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EItems.CLAY_JAR.get(), RecipeUtils.getResultItem(recipe).getCount()));
        }
    }

    public void draw(ByproductRecipe recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        this.background.draw(graphics);
        this.fire.draw(graphics, 40, 27);
        this.arrow.draw(graphics, 36, 6);
    }
}

