/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.favouriteless.enchanted.client.screens.DistilleryScreen;
import net.favouriteless.enchanted.client.screens.SpinningWheelScreen;
import net.favouriteless.enchanted.client.screens.WitchOvenScreen;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.EMenuTypes;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.menus.SpinningWheelMenu;
import net.favouriteless.enchanted.common.menus.WitchOvenMenu;
import net.favouriteless.enchanted.common.recipes.KettleRecipe;
import net.favouriteless.enchanted.common.recipes.WitchCauldronRecipe;
import net.favouriteless.enchanted.common.util.RecipeUtils;
import net.favouriteless.enchanted.integrations.jei.DistilleryTransferInfo;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.favouriteless.enchanted.integrations.jei.categories.ByproductCategory;
import net.favouriteless.enchanted.integrations.jei.categories.CauldronTypeRecipeCategory;
import net.favouriteless.enchanted.integrations.jei.categories.DistillingCategory;
import net.favouriteless.enchanted.integrations.jei.categories.RiteCategory;
import net.favouriteless.enchanted.integrations.jei.categories.SpinningCategory;
import net.favouriteless.enchanted.integrations.jei.container_handlers.DistilleryContainerHandler;
import net.favouriteless.enchanted.integrations.jei.container_handlers.SpinningWheelContainerHandler;
import net.favouriteless.enchanted.integrations.jei.container_handlers.WitchOvenContainerHandler;
import net.favouriteless.enchanted.integrations.jei.recipes.JeiMutandisRecipe;
import net.favouriteless.enchanted.integrations.jei.recipes.JeiRiteRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class EJeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = Enchanted.id("jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers helpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = helpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ByproductCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SpinningCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DistillingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RiteCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CauldronTypeRecipeCategory<WitchCauldronRecipe>(guiHelper, EJeiRecipeTypes.CAULDRON, (Component)Component.translatable((String)"jei.category.enchanted.witch_cauldron"), (Item)EItems.WITCH_CAULDRON.get())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CauldronTypeRecipeCategory<KettleRecipe>(guiHelper, EJeiRecipeTypes.KETTLE, (Component)Component.translatable((String)"jei.category.enchanted.kettle"), (Item)EItems.KETTLE.get())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(EJeiRecipeTypes.BYPRODUCT, RecipeUtils.getRecipes(ERecipeTypes.BYPRODUCT.get()));
        registration.addRecipes(EJeiRecipeTypes.SPINNING, RecipeUtils.getRecipes(ERecipeTypes.SPINNING.get()));
        registration.addRecipes(EJeiRecipeTypes.CAULDRON, RecipeUtils.getRecipes(ERecipeTypes.WITCH_CAULDRON.get()));
        registration.addRecipes(EJeiRecipeTypes.KETTLE, RecipeUtils.getRecipes(ERecipeTypes.KETTLE.get()));
        registration.addRecipes(EJeiRecipeTypes.DISTILLING, RecipeUtils.getRecipes(ERecipeTypes.DISTILLING.get()));
        JeiRiteRecipe.register(registration);
        JeiMutandisRecipe.register(registration);
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)EItems.CHALICE_FILLED.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.enchanted.chalice_filled")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)EItems.WITCH_CAULDRON.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.enchanted.witch_cauldron")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)EItems.FUME_FUNNEL_FILTERED.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.enchanted.fume_funnel_filtered")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)EItems.WOOL_OF_BAT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.enchanted.arthana.bat")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)EItems.TONGUE_OF_DOG.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.enchanted.arthana.wolf")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)EItems.CREEPER_HEART.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.enchanted.arthana.creeper")});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(WitchOvenMenu.class, EMenuTypes.WITCH_OVEN.get(), EJeiRecipeTypes.BYPRODUCT, 0, 1, 5, 36);
        registration.addRecipeTransferHandler(SpinningWheelMenu.class, EMenuTypes.SPINNING_WHEEL.get(), EJeiRecipeTypes.SPINNING, 0, 3, 4, 36);
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new DistilleryTransferInfo());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(EItems.WITCH_OVEN.get().getDefaultInstance(), new RecipeType[]{EJeiRecipeTypes.BYPRODUCT});
        registration.addRecipeCatalyst(EItems.SPINNING_WHEEL.get().getDefaultInstance(), new RecipeType[]{EJeiRecipeTypes.SPINNING});
        registration.addRecipeCatalyst(EItems.WITCH_CAULDRON.get().getDefaultInstance(), new RecipeType[]{EJeiRecipeTypes.CAULDRON});
        registration.addRecipeCatalyst(EItems.KETTLE.get().getDefaultInstance(), new RecipeType[]{EJeiRecipeTypes.KETTLE});
        registration.addRecipeCatalyst(EItems.DISTILLERY.get().getDefaultInstance(), new RecipeType[]{EJeiRecipeTypes.DISTILLING});
        registration.addRecipeCatalyst(EItems.GOLDEN_CHALK.get().getDefaultInstance(), new RecipeType[]{EJeiRecipeTypes.RITE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(DistilleryScreen.class, (IGuiContainerHandler)new DistilleryContainerHandler());
        registration.addGenericGuiContainerHandler(SpinningWheelScreen.class, (IGuiContainerHandler)new SpinningWheelContainerHandler());
        registration.addGenericGuiContainerHandler(WitchOvenScreen.class, (IGuiContainerHandler)new WitchOvenContainerHandler());
    }
}

