/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.datagen.providers;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class SimpleCodecProvider<T>
implements DataProvider {
    private final Codec<T> codec;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;

    protected SimpleCodecProvider(PackOutput.PathProvider pathProvider, CompletableFuture<HolderLookup.Provider> registries, Codec<T> codec) {
        this.pathProvider = pathProvider;
        this.registries = registries;
        this.codec = codec;
    }

    protected abstract void build(HolderLookup.Provider var1, BiConsumer<ResourceLocation, T> var2);

    public final CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(registries -> this.run(output, (HolderLookup.Provider)registries));
    }

    private CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider registries) {
        HashSet set = Sets.newHashSet();
        ArrayList generated = new ArrayList();
        this.build(registries, (id, t) -> {
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate " + this.getName() + ": " + String.valueOf(id));
            }
            generated.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, this.codec, (Object)t, (Path)this.pathProvider.json(id)));
        });
        return CompletableFuture.allOf((CompletableFuture[])generated.toArray(CompletableFuture[]::new));
    }
}

