/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.util;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeUtils {
    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        return recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
    }

    public static ItemStack getResultItem(RecipeHolder<?> recipe) {
        return RecipeUtils.getResultItem(recipe.value());
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<T> mapHolders(List<RecipeHolder<T>> holders) {
        return holders.stream().map(RecipeHolder::value).toList();
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getHolders(RecipeType<T> type) {
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(type);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<T> getRecipes(RecipeType<T> type) {
        return RecipeUtils.mapHolders(RecipeUtils.getHolders(type));
    }
}

