/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemUtils {
    public static void dropContentsNoChange(Level level, double x, double y, double z, Container inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack item = inventory.getItem(i).copy();
            double width = EntityType.ITEM.getWidth();
            double inverseWidth = 1.0 - width;
            double radius = width / 2.0;
            double dx = Math.floor(x) + Enchanted.RANDOM.nextDouble() * inverseWidth + radius;
            double dy = Math.floor(y) + Enchanted.RANDOM.nextDouble() * inverseWidth;
            double dz = Math.floor(z) + Enchanted.RANDOM.nextDouble() * inverseWidth + radius;
            while (!item.isEmpty()) {
                ItemEntity entity = new ItemEntity(level, dx, dy, dz, item.split(Enchanted.RANDOM.nextInt(21) + 10));
                entity.setDeltaMovement(Enchanted.RANDOM.nextGaussian() * 0.05, Enchanted.RANDOM.nextGaussian() * 0.05 + 0.2, Enchanted.RANDOM.nextGaussian() * 0.05);
                level.addFreshEntity((Entity)entity);
            }
        }
    }

    public static boolean isFuel(ItemStack stack) {
        return CommonServices.PLATFORM.getBurnTime(stack, null) > 0;
    }

    public static boolean isSameItemPartial(ItemStack a, ItemStack b) {
        if (a.getItem() != b.getItem()) {
            return false;
        }
        DataComponentPatch aMap = a.getComponentsPatch();
        DataComponentPatch bPatch = b.getComponentsPatch();
        for (Map.Entry entry : bPatch.entrySet()) {
            Object bComp;
            if (!aMap.get((DataComponentType)entry.getKey()).isPresent()) {
                return false;
            }
            Optional optional = aMap.get((DataComponentType)entry.getKey());
            Object aComp = optional != null ? optional.orElse(null) : null;
            if (Objects.equals(aComp, bComp = ((Optional)entry.getValue()).orElse(null))) continue;
            return false;
        }
        return true;
    }

    public static void giveOrDrop(Player player, ItemStack item) {
        if (player.addItem(item)) {
            return;
        }
        ItemEntity entity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), item);
        entity.setNoPickUpDelay();
        entity.setThrower((Entity)player);
        player.level().addFreshEntity((Entity)player);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, List<ItemStack> items, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (ItemStack stack : items) {
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            list.add((Object)stack.save(registries, (Tag)itemTag));
        }
        tag.put("Items", (Tag)list);
        return tag;
    }

    public static void loadAllItems(CompoundTag tag, List<ItemStack> items, HolderLookup.Provider registries) {
        ListTag list = tag.getList("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            items.add(ItemStack.parse((HolderLookup.Provider)registries, (Tag)list.getCompound(i)).orElse(ItemStack.EMPTY));
        }
    }
}

