/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.util;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class BlockPosUtils {
    public static Iterable<BlockPos.MutableBlockPos> iterableSphereHollow(final BlockPos center, final int radius) {
        return new Iterable<BlockPos.MutableBlockPos>(){

            @Override
            @NotNull
            public Iterator<BlockPos.MutableBlockPos> iterator() {
                return BlockPosUtils.iteratorSphereHollow(center, radius);
            }
        };
    }

    public static Iterator<BlockPos.MutableBlockPos> iteratorSphereHollow(final BlockPos center, final int radius) {
        return new Iterator<BlockPos.MutableBlockPos>(){
            private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
            private final float increment = 1.0f / (float)radius;
            private float theta = 0.0f;
            private float pitch = (float)(-Math.PI);

            @Override
            public boolean hasNext() {
                return this.theta < (float)Math.PI && this.pitch < (float)Math.PI;
            }

            @Override
            public BlockPos.MutableBlockPos next() {
                float theta = this.theta;
                float pitch = this.pitch;
                this.pitch += this.increment;
                if (this.pitch > (float)Math.PI) {
                    this.theta += this.increment;
                    this.pitch = (float)(-Math.PI);
                }
                float cosP = Mth.cos((float)pitch);
                this.pos.set(Math.round(Mth.sin((float)theta) * cosP * (float)radius), Math.round(Mth.sin((float)pitch) * (float)radius), Math.round(Mth.cos((float)theta) * cosP * (float)radius));
                return this.pos.move((Vec3i)center);
            }
        };
    }

    public static Iterable<BlockPos.MutableBlockPos> iterableCircleHollow(final BlockPos center, final int radius, final int increment) {
        return new Iterable<BlockPos.MutableBlockPos>(){

            @Override
            @NotNull
            public Iterator<BlockPos.MutableBlockPos> iterator() {
                return BlockPosUtils.iteratorCircleHollow(center, radius, increment);
            }
        };
    }

    public static Iterator<BlockPos.MutableBlockPos> iteratorCircleHollow(final BlockPos center, final int radius, final int step) {
        return new Iterator<BlockPos.MutableBlockPos>(){
            private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
            private final float increment = 1.0f / (float)radius;
            private float angle = 0.0f;

            @Override
            public boolean hasNext() {
                return this.angle < (float)Math.PI * 2;
            }

            @Override
            public BlockPos.MutableBlockPos next() {
                float theta = this.angle;
                this.angle += this.increment * (float)step;
                this.pos.set(Math.round(Mth.sin((float)theta) * (float)radius), 0, Math.round(Mth.cos((float)theta) * (float)radius));
                return this.pos.move((Vec3i)center);
            }
        };
    }

    public static Iterable<BlockPos.MutableBlockPos> iterableCircleHollow(BlockPos center, int radius) {
        return BlockPosUtils.iterableCircleHollow(center, radius, 1);
    }

    public static Iterator<BlockPos.MutableBlockPos> iteratorCircleHollow(BlockPos center, int radius) {
        return BlockPosUtils.iteratorCircleHollow(center, radius, 1);
    }
}

