/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.stateobservers;

import net.favouriteless.stateobserver.api.StateChangeSet;
import net.favouriteless.stateobserver.api.StateObserver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class ProtectionRiteObserver
extends StateObserver {
    private final BarrierBlock block;
    private final int radius;

    public ProtectionRiteObserver(Level level, BlockPos pos, int radiusX, int radiusY, int radiusZ, BarrierBlock block, int radius) {
        super(level, pos, radiusX, radiusY, radiusZ);
        this.block = block;
        this.radius = radius;
    }

    protected void handleChanges() {
        if (!this.getLevel().isClientSide) {
            for (StateChangeSet.StateChange change : this.getChangeSet().getChanges()) {
                Vec3 toPos;
                Vec3 clamped;
                BlockPos pos = change.pos();
                if (!pos.equals((Object)BlockPos.containing((Position)(clamped = (toPos = this.getPos().getCenter().vectorTo(pos.getCenter())).scale((double)this.radius / (double)Math.round(toPos.length())).add(this.getPos().getCenter()))))) continue;
                if (change.newState().isAir()) {
                    this.getLevel().setBlockAndUpdate(change.pos(), this.block.defaultBlockState());
                    continue;
                }
                if (change.newState().getFluidState().isEmpty()) continue;
                this.getLevel().setBlockAndUpdate(change.pos(), (BlockState)this.block.defaultBlockState().setValue((Property)BarrierBlock.WATERLOGGED, (Comparable)Boolean.valueOf(change.newState().getFluidState().getType() == Fluids.WATER)));
            }
        }
    }

    public void onInit() {
    }

    public void onRemove() {
    }
}

