/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.stateobservers;

import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.common.ServerConfig;
import net.favouriteless.enchanted.common.blocks.entity.AltarBlockEntity;
import net.favouriteless.stateobserver.api.StateChangeSet;
import net.favouriteless.stateobserver.api.StateObserver;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AltarStateObserver
extends StateObserver {
    public AltarStateObserver(Level level, BlockPos pos, int xRadius, int yRadius, int zRadius) {
        super(level, pos, xRadius, yRadius, zRadius);
    }

    protected void handleChanges() {
        BlockEntity be;
        if (!this.getLevel().isClientSide && (be = this.getLevel().getBlockEntity(this.getPos())) instanceof AltarBlockEntity) {
            AltarBlockEntity altar = (AltarBlockEntity)be;
            for (StateChangeSet.StateChange change : this.getChangeSet().getChanges()) {
                if (!altar.posWithinRange(change.pos(), (Integer)ServerConfig.INSTANCE.altarRange.get())) continue;
                if (!change.oldState().is(change.newState().getBlock())) {
                    BlockEntity blockEntity = this.getLevel().getBlockEntity(change.pos());
                    if (blockEntity instanceof IPowerConsumer) {
                        IPowerConsumer consumer = (IPowerConsumer)blockEntity;
                        consumer.getPosHolder().add(this.getPos());
                    }
                    altar.removeBlock(change.oldState().getBlock());
                    altar.addBlock(change.newState().getBlock());
                }
                if (!altar.posIsUpgrade(change.pos())) continue;
                altar.removeUpgrade(change.oldState().getBlock());
                altar.addUpgrade(change.newState().getBlock());
            }
        }
    }

    public void onInit() {
    }

    public void onRemove() {
    }
}

