/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.recipes.recipe_inputs;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;

public class ListInput
implements RecipeInput {
    private final List<ItemStack> items;

    private ListInput(List<ItemStack> items) {
        this.items = items;
    }

    public static ListInput of(ItemStack ... items) {
        return new ListInput(List.of(items));
    }

    public static ListInput of(List<ItemStack> items) {
        return new ListInput(items);
    }

    public ItemStack getItem(int index) {
        return index < 0 || index >= this.items.size() ? null : this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

