/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.recipes.recipe_inputs.ListInput;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SpinningRecipe
implements Recipe<ListInput> {
    public static final MapCodec<SpinningRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.listOf(3, 3).fieldOf("ingredients").forGetter(recipe -> recipe.inputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("power", (Object)0).forGetter(recipe -> recipe.power), (App)Codec.INT.optionalFieldOf("duration", (Object)300).forGetter(recipe -> recipe.duration)).apply((Applicative)instance, SpinningRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpinningRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, recipe -> recipe.inputs, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, (StreamCodec)ByteBufCodecs.INT, recipe -> recipe.power, (StreamCodec)ByteBufCodecs.INT, recipe -> recipe.duration, SpinningRecipe::new);
    private final List<ItemStack> inputs;
    private final ItemStack result;
    private final int power;
    private final int duration;

    public SpinningRecipe(List<ItemStack> inputs, ItemStack result, int power, int duration) {
        this.inputs = inputs;
        this.result = result;
        this.power = power;
        this.duration = duration;
    }

    public int getPower() {
        return this.power;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean matches(ListInput input, Level level) {
        if (input.size() != 3) {
            return false;
        }
        if (!ItemUtils.isSameItemPartial(input.getItem(0), this.inputs.getFirst()) || input.getItem(0).getCount() < this.inputs.getFirst().getCount()) {
            return false;
        }
        for (int i = 1; i < this.inputs.size(); ++i) {
            ItemStack neededCopy = this.inputs.get(i).copy();
            if (ItemUtils.isSameItemPartial(input.getItem(1), neededCopy)) {
                neededCopy.shrink(input.getItem(1).getCount());
            }
            if (ItemUtils.isSameItemPartial(input.getItem(2), neededCopy)) {
                neededCopy.shrink(input.getItem(2).getCount());
            }
            if (neededCopy.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(ListInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return ERecipeTypes.SPINNING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ERecipeTypes.SPINNING.get();
    }

    public boolean isSpecial() {
        return true;
    }
}

