/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.recipes.recipe_inputs.ListInput;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record DistillingRecipe(List<ItemStack> inputs, List<ItemStack> outputs, int duration, int power) implements Recipe<ListInput>
{
    private final List<ItemStack> outputs;
    public static final MapCodec<DistillingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.sizeLimitedListOf(3).fieldOf("ingredients").forGetter(recipe -> recipe.inputs), (App)ItemStack.CODEC.sizeLimitedListOf(4).fieldOf("results").forGetter(recipe -> recipe.outputs), (App)Codec.INT.optionalFieldOf("duration", (Object)300).forGetter(recipe -> recipe.duration), (App)Codec.INT.optionalFieldOf("power", (Object)750).forGetter(recipe -> recipe.power)).apply((Applicative)instance, DistillingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DistillingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, recipe -> recipe.inputs, (StreamCodec)ItemStack.LIST_STREAM_CODEC, recipe -> recipe.outputs, (StreamCodec)ByteBufCodecs.INT, recipe -> recipe.duration, (StreamCodec)ByteBufCodecs.INT, recipe -> recipe.power, DistillingRecipe::new);

    public List<ItemStack> outputs() {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        for (ItemStack stack : this.outputs) {
            out.add(stack.copy());
        }
        return out;
    }

    public boolean matches(ListInput inv, Level level) {
        int requiredItems = this.inputs().size();
        block0: for (ItemStack stack : this.inputs()) {
            for (int i = 0; i < 3; ++i) {
                ItemStack item = inv.getItem(i);
                if (!ItemUtils.isSameItemPartial(item, stack) || item.getCount() < stack.getCount()) continue;
                --requiredItems;
                continue block0;
            }
        }
        return requiredItems == 0;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Deprecated
    public ItemStack assemble(ListInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    @Deprecated
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ERecipeTypes.DISTILLING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ERecipeTypes.DISTILLING.get();
    }

    public boolean isSpecial() {
        return true;
    }
}

