/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.recipes;

import java.util.List;
import net.favouriteless.enchanted.common.recipes.recipe_inputs.ListInput;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;

public abstract class CauldronTypeRecipe
implements Recipe<ListInput> {
    protected final List<ItemStack> inputs;
    protected final ItemStack result;
    protected final int power;
    protected final int cookColor;
    protected final int finalColor;

    public CauldronTypeRecipe(List<ItemStack> inputs, ItemStack result, int power, int cookColor, int finalColor) {
        this.inputs = inputs;
        this.result = result;
        this.power = power;
        this.cookColor = cookColor;
        this.finalColor = finalColor;
    }

    public boolean matches(ListInput input, Level level) {
        if (input.isEmpty() || input.size() > this.inputs.size()) {
            return false;
        }
        for (int i = 0; i < this.inputs.size() && i < input.size(); ++i) {
            if (ItemUtils.isSameItemPartial(this.inputs.get(i), input.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public boolean fullMatch(ListInput input) {
        if (input.size() != this.inputs.size()) {
            return false;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (ItemUtils.isSameItemPartial(this.inputs.get(i), input.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(ListInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public int getPower() {
        return this.power;
    }

    public int getCookColour() {
        return this.cookColor;
    }

    public int getFinalColour() {
        return this.finalColor;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }
}

