/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class ByproductRecipe
implements Recipe<SingleRecipeInput> {
    public static final MapCodec<ByproductRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, ByproductRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ByproductRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.ingredient, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, ByproductRecipe::new);
    private final Ingredient ingredient;
    private final ItemStack result;

    public ByproductRecipe(Ingredient ingredient, ItemStack result) {
        this.ingredient = ingredient;
        this.result = result;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public Ingredient getInput() {
        return this.ingredient;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeType<?> getType() {
        return ERecipeTypes.BYPRODUCT.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return ERecipeTypes.BYPRODUCT_SERIALIZER.get();
    }
}

