/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.poppet;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Predicate;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.favouriteless.enchanted.common.items.poppets.DeathPoppetItem;
import net.favouriteless.enchanted.common.items.poppets.ItemProtectionPoppetItem;
import net.favouriteless.enchanted.common.items.poppets.PoppetItem;
import net.favouriteless.enchanted.common.network.client.PoppetAnimationPayload;
import net.favouriteless.enchanted.common.poppet.PoppetShelfInventory;
import net.favouriteless.enchanted.common.poppet.PoppetShelfManager;
import net.favouriteless.enchanted.common.poppet.PoppetShelfSavedData;
import net.favouriteless.enchanted.common.poppet.PoppetUseResult;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoppetUtils {
    public static boolean tryVoodooPlayer(ServerPlayer target, ServerPlayer attacker, ItemStack poppet) {
        PoppetUseResult result = PoppetUtils.tryUseItems(PoppetUtils.getPoppetQueue((Player)target, EItems::isVoodooProtectionPoppet), (Player)target, null);
        if (!result.isSuccess() && result.type() != PoppetUseResult.ResultType.FAIL) {
            result = PoppetUtils.tryUseEntries(PoppetUtils.getPoppetQueue(PoppetShelfManager.getEntriesFor((Player)target), (PoppetShelfSavedData.PoppetEntry entry) -> EItems.isVoodooProtectionPoppet(entry.item().getItem())), (Player)target, null);
        }
        if (result.isSuccess()) {
            if (attacker != null) {
                ServerLevel level = attacker.serverLevel();
                if (result.poppet() == EItems.VOODOO_PROTECTION_POPPET_INFUSED.get()) {
                    LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
                    lightningBolt.moveTo(attacker.getX(), attacker.getY(), attacker.getZ());
                    level.addFreshEntity((Entity)lightningBolt);
                    attacker.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 0));
                }
                level.playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), SoundEvents.ENDER_DRAGON_GROWL, SoundSource.MASTER, 1.0f, 1.0f);
            }
            poppet.shrink(1);
            return false;
        }
        return true;
    }

    public static Queue<ItemStack> getPoppetQueue(Player player, Predicate<PoppetItem> validPoppet) {
        PoppetItem poppet;
        ArrayDeque<ItemStack> poppetQueue = new ArrayDeque<ItemStack>();
        for (ItemStack stack : player.getInventory().items) {
            PoppetItem poppet2;
            Item item = stack.getItem();
            if (!(item instanceof PoppetItem) || !validPoppet.test(poppet2 = (PoppetItem)item)) continue;
            poppetQueue.add(stack);
        }
        ItemStack stack = (ItemStack)player.getInventory().offhand.getFirst();
        Item item = stack.getItem();
        if (item instanceof PoppetItem && validPoppet.test(poppet = (PoppetItem)item)) {
            poppetQueue.add(stack);
        }
        return poppetQueue;
    }

    public static Queue<PoppetShelfSavedData.PoppetEntry> getPoppetQueue(List<PoppetShelfSavedData.PoppetEntry> entries, Predicate<PoppetShelfSavedData.PoppetEntry> validPoppet) {
        ArrayDeque<PoppetShelfSavedData.PoppetEntry> poppetQueue = new ArrayDeque<PoppetShelfSavedData.PoppetEntry>();
        for (PoppetShelfSavedData.PoppetEntry entry : entries) {
            if (!validPoppet.test(entry)) continue;
            poppetQueue.add(entry);
        }
        return poppetQueue;
    }

    public static boolean isBound(ItemStack item) {
        return item.has(EDataComponents.ENTITY_REF.get());
    }

    public static boolean belongsTo(ItemStack item, Player player) {
        return PoppetUtils.belongsTo(item, player.getUUID());
    }

    public static boolean belongsTo(ItemStack item, UUID uuid) {
        if (item.getItem() instanceof PoppetItem && item.has(EDataComponents.ENTITY_REF.get())) {
            return ((EntityRefData)item.get(EDataComponents.ENTITY_REF.get())).uuid().equals(uuid);
        }
        return false;
    }

    public static ServerPlayer getBoundPlayer(ItemStack item, ServerLevel level) {
        if (PoppetUtils.isBound(item)) {
            return level.getServer().getPlayerList().getPlayer(((EntityRefData)item.get(EDataComponents.ENTITY_REF.get())).uuid());
        }
        return null;
    }

    public static String getBoundName(ItemStack item) {
        if (PoppetUtils.isBound(item)) {
            return ((EntityRefData)item.get(EDataComponents.ENTITY_REF.get())).name();
        }
        return "None";
    }

    public static void bind(ItemStack item, Player player) {
        if (item.getItem() instanceof PoppetItem) {
            item.set(EDataComponents.ENTITY_REF.get(), (Object)EntityRefData.of(player.getUUID(), player.getDisplayName().getString()));
        }
    }

    public static void unbind(ItemStack item) {
        if (item.getItem() instanceof PoppetItem) {
            item.remove(EDataComponents.ENTITY_REF.get());
        }
    }

    private static PoppetUseResult tryUsePoppet(@NotNull Player owner, @NotNull ItemStack poppetStack, @Nullable ItemStack protectStack, @Nullable String shelfIdentifier) {
        Level level;
        if (poppetStack.getItem() instanceof PoppetItem && (level = owner.level()) instanceof ServerLevel) {
            Item item;
            ServerLevel level2 = (ServerLevel)level;
            if (protectStack != null && (item = poppetStack.getItem()) instanceof ItemProtectionPoppetItem) {
                ItemProtectionPoppetItem protection = (ItemProtectionPoppetItem)item;
                protection.protect(protectStack);
            } else {
                item = poppetStack.getItem();
                if (item instanceof DeathPoppetItem) {
                    DeathPoppetItem death = (DeathPoppetItem)item;
                    death.protect(owner);
                }
            }
            level2.playSound(null, owner.getX(), owner.getY(), owner.getZ(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 0.5f, 1.0f);
            return PoppetUseResult.of(poppetStack.getItem(), PoppetUtils.damagePoppet(poppetStack, level2, shelfIdentifier));
        }
        return PoppetUseResult.pass();
    }

    public static PoppetUseResult handleTryUsePoppet(@NotNull Player owner, @NotNull ItemStack poppetStack, @Nullable ItemStack protectStack, @Nullable String shelfIdentifier) {
        ItemStack original = poppetStack.copy();
        return PoppetUtils.trySendAnimation(PoppetUtils.tryUsePoppet(owner, poppetStack, protectStack, shelfIdentifier), original, owner);
    }

    public static PoppetUseResult tryUseItems(@NotNull Queue<ItemStack> queue, @NotNull Player owner) {
        return PoppetUtils.tryUseItems(queue, owner, null);
    }

    public static PoppetUseResult tryUseItems(@NotNull Queue<ItemStack> queue, @NotNull Player owner, @Nullable ItemStack protectStack) {
        while (!queue.isEmpty()) {
            PoppetUseResult result;
            ItemStack item = queue.remove();
            if (!PoppetUtils.belongsTo(item, owner) || !(result = PoppetUtils.handleTryUsePoppet(owner, item, protectStack, null)).isSuccess() && result.type() != PoppetUseResult.ResultType.FAIL) continue;
            return result;
        }
        return PoppetUseResult.pass();
    }

    public static PoppetUseResult tryUseEntries(@NotNull Queue<PoppetShelfSavedData.PoppetEntry> queue, @NotNull Player owner) {
        return PoppetUtils.tryUseEntries(queue, owner, null);
    }

    public static PoppetUseResult tryUseEntries(@NotNull Queue<PoppetShelfSavedData.PoppetEntry> queue, @NotNull Player owner, @Nullable ItemStack protectStack) {
        while (!queue.isEmpty()) {
            PoppetShelfSavedData.PoppetEntry entry = queue.remove();
            PoppetUseResult result = PoppetUtils.handleTryUsePoppet(owner, entry.item(), protectStack, entry.shelfIdentifier());
            if (!result.isSuccess() && result.type() != PoppetUseResult.ResultType.FAIL) continue;
            return result;
        }
        return PoppetUseResult.pass();
    }

    public static boolean damagePoppet(ItemStack item, ServerLevel level, String shelfIdentifier) {
        item.setDamageValue(item.getDamageValue() + 1);
        if (item.getDamageValue() >= item.getMaxDamage()) {
            item.shrink(1);
            if (shelfIdentifier != null && item.getCount() <= 0) {
                PoppetShelfSavedData data = PoppetShelfSavedData.get((Level)level);
                PoppetShelfInventory inventory = data.SHELF_STORAGE.get(shelfIdentifier);
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    if (!inventory.get(i).equals(item)) continue;
                    inventory.set(i, ItemStack.EMPTY);
                }
                data.updateShelf(shelfIdentifier);
            }
            return true;
        }
        return false;
    }

    private static PoppetUseResult trySendAnimation(PoppetUseResult result, ItemStack poppetItemOriginal, Player player) {
        if (result.isSuccess() && !player.level().isClientSide) {
            CommonServices.NETWORK.sendToAllPlayers(new PoppetAnimationPayload(result.type(), poppetItemOriginal, player.getId()), player.level().getServer());
        }
        return result;
    }
}

