/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.poppet;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;

public class PoppetUseResult {
    private final Item poppet;
    private final ResultType result;

    private PoppetUseResult(Item poppet, ResultType result) {
        this.poppet = poppet;
        this.result = result;
    }

    public static PoppetUseResult of(Item poppet, boolean isBroken) {
        return isBroken ? PoppetUseResult.successBreak(poppet) : PoppetUseResult.success(poppet);
    }

    public static PoppetUseResult pass() {
        return new PoppetUseResult(null, ResultType.PASS);
    }

    public static PoppetUseResult fail(Item poppet) {
        return new PoppetUseResult(poppet, ResultType.FAIL);
    }

    public static PoppetUseResult success(Item poppet) {
        return new PoppetUseResult(poppet, ResultType.SUCCESS);
    }

    public static PoppetUseResult successBreak(Item poppet) {
        return new PoppetUseResult(poppet, ResultType.SUCCESS_BREAK);
    }

    public Item poppet() {
        return this.poppet;
    }

    public ResultType type() {
        return this.result;
    }

    public boolean isSuccess() {
        return this.result == ResultType.SUCCESS || this.result == ResultType.SUCCESS_BREAK;
    }

    public static enum ResultType {
        SUCCESS,
        SUCCESS_BREAK,
        FAIL,
        PASS;

        public static final StreamCodec<ByteBuf, ResultType> STREAM_CODEC;

        static {
            STREAM_CODEC = StreamCodec.of((buf, val) -> buf.writeByte(val.ordinal()), buf -> ResultType.values()[buf.readByte()]);
        }
    }
}

